// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.datasync.model.DataSyncException
import aws.sdk.kotlin.services.datasync.model.DescribeLocationEfsResponse
import aws.sdk.kotlin.services.datasync.model.Ec2Config
import aws.sdk.kotlin.services.datasync.model.EfsInTransitEncryption
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeLocationEfsOperationDeserializer: HttpDeserialize<DescribeLocationEfsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeLocationEfsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeLocationEfsError(context, response)
        }
        val builder = DescribeLocationEfsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeLocationEfsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeLocationEfsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DataSyncException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DataSyncException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeLocationEfsOperationBody(builder: DescribeLocationEfsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCESSPOINTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AccessPointArn"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val EC2CONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Ec2Config"))
    val FILESYSTEMACCESSROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FileSystemAccessRoleArn"))
    val INTRANSITENCRYPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InTransitEncryption"))
    val LOCATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LocationArn"))
    val LOCATIONURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LocationUri"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSPOINTARN_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(EC2CONFIG_DESCRIPTOR)
        field(FILESYSTEMACCESSROLEARN_DESCRIPTOR)
        field(INTRANSITENCRYPTION_DESCRIPTOR)
        field(LOCATIONARN_DESCRIPTOR)
        field(LOCATIONURI_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSPOINTARN_DESCRIPTOR.index -> builder.accessPointArn = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                EC2CONFIG_DESCRIPTOR.index -> builder.ec2Config = deserializeEc2ConfigDocument(deserializer)
                FILESYSTEMACCESSROLEARN_DESCRIPTOR.index -> builder.fileSystemAccessRoleArn = deserializeString()
                INTRANSITENCRYPTION_DESCRIPTOR.index -> builder.inTransitEncryption = deserializeString().let { EfsInTransitEncryption.fromValue(it) }
                LOCATIONARN_DESCRIPTOR.index -> builder.locationArn = deserializeString()
                LOCATIONURI_DESCRIPTOR.index -> builder.locationUri = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
