// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * CreateAgentRequest
 */
public class CreateAgentRequest private constructor(builder: Builder) {
    /**
     * Your agent activation key. You can get the activation key either by sending an HTTP GET request with redirects that enable you to get the agent IP address (port 80). Alternatively, you can get it from the DataSync console.
     *
     * The redirect URL returned in the response provides you the activation key for your agent in the query string parameter `activationKey`. It might also include other activation-related parameters; however, these are merely defaults. The arguments you pass to this API call determine the actual configuration of your agent.
     *
     * For more information, see Activating an Agent in the *DataSync User Guide.*
     */
    public val activationKey: kotlin.String? = builder.activationKey
    /**
     * The name you configured for your agent. This value is a text reference that is used to identify the agent in the console.
     */
    public val agentName: kotlin.String? = builder.agentName
    /**
     * The ARNs of the security groups used to protect your data transfer task subnets. See [SecurityGroupArns](https://docs.aws.amazon.com/datasync/latest/userguide/API_Ec2Config.html#DataSync-Type-Ec2Config-SecurityGroupArns).
     */
    public val securityGroupArns: List<String>? = builder.securityGroupArns
    /**
     * The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each data transfer task. The agent that runs a task must be private. When you start a task that is associated with an agent created in a VPC, or one that has access to an IP address in a VPC, then the task is also private. In this case, DataSync creates four network interfaces for each task in your subnet. For a data transfer to work, the agent must be able to route to all these four network interfaces.
     */
    public val subnetArns: List<String>? = builder.subnetArns
    /**
     * The key-value pair that represents the tag that you want to associate with the agent. The value can be an empty string. This value helps you manage, filter, and search for your agents.
     *
     * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @.
     */
    public val tags: List<TagListEntry>? = builder.tags
    /**
     * The ID of the VPC (virtual private cloud) endpoint that the agent has access to. This is the client-side VPC endpoint, also called a PrivateLink. If you don't have a PrivateLink VPC endpoint, see [Creating a VPC Endpoint Service Configuration](https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html#create-endpoint-service) in the Amazon VPC User Guide.
     *
     * VPC endpoint ID looks like this: `vpce-01234d5aff67890e1`.
     */
    public val vpcEndpointId: kotlin.String? = builder.vpcEndpointId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.CreateAgentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAgentRequest(")
        append("activationKey=$activationKey,")
        append("agentName=$agentName,")
        append("securityGroupArns=$securityGroupArns,")
        append("subnetArns=$subnetArns,")
        append("tags=$tags,")
        append("vpcEndpointId=$vpcEndpointId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activationKey?.hashCode() ?: 0
        result = 31 * result + (agentName?.hashCode() ?: 0)
        result = 31 * result + (securityGroupArns?.hashCode() ?: 0)
        result = 31 * result + (subnetArns?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAgentRequest

        if (activationKey != other.activationKey) return false
        if (agentName != other.agentName) return false
        if (securityGroupArns != other.securityGroupArns) return false
        if (subnetArns != other.subnetArns) return false
        if (tags != other.tags) return false
        if (vpcEndpointId != other.vpcEndpointId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.CreateAgentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Your agent activation key. You can get the activation key either by sending an HTTP GET request with redirects that enable you to get the agent IP address (port 80). Alternatively, you can get it from the DataSync console.
         *
         * The redirect URL returned in the response provides you the activation key for your agent in the query string parameter `activationKey`. It might also include other activation-related parameters; however, these are merely defaults. The arguments you pass to this API call determine the actual configuration of your agent.
         *
         * For more information, see Activating an Agent in the *DataSync User Guide.*
         */
        public var activationKey: kotlin.String? = null
        /**
         * The name you configured for your agent. This value is a text reference that is used to identify the agent in the console.
         */
        public var agentName: kotlin.String? = null
        /**
         * The ARNs of the security groups used to protect your data transfer task subnets. See [SecurityGroupArns](https://docs.aws.amazon.com/datasync/latest/userguide/API_Ec2Config.html#DataSync-Type-Ec2Config-SecurityGroupArns).
         */
        public var securityGroupArns: List<String>? = null
        /**
         * The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each data transfer task. The agent that runs a task must be private. When you start a task that is associated with an agent created in a VPC, or one that has access to an IP address in a VPC, then the task is also private. In this case, DataSync creates four network interfaces for each task in your subnet. For a data transfer to work, the agent must be able to route to all these four network interfaces.
         */
        public var subnetArns: List<String>? = null
        /**
         * The key-value pair that represents the tag that you want to associate with the agent. The value can be an empty string. This value helps you manage, filter, and search for your agents.
         *
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @.
         */
        public var tags: List<TagListEntry>? = null
        /**
         * The ID of the VPC (virtual private cloud) endpoint that the agent has access to. This is the client-side VPC endpoint, also called a PrivateLink. If you don't have a PrivateLink VPC endpoint, see [Creating a VPC Endpoint Service Configuration](https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html#create-endpoint-service) in the Amazon VPC User Guide.
         *
         * VPC endpoint ID looks like this: `vpce-01234d5aff67890e1`.
         */
        public var vpcEndpointId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.CreateAgentRequest) : this() {
            this.activationKey = x.activationKey
            this.agentName = x.agentName
            this.securityGroupArns = x.securityGroupArns
            this.subnetArns = x.subnetArns
            this.tags = x.tags
            this.vpcEndpointId = x.vpcEndpointId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.CreateAgentRequest = CreateAgentRequest(this)
    }
}
