// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * CreateTaskRequest
 */
public class CreateTaskRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor and log events in the task.
     */
    public val cloudWatchLogGroupArn: kotlin.String? = builder.cloudWatchLogGroupArn
    /**
     * The Amazon Resource Name (ARN) of an Amazon Web Services storage resource's location.
     */
    public val destinationLocationArn: kotlin.String? = builder.destinationLocationArn
    /**
     * A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
     */
    public val excludes: List<FilterRule>? = builder.excludes
    /**
     * A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
     */
    public val includes: List<FilterRule>? = builder.includes
    /**
     * The name of a task. This value is a text reference that is used to identify the task in the console.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The set of configuration options that control the behavior of a single execution of the task that occurs when you call `StartTaskExecution`. You can configure these options to preserve metadata such as user ID (UID) and group ID (GID), file permissions, data integrity verification, and so on.
     *
     * For each individual task execution, you can override these options by specifying the `OverrideOptions` before starting the task execution. For more information, see the [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html) operation.
     */
    public val options: aws.sdk.kotlin.services.datasync.model.Options? = builder.options
    /**
     * Specifies a schedule used to periodically transfer files from a source to a destination location. The schedule should be specified in UTC time. For more information, see [Scheduling your task](https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html).
     */
    public val schedule: aws.sdk.kotlin.services.datasync.model.TaskSchedule? = builder.schedule
    /**
     * The Amazon Resource Name (ARN) of the source location for the task.
     */
    public val sourceLocationArn: kotlin.String? = builder.sourceLocationArn
    /**
     * The key-value pair that represents the tag that you want to add to the resource. The value can be an empty string.
     */
    public val tags: List<TagListEntry>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.CreateTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTaskRequest(")
        append("cloudWatchLogGroupArn=$cloudWatchLogGroupArn,")
        append("destinationLocationArn=$destinationLocationArn,")
        append("excludes=$excludes,")
        append("includes=$includes,")
        append("name=$name,")
        append("options=$options,")
        append("schedule=$schedule,")
        append("sourceLocationArn=$sourceLocationArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (destinationLocationArn?.hashCode() ?: 0)
        result = 31 * result + (excludes?.hashCode() ?: 0)
        result = 31 * result + (includes?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (sourceLocationArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTaskRequest

        if (cloudWatchLogGroupArn != other.cloudWatchLogGroupArn) return false
        if (destinationLocationArn != other.destinationLocationArn) return false
        if (excludes != other.excludes) return false
        if (includes != other.includes) return false
        if (name != other.name) return false
        if (options != other.options) return false
        if (schedule != other.schedule) return false
        if (sourceLocationArn != other.sourceLocationArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.CreateTaskRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor and log events in the task.
         */
        public var cloudWatchLogGroupArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an Amazon Web Services storage resource's location.
         */
        public var destinationLocationArn: kotlin.String? = null
        /**
         * A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
         */
        public var excludes: List<FilterRule>? = null
        /**
         * A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
         */
        public var includes: List<FilterRule>? = null
        /**
         * The name of a task. This value is a text reference that is used to identify the task in the console.
         */
        public var name: kotlin.String? = null
        /**
         * The set of configuration options that control the behavior of a single execution of the task that occurs when you call `StartTaskExecution`. You can configure these options to preserve metadata such as user ID (UID) and group ID (GID), file permissions, data integrity verification, and so on.
         *
         * For each individual task execution, you can override these options by specifying the `OverrideOptions` before starting the task execution. For more information, see the [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html) operation.
         */
        public var options: aws.sdk.kotlin.services.datasync.model.Options? = null
        /**
         * Specifies a schedule used to periodically transfer files from a source to a destination location. The schedule should be specified in UTC time. For more information, see [Scheduling your task](https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html).
         */
        public var schedule: aws.sdk.kotlin.services.datasync.model.TaskSchedule? = null
        /**
         * The Amazon Resource Name (ARN) of the source location for the task.
         */
        public var sourceLocationArn: kotlin.String? = null
        /**
         * The key-value pair that represents the tag that you want to add to the resource. The value can be an empty string.
         */
        public var tags: List<TagListEntry>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.CreateTaskRequest) : this() {
            this.cloudWatchLogGroupArn = x.cloudWatchLogGroupArn
            this.destinationLocationArn = x.destinationLocationArn
            this.excludes = x.excludes
            this.includes = x.includes
            this.name = x.name
            this.options = x.options
            this.schedule = x.schedule
            this.sourceLocationArn = x.sourceLocationArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.CreateTaskRequest = CreateTaskRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.Options] inside the given [block]
         */
        public fun options(block: aws.sdk.kotlin.services.datasync.model.Options.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.datasync.model.Options.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskSchedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.datasync.model.TaskSchedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.datasync.model.TaskSchedule.invoke(block)
        }
    }
}
