// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * Specifies the data transfer protocol that DataSync uses to access your Amazon FSx file system.
 */
public class FsxProtocol private constructor(builder: Builder) {
    /**
     * Specifies the Network File System (NFS) protocol configuration that DataSync uses to access your FSx for OpenZFS file system or FSx for ONTAP file system's storage virtual machine (SVM).
     */
    public val nfs: aws.sdk.kotlin.services.datasync.model.FsxProtocolNfs? = builder.nfs
    /**
     * Specifies the Server Message Block (SMB) protocol configuration that DataSync uses to access your FSx for ONTAP file system's SVM.
     */
    public val smb: aws.sdk.kotlin.services.datasync.model.FsxProtocolSmb? = builder.smb

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.FsxProtocol = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FsxProtocol(")
        append("nfs=$nfs,")
        append("smb=$smb)")
    }

    override fun hashCode(): kotlin.Int {
        var result = nfs?.hashCode() ?: 0
        result = 31 * result + (smb?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FsxProtocol

        if (nfs != other.nfs) return false
        if (smb != other.smb) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.FsxProtocol = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the Network File System (NFS) protocol configuration that DataSync uses to access your FSx for OpenZFS file system or FSx for ONTAP file system's storage virtual machine (SVM).
         */
        public var nfs: aws.sdk.kotlin.services.datasync.model.FsxProtocolNfs? = null
        /**
         * Specifies the Server Message Block (SMB) protocol configuration that DataSync uses to access your FSx for ONTAP file system's SVM.
         */
        public var smb: aws.sdk.kotlin.services.datasync.model.FsxProtocolSmb? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.FsxProtocol) : this() {
            this.nfs = x.nfs
            this.smb = x.smb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.FsxProtocol = FsxProtocol(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.FsxProtocolNfs] inside the given [block]
         */
        public fun nfs(block: aws.sdk.kotlin.services.datasync.model.FsxProtocolNfs.Builder.() -> kotlin.Unit) {
            this.nfs = aws.sdk.kotlin.services.datasync.model.FsxProtocolNfs.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.FsxProtocolSmb] inside the given [block]
         */
        public fun smb(block: aws.sdk.kotlin.services.datasync.model.FsxProtocolSmb.Builder.() -> kotlin.Unit) {
            this.smb = aws.sdk.kotlin.services.datasync.model.FsxProtocolSmb.invoke(block)
        }
    }
}
