// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * The NameNode of the Hadoop Distributed File System (HDFS). The NameNode manages the file system's namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes.
 */
public class HdfsNameNode private constructor(builder: Builder) {
    /**
     * The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the NameNode in the network.
     */
    public val hostname: kotlin.String? = builder.hostname
    /**
     * The port that the NameNode uses to listen to client requests.
     */
    public val port: kotlin.Int? = builder.port

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.HdfsNameNode = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HdfsNameNode(")
        append("hostname=$hostname,")
        append("port=$port)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostname?.hashCode() ?: 0
        result = 31 * result + (port ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HdfsNameNode

        if (hostname != other.hostname) return false
        if (port != other.port) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.HdfsNameNode = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the NameNode in the network.
         */
        public var hostname: kotlin.String? = null
        /**
         * The port that the NameNode uses to listen to client requests.
         */
        public var port: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.HdfsNameNode) : this() {
            this.hostname = x.hostname
            this.port = x.port
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.HdfsNameNode = HdfsNameNode(this)
    }
}
