// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * Narrow down the list of resources returned by `ListLocations`. For example, to see all your Amazon S3 locations, create a filter using `"Name": "LocationType"`, `"Operator": "Equals"`, and `"Values": "S3"`.
 *
 * For more information, see [filtering resources](https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html).
 */
public class LocationFilter private constructor(builder: Builder) {
    /**
     * The name of the filter being used. Each API call supports a list of filters that are available for it (for example, `LocationType` for `ListLocations`).
     */
    public val name: aws.sdk.kotlin.services.datasync.model.LocationFilterName? = builder.name
    /**
     * The operator that is used to compare filter values (for example, `Equals` or `Contains`).
     */
    public val operator: aws.sdk.kotlin.services.datasync.model.Operator? = builder.operator
    /**
     * The values that you want to filter for. For example, you might want to display only Amazon S3 locations.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.LocationFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LocationFilter(")
        append("name=$name,")
        append("operator=$operator,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (operator?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LocationFilter

        if (name != other.name) return false
        if (operator != other.operator) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.LocationFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the filter being used. Each API call supports a list of filters that are available for it (for example, `LocationType` for `ListLocations`).
         */
        public var name: aws.sdk.kotlin.services.datasync.model.LocationFilterName? = null
        /**
         * The operator that is used to compare filter values (for example, `Equals` or `Contains`).
         */
        public var operator: aws.sdk.kotlin.services.datasync.model.Operator? = null
        /**
         * The values that you want to filter for. For example, you might want to display only Amazon S3 locations.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.LocationFilter) : this() {
            this.name = x.name
            this.operator = x.operator
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.LocationFilter = LocationFilter(this)
    }
}
