// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * Represents a single entry in a list of locations. `LocationListEntry` returns an array that contains a list of locations when the [ListLocations](https://docs.aws.amazon.com/datasync/latest/userguide/API_ListLocations.html) operation is called.
 */
public class LocationListEntry private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the location. For Network File System (NFS) or Amazon EFS, the location is the export path. For Amazon S3, the location is the prefix path that you want to mount and use as the root of the location.
     */
    public val locationArn: kotlin.String? = builder.locationArn
    /**
     * Represents a list of URIs of a location. `LocationUri` returns an array that contains a list of locations when the [ListLocations](https://docs.aws.amazon.com/datasync/latest/userguide/API_ListLocations.html) operation is called.
     *
     * Format: `TYPE://GLOBAL_ID/SUBDIR`.
     *
     * TYPE designates the type of location (for example, `nfs` or `s3`).
     *
     * GLOBAL_ID is the globally unique identifier of the resource that backs the location. An example for EFS is `us-east-2.fs-abcd1234`. An example for Amazon S3 is the bucket name, such as `myBucket`. An example for NFS is a valid IPv4 address or a hostname that is compliant with Domain Name Service (DNS).
     *
     * SUBDIR is a valid file system path, delimited by forward slashes as is the *nix convention. For NFS and Amazon EFS, it's the export path to mount the location. For Amazon S3, it's the prefix path that you mount to and treat as the root of the location.
     */
    public val locationUri: kotlin.String? = builder.locationUri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.LocationListEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LocationListEntry(")
        append("locationArn=$locationArn,")
        append("locationUri=$locationUri)")
    }

    override fun hashCode(): kotlin.Int {
        var result = locationArn?.hashCode() ?: 0
        result = 31 * result + (locationUri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LocationListEntry

        if (locationArn != other.locationArn) return false
        if (locationUri != other.locationUri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.LocationListEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the location. For Network File System (NFS) or Amazon EFS, the location is the export path. For Amazon S3, the location is the prefix path that you want to mount and use as the root of the location.
         */
        public var locationArn: kotlin.String? = null
        /**
         * Represents a list of URIs of a location. `LocationUri` returns an array that contains a list of locations when the [ListLocations](https://docs.aws.amazon.com/datasync/latest/userguide/API_ListLocations.html) operation is called.
         *
         * Format: `TYPE://GLOBAL_ID/SUBDIR`.
         *
         * TYPE designates the type of location (for example, `nfs` or `s3`).
         *
         * GLOBAL_ID is the globally unique identifier of the resource that backs the location. An example for EFS is `us-east-2.fs-abcd1234`. An example for Amazon S3 is the bucket name, such as `myBucket`. An example for NFS is a valid IPv4 address or a hostname that is compliant with Domain Name Service (DNS).
         *
         * SUBDIR is a valid file system path, delimited by forward slashes as is the *nix convention. For NFS and Amazon EFS, it's the export path to mount the location. For Amazon S3, it's the prefix path that you mount to and treat as the root of the location.
         */
        public var locationUri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.LocationListEntry) : this() {
            this.locationArn = x.locationArn
            this.locationUri = x.locationUri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.LocationListEntry = LocationListEntry(this)
    }
}
