// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * StartTaskExecutionRequest
 */
public class StartTaskExecutionRequest private constructor(builder: Builder) {
    /**
     * A list of filter rules that determines which files to exclude from a task. The list contains a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
     */
    public val excludes: List<FilterRule>? = builder.excludes
    /**
     * A list of filter rules that determines which files to include when running a task. The pattern should contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
     */
    public val includes: List<FilterRule>? = builder.includes
    /**
     * Represents the options that are available to control the behavior of a [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html) operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.
     *
     * A task has a set of default options associated with it. If you don't specify an option in [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html), the default value is used. You can override the defaults options on each task execution by specifying an overriding `Options` value to [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
     */
    public val overrideOptions: aws.sdk.kotlin.services.datasync.model.Options? = builder.overrideOptions
    /**
     * The Amazon Resource Name (ARN) of the task to start.
     */
    public val taskArn: kotlin.String? = builder.taskArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.StartTaskExecutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartTaskExecutionRequest(")
        append("excludes=$excludes,")
        append("includes=$includes,")
        append("overrideOptions=$overrideOptions,")
        append("taskArn=$taskArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = excludes?.hashCode() ?: 0
        result = 31 * result + (includes?.hashCode() ?: 0)
        result = 31 * result + (overrideOptions?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartTaskExecutionRequest

        if (excludes != other.excludes) return false
        if (includes != other.includes) return false
        if (overrideOptions != other.overrideOptions) return false
        if (taskArn != other.taskArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.StartTaskExecutionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of filter rules that determines which files to exclude from a task. The list contains a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
         */
        public var excludes: List<FilterRule>? = null
        /**
         * A list of filter rules that determines which files to include when running a task. The pattern should contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
         */
        public var includes: List<FilterRule>? = null
        /**
         * Represents the options that are available to control the behavior of a [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html) operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.
         *
         * A task has a set of default options associated with it. If you don't specify an option in [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html), the default value is used. You can override the defaults options on each task execution by specifying an overriding `Options` value to [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
         */
        public var overrideOptions: aws.sdk.kotlin.services.datasync.model.Options? = null
        /**
         * The Amazon Resource Name (ARN) of the task to start.
         */
        public var taskArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.StartTaskExecutionRequest) : this() {
            this.excludes = x.excludes
            this.includes = x.includes
            this.overrideOptions = x.overrideOptions
            this.taskArn = x.taskArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.StartTaskExecutionRequest = StartTaskExecutionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.Options] inside the given [block]
         */
        public fun overrideOptions(block: aws.sdk.kotlin.services.datasync.model.Options.Builder.() -> kotlin.Unit) {
            this.overrideOptions = aws.sdk.kotlin.services.datasync.model.Options.invoke(block)
        }
    }
}
