// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



public class UpdateLocationNfsRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the NFS location to update.
     */
    public val locationArn: kotlin.String? = builder.locationArn
    /**
     * Specifies how DataSync can access a location using the NFS protocol.
     */
    public val mountOptions: aws.sdk.kotlin.services.datasync.model.NfsMountOptions? = builder.mountOptions
    /**
     * A list of Amazon Resource Names (ARNs) of agents to use for a Network File System (NFS) location.
     */
    public val onPremConfig: aws.sdk.kotlin.services.datasync.model.OnPremConfig? = builder.onPremConfig
    /**
     * The subdirectory in the NFS file system that is used to read data from the NFS source location or write data to the NFS destination. The NFS path should be a path that's exported by the NFS server, or a subdirectory of that path. The path should be such that it can be mounted by other NFS clients in your network.
     *
     * To see all the paths exported by your NFS server, run "`showmount -e nfs-server-name`" from an NFS client that has access to your server. You can specify any directory that appears in the results, and any subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos authentication.
     *
     * To transfer all the data in the folder that you specified, DataSync must have permissions to read all the data. To ensure this, either configure the NFS export with `no_root_squash`, or ensure that the files you want DataSync to access have permissions that allow read access for all users. Doing either option enables the agent to read the files. For the agent to access directories, you must additionally enable all execute access.
     *
     * If you are copying data to or from your Snowcone device, see [NFS Server on Snowcone](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone) for more information.
     *
     * For information about NFS export configuration, see 18.7. The /etc/exports Configuration File in the Red Hat Enterprise Linux documentation.
     */
    public val subdirectory: kotlin.String? = builder.subdirectory

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.UpdateLocationNfsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateLocationNfsRequest(")
        append("locationArn=$locationArn,")
        append("mountOptions=$mountOptions,")
        append("onPremConfig=$onPremConfig,")
        append("subdirectory=$subdirectory)")
    }

    override fun hashCode(): kotlin.Int {
        var result = locationArn?.hashCode() ?: 0
        result = 31 * result + (mountOptions?.hashCode() ?: 0)
        result = 31 * result + (onPremConfig?.hashCode() ?: 0)
        result = 31 * result + (subdirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateLocationNfsRequest

        if (locationArn != other.locationArn) return false
        if (mountOptions != other.mountOptions) return false
        if (onPremConfig != other.onPremConfig) return false
        if (subdirectory != other.subdirectory) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.UpdateLocationNfsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the NFS location to update.
         */
        public var locationArn: kotlin.String? = null
        /**
         * Specifies how DataSync can access a location using the NFS protocol.
         */
        public var mountOptions: aws.sdk.kotlin.services.datasync.model.NfsMountOptions? = null
        /**
         * A list of Amazon Resource Names (ARNs) of agents to use for a Network File System (NFS) location.
         */
        public var onPremConfig: aws.sdk.kotlin.services.datasync.model.OnPremConfig? = null
        /**
         * The subdirectory in the NFS file system that is used to read data from the NFS source location or write data to the NFS destination. The NFS path should be a path that's exported by the NFS server, or a subdirectory of that path. The path should be such that it can be mounted by other NFS clients in your network.
         *
         * To see all the paths exported by your NFS server, run "`showmount -e nfs-server-name`" from an NFS client that has access to your server. You can specify any directory that appears in the results, and any subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos authentication.
         *
         * To transfer all the data in the folder that you specified, DataSync must have permissions to read all the data. To ensure this, either configure the NFS export with `no_root_squash`, or ensure that the files you want DataSync to access have permissions that allow read access for all users. Doing either option enables the agent to read the files. For the agent to access directories, you must additionally enable all execute access.
         *
         * If you are copying data to or from your Snowcone device, see [NFS Server on Snowcone](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone) for more information.
         *
         * For information about NFS export configuration, see 18.7. The /etc/exports Configuration File in the Red Hat Enterprise Linux documentation.
         */
        public var subdirectory: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.UpdateLocationNfsRequest) : this() {
            this.locationArn = x.locationArn
            this.mountOptions = x.mountOptions
            this.onPremConfig = x.onPremConfig
            this.subdirectory = x.subdirectory
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.UpdateLocationNfsRequest = UpdateLocationNfsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.NfsMountOptions] inside the given [block]
         */
        public fun mountOptions(block: aws.sdk.kotlin.services.datasync.model.NfsMountOptions.Builder.() -> kotlin.Unit) {
            this.mountOptions = aws.sdk.kotlin.services.datasync.model.NfsMountOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.OnPremConfig] inside the given [block]
         */
        public fun onPremConfig(block: aws.sdk.kotlin.services.datasync.model.OnPremConfig.Builder.() -> kotlin.Unit) {
            this.onPremConfig = aws.sdk.kotlin.services.datasync.model.OnPremConfig.invoke(block)
        }
    }
}
