// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.datasync.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.datasync.model.*
import aws.sdk.kotlin.services.datasync.model.CancelTaskExecutionRequest
import aws.sdk.kotlin.services.datasync.model.CancelTaskExecutionResponse
import aws.sdk.kotlin.services.datasync.model.CreateAgentRequest
import aws.sdk.kotlin.services.datasync.model.CreateAgentResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationEfsRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationEfsResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxLustreRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxLustreResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxOntapRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxOntapResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxOpenZfsRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxOpenZfsResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxWindowsRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxWindowsResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationHdfsRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationHdfsResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationNfsRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationNfsResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationObjectStorageRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationObjectStorageResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationS3Request
import aws.sdk.kotlin.services.datasync.model.CreateLocationS3Response
import aws.sdk.kotlin.services.datasync.model.CreateLocationSmbRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationSmbResponse
import aws.sdk.kotlin.services.datasync.model.CreateTaskRequest
import aws.sdk.kotlin.services.datasync.model.CreateTaskResponse
import aws.sdk.kotlin.services.datasync.model.DeleteAgentRequest
import aws.sdk.kotlin.services.datasync.model.DeleteAgentResponse
import aws.sdk.kotlin.services.datasync.model.DeleteLocationRequest
import aws.sdk.kotlin.services.datasync.model.DeleteLocationResponse
import aws.sdk.kotlin.services.datasync.model.DeleteTaskRequest
import aws.sdk.kotlin.services.datasync.model.DeleteTaskResponse
import aws.sdk.kotlin.services.datasync.model.DescribeAgentRequest
import aws.sdk.kotlin.services.datasync.model.DescribeAgentResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationEfsRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationEfsResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxLustreRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxLustreResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxOntapRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxOntapResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxOpenZfsRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxOpenZfsResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxWindowsRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxWindowsResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationHdfsRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationHdfsResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationNfsRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationNfsResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationObjectStorageRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationObjectStorageResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationS3Request
import aws.sdk.kotlin.services.datasync.model.DescribeLocationS3Response
import aws.sdk.kotlin.services.datasync.model.DescribeLocationSmbRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationSmbResponse
import aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionRequest
import aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse
import aws.sdk.kotlin.services.datasync.model.DescribeTaskRequest
import aws.sdk.kotlin.services.datasync.model.DescribeTaskResponse
import aws.sdk.kotlin.services.datasync.model.ListAgentsRequest
import aws.sdk.kotlin.services.datasync.model.ListAgentsResponse
import aws.sdk.kotlin.services.datasync.model.ListLocationsRequest
import aws.sdk.kotlin.services.datasync.model.ListLocationsResponse
import aws.sdk.kotlin.services.datasync.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.datasync.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.datasync.model.ListTaskExecutionsRequest
import aws.sdk.kotlin.services.datasync.model.ListTaskExecutionsResponse
import aws.sdk.kotlin.services.datasync.model.ListTasksRequest
import aws.sdk.kotlin.services.datasync.model.ListTasksResponse
import aws.sdk.kotlin.services.datasync.model.StartTaskExecutionRequest
import aws.sdk.kotlin.services.datasync.model.StartTaskExecutionResponse
import aws.sdk.kotlin.services.datasync.model.TagResourceRequest
import aws.sdk.kotlin.services.datasync.model.TagResourceResponse
import aws.sdk.kotlin.services.datasync.model.UntagResourceRequest
import aws.sdk.kotlin.services.datasync.model.UntagResourceResponse
import aws.sdk.kotlin.services.datasync.model.UpdateAgentRequest
import aws.sdk.kotlin.services.datasync.model.UpdateAgentResponse
import aws.sdk.kotlin.services.datasync.model.UpdateLocationHdfsRequest
import aws.sdk.kotlin.services.datasync.model.UpdateLocationHdfsResponse
import aws.sdk.kotlin.services.datasync.model.UpdateLocationNfsRequest
import aws.sdk.kotlin.services.datasync.model.UpdateLocationNfsResponse
import aws.sdk.kotlin.services.datasync.model.UpdateLocationObjectStorageRequest
import aws.sdk.kotlin.services.datasync.model.UpdateLocationObjectStorageResponse
import aws.sdk.kotlin.services.datasync.model.UpdateLocationSmbRequest
import aws.sdk.kotlin.services.datasync.model.UpdateLocationSmbResponse
import aws.sdk.kotlin.services.datasync.model.UpdateTaskExecutionRequest
import aws.sdk.kotlin.services.datasync.model.UpdateTaskExecutionResponse
import aws.sdk.kotlin.services.datasync.model.UpdateTaskRequest
import aws.sdk.kotlin.services.datasync.model.UpdateTaskResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # DataSync
 * DataSync is a managed data transfer service that makes it simpler for you to automate moving data between on-premises storage and Amazon Simple Storage Service (Amazon S3) or Amazon Elastic File System (Amazon EFS).
 *
 * This API interface reference for DataSync contains documentation for a programming interface that you can use to manage DataSync.
 */
public interface DataSyncClient : SdkClient {

    override val serviceName: String
        get() = "DataSync"
    /**
     * DataSyncClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): DataSyncClient {
            val config = Config.Builder().apply(block).build()
            return DefaultDataSyncClient(config)
        }

        public operator fun invoke(config: Config): DataSyncClient = DefaultDataSyncClient(config)

        /**
         * Construct a [DataSyncClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): DataSyncClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultDataSyncClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels execution of a task.
     *
     * When you cancel a task execution, the transfer of some files is abruptly interrupted. The contents of files that are transferred to the destination might be incomplete or inconsistent with the source files. However, if you start a new task execution on the same task and you allow the task execution to complete, file content on the destination is complete and consistent. This applies to other unexpected failures that interrupt a task execution. In all of these cases, DataSync successfully complete the transfer when you start the next task execution.
     */
    public suspend fun cancelTaskExecution(input: CancelTaskExecutionRequest): CancelTaskExecutionResponse

    /**
     * Activates an DataSync agent that you have deployed on your host. The activation process associates your agent with your account. In the activation process, you specify information such as the Amazon Web Services Region that you want to activate the agent in. You activate the agent in the Amazon Web Services Region where your target locations (in Amazon S3 or Amazon EFS) reside. Your tasks are created in this Amazon Web Services Region.
     *
     * You can activate the agent in a VPC (virtual private cloud) or provide the agent access to a VPC endpoint so you can run tasks without going over the public internet.
     *
     * You can use an agent for more than one location. If a task uses multiple agents, all of them need to have status AVAILABLE for the task to run. If you use multiple agents for a source location, the status of all the agents must be AVAILABLE for the task to run.
     *
     * Agents are automatically updated by Amazon Web Services on a regular basis, using a mechanism that ensures minimal interruption to your tasks.
     */
    public suspend fun createAgent(input: CreateAgentRequest): CreateAgentResponse

    /**
     * Creates an endpoint for an Amazon EFS file system that DataSync can access for a transfer. For more information, see [Creating a location for Amazon EFS](https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html).
     */
    public suspend fun createLocationEfs(input: CreateLocationEfsRequest): CreateLocationEfsResponse

    /**
     * Creates an endpoint for an Amazon FSx for Lustre file system.
     */
    public suspend fun createLocationFsxLustre(input: CreateLocationFsxLustreRequest): CreateLocationFsxLustreResponse

    /**
     * Creates an endpoint for an Amazon FSx for NetApp ONTAP file system that DataSync can access for a transfer. For more information, see [Creating a location for FSx for ONTAP](https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html).
     */
    public suspend fun createLocationFsxOntap(input: CreateLocationFsxOntapRequest): CreateLocationFsxOntapResponse

    /**
     * Creates an endpoint for an Amazon FSx for OpenZFS file system.
     */
    public suspend fun createLocationFsxOpenZfs(input: CreateLocationFsxOpenZfsRequest): CreateLocationFsxOpenZfsResponse

    /**
     * Creates an endpoint for an Amazon FSx for Windows File Server file system.
     */
    public suspend fun createLocationFsxWindows(input: CreateLocationFsxWindowsRequest): CreateLocationFsxWindowsResponse

    /**
     * Creates an endpoint for a Hadoop Distributed File System (HDFS).
     */
    public suspend fun createLocationHdfs(input: CreateLocationHdfsRequest): CreateLocationHdfsResponse

    /**
     * Defines a file system on a Network File System (NFS) server that can be read from or written to.
     */
    public suspend fun createLocationNfs(input: CreateLocationNfsRequest): CreateLocationNfsResponse

    /**
     * Creates an endpoint for an object storage system that DataSync can access for a transfer. For more information, see [Creating a location for object storage](https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html).
     */
    public suspend fun createLocationObjectStorage(input: CreateLocationObjectStorageRequest): CreateLocationObjectStorageResponse

    /**
     * Creates an endpoint for an Amazon S3 bucket.
     *
     * For more information, see [Create an Amazon S3 location](https://docs.aws.amazon.com/datasync/latest/userguide/create-locations-cli.html#create-location-s3-cli) in the *DataSync User Guide*.
     */
    public suspend fun createLocationS3(input: CreateLocationS3Request): CreateLocationS3Response

    /**
     * Defines a file system on a Server Message Block (SMB) server that can be read from or written to.
     */
    public suspend fun createLocationSmb(input: CreateLocationSmbRequest): CreateLocationSmbResponse

    /**
     * Configures a task, which defines where and how DataSync transfers your data.
     *
     * A task includes a source location, a destination location, and the preferences for how and when you want to transfer your data (such as bandwidth limits, scheduling, among other options).
     *
     * When you create a task that transfers data between Amazon Web Services services in different Amazon Web Services Regions, one of your locations must reside in the Region where you're using DataSync.
     *
     * For more information, see the following topics:
     * + [Working with DataSync locations](https://docs.aws.amazon.com/datasync/latest/userguide/working-with-locations.html)
     * + [Configure DataSync task settings](https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html)
     */
    public suspend fun createTask(input: CreateTaskRequest): CreateTaskResponse

    /**
     * Deletes an agent. To specify which agent to delete, use the Amazon Resource Name (ARN) of the agent in your request. The operation disassociates the agent from your Amazon Web Services account. However, it doesn't delete the agent virtual machine (VM) from your on-premises environment.
     */
    public suspend fun deleteAgent(input: DeleteAgentRequest): DeleteAgentResponse

    /**
     * Deletes the configuration of a location used by DataSync.
     */
    public suspend fun deleteLocation(input: DeleteLocationRequest): DeleteLocationResponse

    /**
     * Deletes a task.
     */
    public suspend fun deleteTask(input: DeleteTaskRequest): DeleteTaskResponse

    /**
     * Returns metadata such as the name, the network interfaces, and the status (that is, whether the agent is running or not) for an agent. To specify which agent to describe, use the Amazon Resource Name (ARN) of the agent in your request.
     */
    public suspend fun describeAgent(input: DescribeAgentRequest): DescribeAgentResponse

    /**
     * Returns metadata about your DataSync location for an Amazon EFS file system.
     */
    public suspend fun describeLocationEfs(input: DescribeLocationEfsRequest): DescribeLocationEfsResponse

    /**
     * Returns metadata about an Amazon FSx for Lustre location, such as information about its path.
     */
    public suspend fun describeLocationFsxLustre(input: DescribeLocationFsxLustreRequest): DescribeLocationFsxLustreResponse

    /**
     * Provides details about how an DataSync location for an Amazon FSx for NetApp ONTAP file system is configured.
     */
    public suspend fun describeLocationFsxOntap(input: DescribeLocationFsxOntapRequest): DescribeLocationFsxOntapResponse

    /**
     * Returns metadata about an Amazon FSx for OpenZFS location, such as information about its path.
     */
    public suspend fun describeLocationFsxOpenZfs(input: DescribeLocationFsxOpenZfsRequest): DescribeLocationFsxOpenZfsResponse

    /**
     * Returns metadata about an Amazon FSx for Windows File Server location, such as information about its path.
     */
    public suspend fun describeLocationFsxWindows(input: DescribeLocationFsxWindowsRequest): DescribeLocationFsxWindowsResponse

    /**
     * Returns metadata, such as the authentication information about the Hadoop Distributed File System (HDFS) location.
     */
    public suspend fun describeLocationHdfs(input: DescribeLocationHdfsRequest): DescribeLocationHdfsResponse

    /**
     * Returns metadata, such as the path information, about an NFS location.
     */
    public suspend fun describeLocationNfs(input: DescribeLocationNfsRequest): DescribeLocationNfsResponse

    /**
     * Returns metadata about your DataSync location for an object storage system.
     */
    public suspend fun describeLocationObjectStorage(input: DescribeLocationObjectStorageRequest): DescribeLocationObjectStorageResponse

    /**
     * Returns metadata, such as bucket name, about an Amazon S3 bucket location.
     */
    public suspend fun describeLocationS3(input: DescribeLocationS3Request): DescribeLocationS3Response

    /**
     * Returns metadata, such as the path and user information about an SMB location.
     */
    public suspend fun describeLocationSmb(input: DescribeLocationSmbRequest): DescribeLocationSmbResponse

    /**
     * Returns metadata about a task.
     */
    public suspend fun describeTask(input: DescribeTaskRequest): DescribeTaskResponse

    /**
     * Returns detailed metadata about a task that is being executed.
     */
    public suspend fun describeTaskExecution(input: DescribeTaskExecutionRequest): DescribeTaskExecutionResponse

    /**
     * Returns a list of agents owned by an Amazon Web Services account in the Amazon Web Services Region specified in the request. The returned list is ordered by agent Amazon Resource Name (ARN).
     *
     * By default, this operation returns a maximum of 100 agents. This operation supports pagination that enables you to optionally reduce the number of agents returned in a response.
     *
     * If you have more agents than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a marker that you can specify in your next request to fetch the next page of agents.
     */
    public suspend fun listAgents(input: ListAgentsRequest = ListAgentsRequest {}): ListAgentsResponse

    /**
     * Returns a list of source and destination locations.
     *
     * If you have more locations than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a token that you can specify in your next request to fetch the next page of locations.
     */
    public suspend fun listLocations(input: ListLocationsRequest = ListLocationsRequest {}): ListLocationsResponse

    /**
     * Returns all the tags associated with a specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of executed tasks.
     */
    public suspend fun listTaskExecutions(input: ListTaskExecutionsRequest = ListTaskExecutionsRequest {}): ListTaskExecutionsResponse

    /**
     * Returns a list of the DataSync tasks you created.
     */
    public suspend fun listTasks(input: ListTasksRequest = ListTasksRequest {}): ListTasksResponse

    /**
     * Starts a specific invocation of a task. A `TaskExecution` value represents an individual run of a task. Each task can have at most one `TaskExecution` at a time.
     *
     * `TaskExecution` has the following transition phases: INITIALIZING | PREPARING | TRANSFERRING | VERIFYING | SUCCESS/FAILURE.
     *
     * For detailed information, see the Task Execution section in the Components and Terminology topic in the *DataSync User Guide*.
     */
    public suspend fun startTaskExecution(input: StartTaskExecutionRequest): StartTaskExecutionResponse

    /**
     * Applies a key-value pair to an Amazon Web Services resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from an Amazon Web Services resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the name of an agent.
     */
    public suspend fun updateAgent(input: UpdateAgentRequest): UpdateAgentResponse

    /**
     * Updates some parameters of a previously created location for a Hadoop Distributed File System cluster.
     */
    public suspend fun updateLocationHdfs(input: UpdateLocationHdfsRequest): UpdateLocationHdfsResponse

    /**
     * Updates some of the parameters of a previously created location for Network File System (NFS) access. For information about creating an NFS location, see [Creating a location for NFS](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html).
     */
    public suspend fun updateLocationNfs(input: UpdateLocationNfsRequest): UpdateLocationNfsResponse

    /**
     * Updates some of the parameters of a previously created location for self-managed object storage server access. For information about creating a self-managed object storage location, see [Creating a location for object storage](https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html).
     */
    public suspend fun updateLocationObjectStorage(input: UpdateLocationObjectStorageRequest): UpdateLocationObjectStorageResponse

    /**
     * Updates some of the parameters of a previously created location for Server Message Block (SMB) file system access. For information about creating an SMB location, see [Creating a location for SMB](https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html).
     */
    public suspend fun updateLocationSmb(input: UpdateLocationSmbRequest): UpdateLocationSmbResponse

    /**
     * Updates the metadata associated with a task.
     */
    public suspend fun updateTask(input: UpdateTaskRequest): UpdateTaskResponse

    /**
     * Updates execution of a task.
     *
     * You can modify bandwidth throttling for a task execution that is running or queued. For more information, see [Adjusting Bandwidth Throttling for a Task Execution](https://docs.aws.amazon.com/datasync/latest/userguide/working-with-task-executions.html#adjust-bandwidth-throttling).
     *
     * The only `Option` that can be modified by `UpdateTaskExecution` is ` <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-BytesPerSecond">BytesPerSecond</a> `.
     */
    public suspend fun updateTaskExecution(input: UpdateTaskExecutionRequest): UpdateTaskExecutionResponse
}

/**
 * Cancels execution of a task.
 *
 * When you cancel a task execution, the transfer of some files is abruptly interrupted. The contents of files that are transferred to the destination might be incomplete or inconsistent with the source files. However, if you start a new task execution on the same task and you allow the task execution to complete, file content on the destination is complete and consistent. This applies to other unexpected failures that interrupt a task execution. In all of these cases, DataSync successfully complete the transfer when you start the next task execution.
 */
public suspend inline fun DataSyncClient.cancelTaskExecution(crossinline block: CancelTaskExecutionRequest.Builder.() -> Unit): CancelTaskExecutionResponse = cancelTaskExecution(CancelTaskExecutionRequest.Builder().apply(block).build())

/**
 * Activates an DataSync agent that you have deployed on your host. The activation process associates your agent with your account. In the activation process, you specify information such as the Amazon Web Services Region that you want to activate the agent in. You activate the agent in the Amazon Web Services Region where your target locations (in Amazon S3 or Amazon EFS) reside. Your tasks are created in this Amazon Web Services Region.
 *
 * You can activate the agent in a VPC (virtual private cloud) or provide the agent access to a VPC endpoint so you can run tasks without going over the public internet.
 *
 * You can use an agent for more than one location. If a task uses multiple agents, all of them need to have status AVAILABLE for the task to run. If you use multiple agents for a source location, the status of all the agents must be AVAILABLE for the task to run.
 *
 * Agents are automatically updated by Amazon Web Services on a regular basis, using a mechanism that ensures minimal interruption to your tasks.
 */
public suspend inline fun DataSyncClient.createAgent(crossinline block: CreateAgentRequest.Builder.() -> Unit): CreateAgentResponse = createAgent(CreateAgentRequest.Builder().apply(block).build())

/**
 * Creates an endpoint for an Amazon EFS file system that DataSync can access for a transfer. For more information, see [Creating a location for Amazon EFS](https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html).
 */
public suspend inline fun DataSyncClient.createLocationEfs(crossinline block: CreateLocationEfsRequest.Builder.() -> Unit): CreateLocationEfsResponse = createLocationEfs(CreateLocationEfsRequest.Builder().apply(block).build())

/**
 * Creates an endpoint for an Amazon FSx for Lustre file system.
 */
public suspend inline fun DataSyncClient.createLocationFsxLustre(crossinline block: CreateLocationFsxLustreRequest.Builder.() -> Unit): CreateLocationFsxLustreResponse = createLocationFsxLustre(CreateLocationFsxLustreRequest.Builder().apply(block).build())

/**
 * Creates an endpoint for an Amazon FSx for NetApp ONTAP file system that DataSync can access for a transfer. For more information, see [Creating a location for FSx for ONTAP](https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html).
 */
public suspend inline fun DataSyncClient.createLocationFsxOntap(crossinline block: CreateLocationFsxOntapRequest.Builder.() -> Unit): CreateLocationFsxOntapResponse = createLocationFsxOntap(CreateLocationFsxOntapRequest.Builder().apply(block).build())

/**
 * Creates an endpoint for an Amazon FSx for OpenZFS file system.
 */
public suspend inline fun DataSyncClient.createLocationFsxOpenZfs(crossinline block: CreateLocationFsxOpenZfsRequest.Builder.() -> Unit): CreateLocationFsxOpenZfsResponse = createLocationFsxOpenZfs(CreateLocationFsxOpenZfsRequest.Builder().apply(block).build())

/**
 * Creates an endpoint for an Amazon FSx for Windows File Server file system.
 */
public suspend inline fun DataSyncClient.createLocationFsxWindows(crossinline block: CreateLocationFsxWindowsRequest.Builder.() -> Unit): CreateLocationFsxWindowsResponse = createLocationFsxWindows(CreateLocationFsxWindowsRequest.Builder().apply(block).build())

/**
 * Creates an endpoint for a Hadoop Distributed File System (HDFS).
 */
public suspend inline fun DataSyncClient.createLocationHdfs(crossinline block: CreateLocationHdfsRequest.Builder.() -> Unit): CreateLocationHdfsResponse = createLocationHdfs(CreateLocationHdfsRequest.Builder().apply(block).build())

/**
 * Defines a file system on a Network File System (NFS) server that can be read from or written to.
 */
public suspend inline fun DataSyncClient.createLocationNfs(crossinline block: CreateLocationNfsRequest.Builder.() -> Unit): CreateLocationNfsResponse = createLocationNfs(CreateLocationNfsRequest.Builder().apply(block).build())

/**
 * Creates an endpoint for an object storage system that DataSync can access for a transfer. For more information, see [Creating a location for object storage](https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html).
 */
public suspend inline fun DataSyncClient.createLocationObjectStorage(crossinline block: CreateLocationObjectStorageRequest.Builder.() -> Unit): CreateLocationObjectStorageResponse = createLocationObjectStorage(CreateLocationObjectStorageRequest.Builder().apply(block).build())

/**
 * Creates an endpoint for an Amazon S3 bucket.
 *
 * For more information, see [Create an Amazon S3 location](https://docs.aws.amazon.com/datasync/latest/userguide/create-locations-cli.html#create-location-s3-cli) in the *DataSync User Guide*.
 */
public suspend inline fun DataSyncClient.createLocationS3(crossinline block: CreateLocationS3Request.Builder.() -> Unit): CreateLocationS3Response = createLocationS3(CreateLocationS3Request.Builder().apply(block).build())

/**
 * Defines a file system on a Server Message Block (SMB) server that can be read from or written to.
 */
public suspend inline fun DataSyncClient.createLocationSmb(crossinline block: CreateLocationSmbRequest.Builder.() -> Unit): CreateLocationSmbResponse = createLocationSmb(CreateLocationSmbRequest.Builder().apply(block).build())

/**
 * Configures a task, which defines where and how DataSync transfers your data.
 *
 * A task includes a source location, a destination location, and the preferences for how and when you want to transfer your data (such as bandwidth limits, scheduling, among other options).
 *
 * When you create a task that transfers data between Amazon Web Services services in different Amazon Web Services Regions, one of your locations must reside in the Region where you're using DataSync.
 *
 * For more information, see the following topics:
 * + [Working with DataSync locations](https://docs.aws.amazon.com/datasync/latest/userguide/working-with-locations.html)
 * + [Configure DataSync task settings](https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html)
 */
public suspend inline fun DataSyncClient.createTask(crossinline block: CreateTaskRequest.Builder.() -> Unit): CreateTaskResponse = createTask(CreateTaskRequest.Builder().apply(block).build())

/**
 * Deletes an agent. To specify which agent to delete, use the Amazon Resource Name (ARN) of the agent in your request. The operation disassociates the agent from your Amazon Web Services account. However, it doesn't delete the agent virtual machine (VM) from your on-premises environment.
 */
public suspend inline fun DataSyncClient.deleteAgent(crossinline block: DeleteAgentRequest.Builder.() -> Unit): DeleteAgentResponse = deleteAgent(DeleteAgentRequest.Builder().apply(block).build())

/**
 * Deletes the configuration of a location used by DataSync.
 */
public suspend inline fun DataSyncClient.deleteLocation(crossinline block: DeleteLocationRequest.Builder.() -> Unit): DeleteLocationResponse = deleteLocation(DeleteLocationRequest.Builder().apply(block).build())

/**
 * Deletes a task.
 */
public suspend inline fun DataSyncClient.deleteTask(crossinline block: DeleteTaskRequest.Builder.() -> Unit): DeleteTaskResponse = deleteTask(DeleteTaskRequest.Builder().apply(block).build())

/**
 * Returns metadata such as the name, the network interfaces, and the status (that is, whether the agent is running or not) for an agent. To specify which agent to describe, use the Amazon Resource Name (ARN) of the agent in your request.
 */
public suspend inline fun DataSyncClient.describeAgent(crossinline block: DescribeAgentRequest.Builder.() -> Unit): DescribeAgentResponse = describeAgent(DescribeAgentRequest.Builder().apply(block).build())

/**
 * Returns metadata about your DataSync location for an Amazon EFS file system.
 */
public suspend inline fun DataSyncClient.describeLocationEfs(crossinline block: DescribeLocationEfsRequest.Builder.() -> Unit): DescribeLocationEfsResponse = describeLocationEfs(DescribeLocationEfsRequest.Builder().apply(block).build())

/**
 * Returns metadata about an Amazon FSx for Lustre location, such as information about its path.
 */
public suspend inline fun DataSyncClient.describeLocationFsxLustre(crossinline block: DescribeLocationFsxLustreRequest.Builder.() -> Unit): DescribeLocationFsxLustreResponse = describeLocationFsxLustre(DescribeLocationFsxLustreRequest.Builder().apply(block).build())

/**
 * Provides details about how an DataSync location for an Amazon FSx for NetApp ONTAP file system is configured.
 */
public suspend inline fun DataSyncClient.describeLocationFsxOntap(crossinline block: DescribeLocationFsxOntapRequest.Builder.() -> Unit): DescribeLocationFsxOntapResponse = describeLocationFsxOntap(DescribeLocationFsxOntapRequest.Builder().apply(block).build())

/**
 * Returns metadata about an Amazon FSx for OpenZFS location, such as information about its path.
 */
public suspend inline fun DataSyncClient.describeLocationFsxOpenZfs(crossinline block: DescribeLocationFsxOpenZfsRequest.Builder.() -> Unit): DescribeLocationFsxOpenZfsResponse = describeLocationFsxOpenZfs(DescribeLocationFsxOpenZfsRequest.Builder().apply(block).build())

/**
 * Returns metadata about an Amazon FSx for Windows File Server location, such as information about its path.
 */
public suspend inline fun DataSyncClient.describeLocationFsxWindows(crossinline block: DescribeLocationFsxWindowsRequest.Builder.() -> Unit): DescribeLocationFsxWindowsResponse = describeLocationFsxWindows(DescribeLocationFsxWindowsRequest.Builder().apply(block).build())

/**
 * Returns metadata, such as the authentication information about the Hadoop Distributed File System (HDFS) location.
 */
public suspend inline fun DataSyncClient.describeLocationHdfs(crossinline block: DescribeLocationHdfsRequest.Builder.() -> Unit): DescribeLocationHdfsResponse = describeLocationHdfs(DescribeLocationHdfsRequest.Builder().apply(block).build())

/**
 * Returns metadata, such as the path information, about an NFS location.
 */
public suspend inline fun DataSyncClient.describeLocationNfs(crossinline block: DescribeLocationNfsRequest.Builder.() -> Unit): DescribeLocationNfsResponse = describeLocationNfs(DescribeLocationNfsRequest.Builder().apply(block).build())

/**
 * Returns metadata about your DataSync location for an object storage system.
 */
public suspend inline fun DataSyncClient.describeLocationObjectStorage(crossinline block: DescribeLocationObjectStorageRequest.Builder.() -> Unit): DescribeLocationObjectStorageResponse = describeLocationObjectStorage(DescribeLocationObjectStorageRequest.Builder().apply(block).build())

/**
 * Returns metadata, such as bucket name, about an Amazon S3 bucket location.
 */
public suspend inline fun DataSyncClient.describeLocationS3(crossinline block: DescribeLocationS3Request.Builder.() -> Unit): DescribeLocationS3Response = describeLocationS3(DescribeLocationS3Request.Builder().apply(block).build())

/**
 * Returns metadata, such as the path and user information about an SMB location.
 */
public suspend inline fun DataSyncClient.describeLocationSmb(crossinline block: DescribeLocationSmbRequest.Builder.() -> Unit): DescribeLocationSmbResponse = describeLocationSmb(DescribeLocationSmbRequest.Builder().apply(block).build())

/**
 * Returns metadata about a task.
 */
public suspend inline fun DataSyncClient.describeTask(crossinline block: DescribeTaskRequest.Builder.() -> Unit): DescribeTaskResponse = describeTask(DescribeTaskRequest.Builder().apply(block).build())

/**
 * Returns detailed metadata about a task that is being executed.
 */
public suspend inline fun DataSyncClient.describeTaskExecution(crossinline block: DescribeTaskExecutionRequest.Builder.() -> Unit): DescribeTaskExecutionResponse = describeTaskExecution(DescribeTaskExecutionRequest.Builder().apply(block).build())

/**
 * Returns a list of agents owned by an Amazon Web Services account in the Amazon Web Services Region specified in the request. The returned list is ordered by agent Amazon Resource Name (ARN).
 *
 * By default, this operation returns a maximum of 100 agents. This operation supports pagination that enables you to optionally reduce the number of agents returned in a response.
 *
 * If you have more agents than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a marker that you can specify in your next request to fetch the next page of agents.
 */
public suspend inline fun DataSyncClient.listAgents(crossinline block: ListAgentsRequest.Builder.() -> Unit): ListAgentsResponse = listAgents(ListAgentsRequest.Builder().apply(block).build())

/**
 * Returns a list of source and destination locations.
 *
 * If you have more locations than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a token that you can specify in your next request to fetch the next page of locations.
 */
public suspend inline fun DataSyncClient.listLocations(crossinline block: ListLocationsRequest.Builder.() -> Unit): ListLocationsResponse = listLocations(ListLocationsRequest.Builder().apply(block).build())

/**
 * Returns all the tags associated with a specified resource.
 */
public suspend inline fun DataSyncClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of executed tasks.
 */
public suspend inline fun DataSyncClient.listTaskExecutions(crossinline block: ListTaskExecutionsRequest.Builder.() -> Unit): ListTaskExecutionsResponse = listTaskExecutions(ListTaskExecutionsRequest.Builder().apply(block).build())

/**
 * Returns a list of the DataSync tasks you created.
 */
public suspend inline fun DataSyncClient.listTasks(crossinline block: ListTasksRequest.Builder.() -> Unit): ListTasksResponse = listTasks(ListTasksRequest.Builder().apply(block).build())

/**
 * Starts a specific invocation of a task. A `TaskExecution` value represents an individual run of a task. Each task can have at most one `TaskExecution` at a time.
 *
 * `TaskExecution` has the following transition phases: INITIALIZING | PREPARING | TRANSFERRING | VERIFYING | SUCCESS/FAILURE.
 *
 * For detailed information, see the Task Execution section in the Components and Terminology topic in the *DataSync User Guide*.
 */
public suspend inline fun DataSyncClient.startTaskExecution(crossinline block: StartTaskExecutionRequest.Builder.() -> Unit): StartTaskExecutionResponse = startTaskExecution(StartTaskExecutionRequest.Builder().apply(block).build())

/**
 * Applies a key-value pair to an Amazon Web Services resource.
 */
public suspend inline fun DataSyncClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from an Amazon Web Services resource.
 */
public suspend inline fun DataSyncClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the name of an agent.
 */
public suspend inline fun DataSyncClient.updateAgent(crossinline block: UpdateAgentRequest.Builder.() -> Unit): UpdateAgentResponse = updateAgent(UpdateAgentRequest.Builder().apply(block).build())

/**
 * Updates some parameters of a previously created location for a Hadoop Distributed File System cluster.
 */
public suspend inline fun DataSyncClient.updateLocationHdfs(crossinline block: UpdateLocationHdfsRequest.Builder.() -> Unit): UpdateLocationHdfsResponse = updateLocationHdfs(UpdateLocationHdfsRequest.Builder().apply(block).build())

/**
 * Updates some of the parameters of a previously created location for Network File System (NFS) access. For information about creating an NFS location, see [Creating a location for NFS](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html).
 */
public suspend inline fun DataSyncClient.updateLocationNfs(crossinline block: UpdateLocationNfsRequest.Builder.() -> Unit): UpdateLocationNfsResponse = updateLocationNfs(UpdateLocationNfsRequest.Builder().apply(block).build())

/**
 * Updates some of the parameters of a previously created location for self-managed object storage server access. For information about creating a self-managed object storage location, see [Creating a location for object storage](https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html).
 */
public suspend inline fun DataSyncClient.updateLocationObjectStorage(crossinline block: UpdateLocationObjectStorageRequest.Builder.() -> Unit): UpdateLocationObjectStorageResponse = updateLocationObjectStorage(UpdateLocationObjectStorageRequest.Builder().apply(block).build())

/**
 * Updates some of the parameters of a previously created location for Server Message Block (SMB) file system access. For information about creating an SMB location, see [Creating a location for SMB](https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html).
 */
public suspend inline fun DataSyncClient.updateLocationSmb(crossinline block: UpdateLocationSmbRequest.Builder.() -> Unit): UpdateLocationSmbResponse = updateLocationSmb(UpdateLocationSmbRequest.Builder().apply(block).build())

/**
 * Updates the metadata associated with a task.
 */
public suspend inline fun DataSyncClient.updateTask(crossinline block: UpdateTaskRequest.Builder.() -> Unit): UpdateTaskResponse = updateTask(UpdateTaskRequest.Builder().apply(block).build())

/**
 * Updates execution of a task.
 *
 * You can modify bandwidth throttling for a task execution that is running or queued. For more information, see [Adjusting Bandwidth Throttling for a Task Execution](https://docs.aws.amazon.com/datasync/latest/userguide/working-with-task-executions.html#adjust-bandwidth-throttling).
 *
 * The only `Option` that can be modified by `UpdateTaskExecution` is ` <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-BytesPerSecond">BytesPerSecond</a> `.
 */
public suspend inline fun DataSyncClient.updateTaskExecution(crossinline block: UpdateTaskExecutionRequest.Builder.() -> Unit): UpdateTaskExecutionResponse = updateTaskExecution(UpdateTaskExecutionRequest.Builder().apply(block).build())
