// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



public class CreateLocationHdfsRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Names (ARNs) of the agents that are used to connect to the HDFS cluster.
     */
    public val agentArns: List<String>? = builder.agentArns
    /**
     * The type of authentication used to determine the identity of the user.
     */
    public val authenticationType: aws.sdk.kotlin.services.datasync.model.HdfsAuthenticationType? = builder.authenticationType
    /**
     * The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
     */
    public val blockSize: kotlin.Int? = builder.blockSize
    /**
     * The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. You can load the keytab from a file by providing the file's address. If you're using the CLI, it performs base64 encoding for you. Otherwise, provide the base64-encoded text.
     *
     * If `KERBEROS` is specified for `AuthenticationType`, this parameter is required.
     */
    public val kerberosKeytab: kotlin.ByteArray? = builder.kerberosKeytab
    /**
     * The `krb5.conf` file that contains the Kerberos configuration information. You can load the `krb5.conf` file by providing the file's address. If you're using the CLI, it performs the base64 encoding for you. Otherwise, provide the base64-encoded text.
     *
     * If `KERBEROS` is specified for `AuthenticationType`, this parameter is required.
     */
    public val kerberosKrb5Conf: kotlin.ByteArray? = builder.kerberosKrb5Conf
    /**
     * The Kerberos principal with access to the files and folders on the HDFS cluster.
     *
     * If `KERBEROS` is specified for `AuthenticationType`, this parameter is required.
     */
    public val kerberosPrincipal: kotlin.String? = builder.kerberosPrincipal
    /**
     * The URI of the HDFS cluster's Key Management Server (KMS).
     */
    public val kmsKeyProviderUri: kotlin.String? = builder.kmsKeyProviderUri
    /**
     * The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode.
     */
    public val nameNodes: List<HdfsNameNode>? = builder.nameNodes
    /**
     * The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `QopConfiguration` isn't specified, `RpcProtection` and `DataTransferProtection` default to `PRIVACY`. If you set `RpcProtection` or `DataTransferProtection`, the other parameter assumes the same value.
     */
    public val qopConfiguration: aws.sdk.kotlin.services.datasync.model.QopConfiguration? = builder.qopConfiguration
    /**
     * The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
     */
    public val replicationFactor: kotlin.Int? = builder.replicationFactor
    /**
     * The user name used to identify the client on the host operating system.
     *
     * If `SIMPLE` is specified for `AuthenticationType`, this parameter is required.
     */
    public val simpleUser: kotlin.String? = builder.simpleUser
    /**
     * A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to `/`.
     */
    public val subdirectory: kotlin.String? = builder.subdirectory
    /**
     * The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.
     */
    public val tags: List<TagListEntry>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.CreateLocationHdfsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLocationHdfsRequest(")
        append("agentArns=$agentArns,")
        append("authenticationType=$authenticationType,")
        append("blockSize=$blockSize,")
        append("kerberosKeytab=$kerberosKeytab,")
        append("kerberosKrb5Conf=$kerberosKrb5Conf,")
        append("kerberosPrincipal=$kerberosPrincipal,")
        append("kmsKeyProviderUri=$kmsKeyProviderUri,")
        append("nameNodes=$nameNodes,")
        append("qopConfiguration=$qopConfiguration,")
        append("replicationFactor=$replicationFactor,")
        append("simpleUser=$simpleUser,")
        append("subdirectory=$subdirectory,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentArns?.hashCode() ?: 0
        result = 31 * result + (authenticationType?.hashCode() ?: 0)
        result = 31 * result + (blockSize ?: 0)
        result = 31 * result + (kerberosKeytab?.contentHashCode() ?: 0)
        result = 31 * result + (kerberosKrb5Conf?.contentHashCode() ?: 0)
        result = 31 * result + (kerberosPrincipal?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyProviderUri?.hashCode() ?: 0)
        result = 31 * result + (nameNodes?.hashCode() ?: 0)
        result = 31 * result + (qopConfiguration?.hashCode() ?: 0)
        result = 31 * result + (replicationFactor ?: 0)
        result = 31 * result + (simpleUser?.hashCode() ?: 0)
        result = 31 * result + (subdirectory?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLocationHdfsRequest

        if (agentArns != other.agentArns) return false
        if (authenticationType != other.authenticationType) return false
        if (blockSize != other.blockSize) return false
        if (kerberosKeytab != null) {
            if (other.kerberosKeytab == null) return false
            if (!kerberosKeytab.contentEquals(other.kerberosKeytab)) return false
        } else if (other.kerberosKeytab != null) return false
        if (kerberosKrb5Conf != null) {
            if (other.kerberosKrb5Conf == null) return false
            if (!kerberosKrb5Conf.contentEquals(other.kerberosKrb5Conf)) return false
        } else if (other.kerberosKrb5Conf != null) return false
        if (kerberosPrincipal != other.kerberosPrincipal) return false
        if (kmsKeyProviderUri != other.kmsKeyProviderUri) return false
        if (nameNodes != other.nameNodes) return false
        if (qopConfiguration != other.qopConfiguration) return false
        if (replicationFactor != other.replicationFactor) return false
        if (simpleUser != other.simpleUser) return false
        if (subdirectory != other.subdirectory) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.CreateLocationHdfsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Names (ARNs) of the agents that are used to connect to the HDFS cluster.
         */
        public var agentArns: List<String>? = null
        /**
         * The type of authentication used to determine the identity of the user.
         */
        public var authenticationType: aws.sdk.kotlin.services.datasync.model.HdfsAuthenticationType? = null
        /**
         * The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
         */
        public var blockSize: kotlin.Int? = null
        /**
         * The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. You can load the keytab from a file by providing the file's address. If you're using the CLI, it performs base64 encoding for you. Otherwise, provide the base64-encoded text.
         *
         * If `KERBEROS` is specified for `AuthenticationType`, this parameter is required.
         */
        public var kerberosKeytab: kotlin.ByteArray? = null
        /**
         * The `krb5.conf` file that contains the Kerberos configuration information. You can load the `krb5.conf` file by providing the file's address. If you're using the CLI, it performs the base64 encoding for you. Otherwise, provide the base64-encoded text.
         *
         * If `KERBEROS` is specified for `AuthenticationType`, this parameter is required.
         */
        public var kerberosKrb5Conf: kotlin.ByteArray? = null
        /**
         * The Kerberos principal with access to the files and folders on the HDFS cluster.
         *
         * If `KERBEROS` is specified for `AuthenticationType`, this parameter is required.
         */
        public var kerberosPrincipal: kotlin.String? = null
        /**
         * The URI of the HDFS cluster's Key Management Server (KMS).
         */
        public var kmsKeyProviderUri: kotlin.String? = null
        /**
         * The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode.
         */
        public var nameNodes: List<HdfsNameNode>? = null
        /**
         * The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `QopConfiguration` isn't specified, `RpcProtection` and `DataTransferProtection` default to `PRIVACY`. If you set `RpcProtection` or `DataTransferProtection`, the other parameter assumes the same value.
         */
        public var qopConfiguration: aws.sdk.kotlin.services.datasync.model.QopConfiguration? = null
        /**
         * The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
         */
        public var replicationFactor: kotlin.Int? = null
        /**
         * The user name used to identify the client on the host operating system.
         *
         * If `SIMPLE` is specified for `AuthenticationType`, this parameter is required.
         */
        public var simpleUser: kotlin.String? = null
        /**
         * A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to `/`.
         */
        public var subdirectory: kotlin.String? = null
        /**
         * The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.
         */
        public var tags: List<TagListEntry>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.CreateLocationHdfsRequest) : this() {
            this.agentArns = x.agentArns
            this.authenticationType = x.authenticationType
            this.blockSize = x.blockSize
            this.kerberosKeytab = x.kerberosKeytab
            this.kerberosKrb5Conf = x.kerberosKrb5Conf
            this.kerberosPrincipal = x.kerberosPrincipal
            this.kmsKeyProviderUri = x.kmsKeyProviderUri
            this.nameNodes = x.nameNodes
            this.qopConfiguration = x.qopConfiguration
            this.replicationFactor = x.replicationFactor
            this.simpleUser = x.simpleUser
            this.subdirectory = x.subdirectory
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.CreateLocationHdfsRequest = CreateLocationHdfsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.QopConfiguration] inside the given [block]
         */
        public fun qopConfiguration(block: aws.sdk.kotlin.services.datasync.model.QopConfiguration.Builder.() -> kotlin.Unit) {
            this.qopConfiguration = aws.sdk.kotlin.services.datasync.model.QopConfiguration.invoke(block)
        }
    }
}
