// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * CreateLocationNfsRequest
 */
public class CreateLocationNfsRequest private constructor(builder: Builder) {
    /**
     * The NFS mount options that DataSync can use to mount your NFS share.
     */
    public val mountOptions: aws.sdk.kotlin.services.datasync.model.NfsMountOptions? = builder.mountOptions
    /**
     * Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect to an NFS server.
     *
     * If you are copying data to or from your Snowcone device, see [NFS Server on Snowcone](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone) for more information.
     */
    public val onPremConfig: aws.sdk.kotlin.services.datasync.model.OnPremConfig? = builder.onPremConfig
    /**
     * The name of the NFS server. This value is the IP address or Domain Name Service (DNS) name of the NFS server. An agent that is installed on-premises uses this hostname to mount the NFS server in a network.
     *
     * If you are copying data to or from your Snowcone device, see [NFS Server on Snowcone](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone) for more information.
     *
     * This name must either be DNS-compliant or must be an IP version 4 (IPv4) address.
     */
    public val serverHostname: kotlin.String? = builder.serverHostname
    /**
     * The subdirectory in the NFS file system that is used to read data from the NFS source location or write data to the NFS destination. The NFS path should be a path that's exported by the NFS server, or a subdirectory of that path. The path should be such that it can be mounted by other NFS clients in your network.
     *
     * To see all the paths exported by your NFS server, run "`showmount -e nfs-server-name`" from an NFS client that has access to your server. You can specify any directory that appears in the results, and any subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos authentication.
     *
     * To transfer all the data in the folder you specified, DataSync needs to have permissions to read all the data. To ensure this, either configure the NFS export with `no_root_squash,` or ensure that the permissions for all of the files that you want DataSync allow read access for all users. Doing either enables the agent to read the files. For the agent to access directories, you must additionally enable all execute access.
     *
     * If you are copying data to or from your Snowcone device, see [NFS Server on Snowcone](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone) for more information.
     *
     * For information about NFS export configuration, see 18.7. The /etc/exports Configuration File in the Red Hat Enterprise Linux documentation.
     */
    public val subdirectory: kotlin.String? = builder.subdirectory
    /**
     * The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.
     */
    public val tags: List<TagListEntry>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.CreateLocationNfsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLocationNfsRequest(")
        append("mountOptions=$mountOptions,")
        append("onPremConfig=$onPremConfig,")
        append("serverHostname=$serverHostname,")
        append("subdirectory=$subdirectory,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = mountOptions?.hashCode() ?: 0
        result = 31 * result + (onPremConfig?.hashCode() ?: 0)
        result = 31 * result + (serverHostname?.hashCode() ?: 0)
        result = 31 * result + (subdirectory?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLocationNfsRequest

        if (mountOptions != other.mountOptions) return false
        if (onPremConfig != other.onPremConfig) return false
        if (serverHostname != other.serverHostname) return false
        if (subdirectory != other.subdirectory) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.CreateLocationNfsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The NFS mount options that DataSync can use to mount your NFS share.
         */
        public var mountOptions: aws.sdk.kotlin.services.datasync.model.NfsMountOptions? = null
        /**
         * Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect to an NFS server.
         *
         * If you are copying data to or from your Snowcone device, see [NFS Server on Snowcone](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone) for more information.
         */
        public var onPremConfig: aws.sdk.kotlin.services.datasync.model.OnPremConfig? = null
        /**
         * The name of the NFS server. This value is the IP address or Domain Name Service (DNS) name of the NFS server. An agent that is installed on-premises uses this hostname to mount the NFS server in a network.
         *
         * If you are copying data to or from your Snowcone device, see [NFS Server on Snowcone](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone) for more information.
         *
         * This name must either be DNS-compliant or must be an IP version 4 (IPv4) address.
         */
        public var serverHostname: kotlin.String? = null
        /**
         * The subdirectory in the NFS file system that is used to read data from the NFS source location or write data to the NFS destination. The NFS path should be a path that's exported by the NFS server, or a subdirectory of that path. The path should be such that it can be mounted by other NFS clients in your network.
         *
         * To see all the paths exported by your NFS server, run "`showmount -e nfs-server-name`" from an NFS client that has access to your server. You can specify any directory that appears in the results, and any subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos authentication.
         *
         * To transfer all the data in the folder you specified, DataSync needs to have permissions to read all the data. To ensure this, either configure the NFS export with `no_root_squash,` or ensure that the permissions for all of the files that you want DataSync allow read access for all users. Doing either enables the agent to read the files. For the agent to access directories, you must additionally enable all execute access.
         *
         * If you are copying data to or from your Snowcone device, see [NFS Server on Snowcone](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone) for more information.
         *
         * For information about NFS export configuration, see 18.7. The /etc/exports Configuration File in the Red Hat Enterprise Linux documentation.
         */
        public var subdirectory: kotlin.String? = null
        /**
         * The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.
         */
        public var tags: List<TagListEntry>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.CreateLocationNfsRequest) : this() {
            this.mountOptions = x.mountOptions
            this.onPremConfig = x.onPremConfig
            this.serverHostname = x.serverHostname
            this.subdirectory = x.subdirectory
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.CreateLocationNfsRequest = CreateLocationNfsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.NfsMountOptions] inside the given [block]
         */
        public fun mountOptions(block: aws.sdk.kotlin.services.datasync.model.NfsMountOptions.Builder.() -> kotlin.Unit) {
            this.mountOptions = aws.sdk.kotlin.services.datasync.model.NfsMountOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.OnPremConfig] inside the given [block]
         */
        public fun onPremConfig(block: aws.sdk.kotlin.services.datasync.model.OnPremConfig.Builder.() -> kotlin.Unit) {
            this.onPremConfig = aws.sdk.kotlin.services.datasync.model.OnPremConfig.invoke(block)
        }
    }
}
