// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * UpdateTaskResponse
 */
public class UpdateTaskRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the resource name of the Amazon CloudWatch log group.
     */
    public val cloudWatchLogGroupArn: kotlin.String? = builder.cloudWatchLogGroupArn
    /**
     * A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
     */
    public val excludes: List<FilterRule>? = builder.excludes
    /**
     * A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
     */
    public val includes: List<FilterRule>? = builder.includes
    /**
     * The name of the task to update.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Represents the options that are available to control the behavior of a [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html) operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.
     *
     * A task has a set of default options associated with it. If you don't specify an option in [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html), the default value is used. You can override the defaults options on each task execution by specifying an overriding `Options` value to [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
     */
    public val options: aws.sdk.kotlin.services.datasync.model.Options? = builder.options
    /**
     * Specifies a schedule used to periodically transfer files from a source to a destination location. You can configure your task to execute hourly, daily, weekly or on specific days of the week. You control when in the day or hour you want the task to execute. The time you specify is UTC time. For more information, see [Scheduling your task](https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html).
     */
    public val schedule: aws.sdk.kotlin.services.datasync.model.TaskSchedule? = builder.schedule
    /**
     * The Amazon Resource Name (ARN) of the resource name of the task to update.
     */
    public val taskArn: kotlin.String? = builder.taskArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.UpdateTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateTaskRequest(")
        append("cloudWatchLogGroupArn=$cloudWatchLogGroupArn,")
        append("excludes=$excludes,")
        append("includes=$includes,")
        append("name=$name,")
        append("options=$options,")
        append("schedule=$schedule,")
        append("taskArn=$taskArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (excludes?.hashCode() ?: 0)
        result = 31 * result + (includes?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateTaskRequest

        if (cloudWatchLogGroupArn != other.cloudWatchLogGroupArn) return false
        if (excludes != other.excludes) return false
        if (includes != other.includes) return false
        if (name != other.name) return false
        if (options != other.options) return false
        if (schedule != other.schedule) return false
        if (taskArn != other.taskArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.UpdateTaskRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the resource name of the Amazon CloudWatch log group.
         */
        public var cloudWatchLogGroupArn: kotlin.String? = null
        /**
         * A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
         */
        public var excludes: List<FilterRule>? = null
        /**
         * A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
         */
        public var includes: List<FilterRule>? = null
        /**
         * The name of the task to update.
         */
        public var name: kotlin.String? = null
        /**
         * Represents the options that are available to control the behavior of a [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html) operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.
         *
         * A task has a set of default options associated with it. If you don't specify an option in [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html), the default value is used. You can override the defaults options on each task execution by specifying an overriding `Options` value to [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
         */
        public var options: aws.sdk.kotlin.services.datasync.model.Options? = null
        /**
         * Specifies a schedule used to periodically transfer files from a source to a destination location. You can configure your task to execute hourly, daily, weekly or on specific days of the week. You control when in the day or hour you want the task to execute. The time you specify is UTC time. For more information, see [Scheduling your task](https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html).
         */
        public var schedule: aws.sdk.kotlin.services.datasync.model.TaskSchedule? = null
        /**
         * The Amazon Resource Name (ARN) of the resource name of the task to update.
         */
        public var taskArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.UpdateTaskRequest) : this() {
            this.cloudWatchLogGroupArn = x.cloudWatchLogGroupArn
            this.excludes = x.excludes
            this.includes = x.includes
            this.name = x.name
            this.options = x.options
            this.schedule = x.schedule
            this.taskArn = x.taskArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.UpdateTaskRequest = UpdateTaskRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.Options] inside the given [block]
         */
        public fun options(block: aws.sdk.kotlin.services.datasync.model.Options.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.datasync.model.Options.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskSchedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.datasync.model.TaskSchedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.datasync.model.TaskSchedule.invoke(block)
        }
    }
}
