// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.datasync.model.DataSyncException
import aws.sdk.kotlin.services.datasync.model.DescribeLocationS3Response
import aws.sdk.kotlin.services.datasync.model.S3Config
import aws.sdk.kotlin.services.datasync.model.S3StorageClass
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeLocationS3OperationDeserializer: HttpDeserialize<DescribeLocationS3Response> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeLocationS3Response {
        if (!response.status.isSuccess()) {
            throwDescribeLocationS3Error(context, response)
        }
        val builder = DescribeLocationS3Response.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeLocationS3OperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeLocationS3Error(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DataSyncException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DataSyncException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeLocationS3OperationBody(builder: DescribeLocationS3Response.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGENTARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AgentArns"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val LOCATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LocationArn"))
    val LOCATIONURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LocationUri"))
    val S3CONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("S3Config"))
    val S3STORAGECLASS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3StorageClass"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGENTARNS_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(LOCATIONARN_DESCRIPTOR)
        field(LOCATIONURI_DESCRIPTOR)
        field(S3CONFIG_DESCRIPTOR)
        field(S3STORAGECLASS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGENTARNS_DESCRIPTOR.index -> builder.agentArns =
                    deserializer.deserializeList(AGENTARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LOCATIONARN_DESCRIPTOR.index -> builder.locationArn = deserializeString()
                LOCATIONURI_DESCRIPTOR.index -> builder.locationUri = deserializeString()
                S3CONFIG_DESCRIPTOR.index -> builder.s3Config = deserializeS3ConfigDocument(deserializer)
                S3STORAGECLASS_DESCRIPTOR.index -> builder.s3StorageClass = deserializeString().let { S3StorageClass.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
