// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dax

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.dax.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.dax.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * DAX is a managed caching service engineered for Amazon DynamoDB. DAX dramatically speeds up database reads by caching frequently-accessed data from DynamoDB, so applications can access that data with sub-millisecond latency. You can create a DAX cluster easily, using the AWS Management Console. With a few simple modifications to your code, your application can begin taking advantage of the DAX cluster and realize significant improvements in read performance.
 */
interface DaxClient : SdkClient {

    override val serviceName: String
        get() = "DAX"
    /**
     * DaxClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): DaxClient {
            val config = Config.Builder().apply(block).build()
            return DefaultDaxClient(config)
        }

        operator fun invoke(config: Config): DaxClient = DefaultDaxClient(config)

        /**
         * Construct a [DaxClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): DaxClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultDaxClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a DAX cluster. All nodes in the cluster run the same DAX caching software.
     */
    suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates a DAX cluster. All nodes in the cluster run the same DAX caching software.
     */
    suspend fun createCluster(block: CreateClusterRequest.Builder.() -> Unit) = createCluster(CreateClusterRequest.Builder().apply(block).build())

    /**
     * Creates a new parameter group. A parameter group is a collection of parameters that you apply to all of the nodes in a DAX cluster.
     */
    suspend fun createParameterGroup(input: CreateParameterGroupRequest): CreateParameterGroupResponse

    /**
     * Creates a new parameter group. A parameter group is a collection of parameters that you apply to all of the nodes in a DAX cluster.
     */
    suspend fun createParameterGroup(block: CreateParameterGroupRequest.Builder.() -> Unit) = createParameterGroup(CreateParameterGroupRequest.Builder().apply(block).build())

    /**
     * Creates a new subnet group.
     */
    suspend fun createSubnetGroup(input: CreateSubnetGroupRequest): CreateSubnetGroupResponse

    /**
     * Creates a new subnet group.
     */
    suspend fun createSubnetGroup(block: CreateSubnetGroupRequest.Builder.() -> Unit) = createSubnetGroup(CreateSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Removes one or more nodes from a DAX cluster.
     *
     * You cannot use `DecreaseReplicationFactor` to remove the last node in a DAX cluster. If you need to do this, use `DeleteCluster` instead.
     */
    suspend fun decreaseReplicationFactor(input: DecreaseReplicationFactorRequest): DecreaseReplicationFactorResponse

    /**
     * Removes one or more nodes from a DAX cluster.
     *
     * You cannot use `DecreaseReplicationFactor` to remove the last node in a DAX cluster. If you need to do this, use `DeleteCluster` instead.
     */
    suspend fun decreaseReplicationFactor(block: DecreaseReplicationFactorRequest.Builder.() -> Unit) = decreaseReplicationFactor(DecreaseReplicationFactorRequest.Builder().apply(block).build())

    /**
     * Deletes a previously provisioned DAX cluster. *DeleteCluster* deletes all associated nodes, node endpoints and the DAX cluster itself. When you receive a successful response from this action, DAX immediately begins deleting the cluster; you cannot cancel or revert this action.
     */
    suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Deletes a previously provisioned DAX cluster. *DeleteCluster* deletes all associated nodes, node endpoints and the DAX cluster itself. When you receive a successful response from this action, DAX immediately begins deleting the cluster; you cannot cancel or revert this action.
     */
    suspend fun deleteCluster(block: DeleteClusterRequest.Builder.() -> Unit) = deleteCluster(DeleteClusterRequest.Builder().apply(block).build())

    /**
     * Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any DAX clusters.
     */
    suspend fun deleteParameterGroup(input: DeleteParameterGroupRequest): DeleteParameterGroupResponse

    /**
     * Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any DAX clusters.
     */
    suspend fun deleteParameterGroup(block: DeleteParameterGroupRequest.Builder.() -> Unit) = deleteParameterGroup(DeleteParameterGroupRequest.Builder().apply(block).build())

    /**
     * Deletes a subnet group.
     *
     * You cannot delete a subnet group if it is associated with any DAX clusters.
     */
    suspend fun deleteSubnetGroup(input: DeleteSubnetGroupRequest): DeleteSubnetGroupResponse

    /**
     * Deletes a subnet group.
     *
     * You cannot delete a subnet group if it is associated with any DAX clusters.
     */
    suspend fun deleteSubnetGroup(block: DeleteSubnetGroupRequest.Builder.() -> Unit) = deleteSubnetGroup(DeleteSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Returns information about all provisioned DAX clusters if no cluster identifier is specified, or about a specific DAX cluster if a cluster identifier is supplied.
     *
     * If the cluster is in the CREATING state, only cluster level information will be displayed until all of the nodes are successfully provisioned.
     *
     * If the cluster is in the DELETING state, only cluster level information will be displayed.
     *
     * If nodes are currently being added to the DAX cluster, node endpoint information and creation time for the additional nodes will not be displayed until they are completely provisioned. When the DAX cluster state is *available*, the cluster is ready for use.
     *
     * If nodes are currently being removed from the DAX cluster, no endpoint information for the removed nodes is displayed.
     */
    suspend fun describeClusters(input: DescribeClustersRequest = DescribeClustersRequest {}): DescribeClustersResponse

    /**
     * Returns information about all provisioned DAX clusters if no cluster identifier is specified, or about a specific DAX cluster if a cluster identifier is supplied.
     *
     * If the cluster is in the CREATING state, only cluster level information will be displayed until all of the nodes are successfully provisioned.
     *
     * If the cluster is in the DELETING state, only cluster level information will be displayed.
     *
     * If nodes are currently being added to the DAX cluster, node endpoint information and creation time for the additional nodes will not be displayed until they are completely provisioned. When the DAX cluster state is *available*, the cluster is ready for use.
     *
     * If nodes are currently being removed from the DAX cluster, no endpoint information for the removed nodes is displayed.
     */
    suspend fun describeClusters(block: DescribeClustersRequest.Builder.() -> Unit) = describeClusters(DescribeClustersRequest.Builder().apply(block).build())

    /**
     * Returns the default system parameter information for the DAX caching software.
     */
    suspend fun describeDefaultParameters(input: DescribeDefaultParametersRequest = DescribeDefaultParametersRequest {}): DescribeDefaultParametersResponse

    /**
     * Returns the default system parameter information for the DAX caching software.
     */
    suspend fun describeDefaultParameters(block: DescribeDefaultParametersRequest.Builder.() -> Unit) = describeDefaultParameters(DescribeDefaultParametersRequest.Builder().apply(block).build())

    /**
     * Returns events related to DAX clusters and parameter groups. You can obtain events specific to a particular DAX cluster or parameter group by providing the name as a parameter.
     *
     * By default, only the events occurring within the last 24 hours are returned; however, you can retrieve up to 14 days' worth of events if necessary.
     */
    suspend fun describeEvents(input: DescribeEventsRequest = DescribeEventsRequest {}): DescribeEventsResponse

    /**
     * Returns events related to DAX clusters and parameter groups. You can obtain events specific to a particular DAX cluster or parameter group by providing the name as a parameter.
     *
     * By default, only the events occurring within the last 24 hours are returned; however, you can retrieve up to 14 days' worth of events if necessary.
     */
    suspend fun describeEvents(block: DescribeEventsRequest.Builder.() -> Unit) = describeEvents(DescribeEventsRequest.Builder().apply(block).build())

    /**
     * Returns a list of parameter group descriptions. If a parameter group name is specified, the list will contain only the descriptions for that group.
     */
    suspend fun describeParameterGroups(input: DescribeParameterGroupsRequest = DescribeParameterGroupsRequest {}): DescribeParameterGroupsResponse

    /**
     * Returns a list of parameter group descriptions. If a parameter group name is specified, the list will contain only the descriptions for that group.
     */
    suspend fun describeParameterGroups(block: DescribeParameterGroupsRequest.Builder.() -> Unit) = describeParameterGroups(DescribeParameterGroupsRequest.Builder().apply(block).build())

    /**
     * Returns the detailed parameter list for a particular parameter group.
     */
    suspend fun describeParameters(input: DescribeParametersRequest): DescribeParametersResponse

    /**
     * Returns the detailed parameter list for a particular parameter group.
     */
    suspend fun describeParameters(block: DescribeParametersRequest.Builder.() -> Unit) = describeParameters(DescribeParametersRequest.Builder().apply(block).build())

    /**
     * Returns a list of subnet group descriptions. If a subnet group name is specified, the list will contain only the description of that group.
     */
    suspend fun describeSubnetGroups(input: DescribeSubnetGroupsRequest = DescribeSubnetGroupsRequest {}): DescribeSubnetGroupsResponse

    /**
     * Returns a list of subnet group descriptions. If a subnet group name is specified, the list will contain only the description of that group.
     */
    suspend fun describeSubnetGroups(block: DescribeSubnetGroupsRequest.Builder.() -> Unit) = describeSubnetGroups(DescribeSubnetGroupsRequest.Builder().apply(block).build())

    /**
     * Adds one or more nodes to a DAX cluster.
     */
    suspend fun increaseReplicationFactor(input: IncreaseReplicationFactorRequest): IncreaseReplicationFactorResponse

    /**
     * Adds one or more nodes to a DAX cluster.
     */
    suspend fun increaseReplicationFactor(block: IncreaseReplicationFactorRequest.Builder.() -> Unit) = increaseReplicationFactor(IncreaseReplicationFactorRequest.Builder().apply(block).build())

    /**
     * List all of the tags for a DAX cluster. You can call `ListTags` up to 10 times per second, per account.
     */
    suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * List all of the tags for a DAX cluster. You can call `ListTags` up to 10 times per second, per account.
     */
    suspend fun listTags(block: ListTagsRequest.Builder.() -> Unit) = listTags(ListTagsRequest.Builder().apply(block).build())

    /**
     * Reboots a single node of a DAX cluster. The reboot action takes place as soon as possible. During the reboot, the node status is set to REBOOTING.
     *
     * `RebootNode` restarts the DAX engine process and does not remove the contents of the cache.
     */
    suspend fun rebootNode(input: RebootNodeRequest): RebootNodeResponse

    /**
     * Reboots a single node of a DAX cluster. The reboot action takes place as soon as possible. During the reboot, the node status is set to REBOOTING.
     *
     * `RebootNode` restarts the DAX engine process and does not remove the contents of the cache.
     */
    suspend fun rebootNode(block: RebootNodeRequest.Builder.() -> Unit) = rebootNode(RebootNodeRequest.Builder().apply(block).build())

    /**
     * Associates a set of tags with a DAX resource. You can call `TagResource` up to 5 times per second, per account.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Associates a set of tags with a DAX resource. You can call `TagResource` up to 5 times per second, per account.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes the association of tags from a DAX resource. You can call `UntagResource` up to 5 times per second, per account.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the association of tags from a DAX resource. You can call `UntagResource` up to 5 times per second, per account.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Modifies the settings for a DAX cluster. You can use this action to change one or more cluster configuration parameters by specifying the parameters and the new values.
     */
    suspend fun updateCluster(input: UpdateClusterRequest): UpdateClusterResponse

    /**
     * Modifies the settings for a DAX cluster. You can use this action to change one or more cluster configuration parameters by specifying the parameters and the new values.
     */
    suspend fun updateCluster(block: UpdateClusterRequest.Builder.() -> Unit) = updateCluster(UpdateClusterRequest.Builder().apply(block).build())

    /**
     * Modifies the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.
     */
    suspend fun updateParameterGroup(input: UpdateParameterGroupRequest): UpdateParameterGroupResponse

    /**
     * Modifies the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.
     */
    suspend fun updateParameterGroup(block: UpdateParameterGroupRequest.Builder.() -> Unit) = updateParameterGroup(UpdateParameterGroupRequest.Builder().apply(block).build())

    /**
     * Modifies an existing subnet group.
     */
    suspend fun updateSubnetGroup(input: UpdateSubnetGroupRequest): UpdateSubnetGroupResponse

    /**
     * Modifies an existing subnet group.
     */
    suspend fun updateSubnetGroup(block: UpdateSubnetGroupRequest.Builder.() -> Unit) = updateSubnetGroup(UpdateSubnetGroupRequest.Builder().apply(block).build())
}
