// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dax

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.dax.model.*
import aws.sdk.kotlin.services.dax.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "DAX"
const val ServiceApiVersion: String = "2017-04-19"
const val SdkVersion: String = "0.16.1-beta"

internal class DefaultDaxClient(override val config: DaxClient.Config) : DaxClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a DAX cluster. All nodes in the cluster run the same DAX caching software.
     */
    override suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse {
        val op = SdkHttpOperation.build<CreateClusterRequest, CreateClusterResponse> {
            serializer = CreateClusterOperationSerializer()
            deserializer = CreateClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new parameter group. A parameter group is a collection of parameters that you apply to all of the nodes in a DAX cluster.
     */
    override suspend fun createParameterGroup(input: CreateParameterGroupRequest): CreateParameterGroupResponse {
        val op = SdkHttpOperation.build<CreateParameterGroupRequest, CreateParameterGroupResponse> {
            serializer = CreateParameterGroupOperationSerializer()
            deserializer = CreateParameterGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateParameterGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new subnet group.
     */
    override suspend fun createSubnetGroup(input: CreateSubnetGroupRequest): CreateSubnetGroupResponse {
        val op = SdkHttpOperation.build<CreateSubnetGroupRequest, CreateSubnetGroupResponse> {
            serializer = CreateSubnetGroupOperationSerializer()
            deserializer = CreateSubnetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSubnetGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more nodes from a DAX cluster.
     *
     * You cannot use `DecreaseReplicationFactor` to remove the last node in a DAX cluster. If you need to do this, use `DeleteCluster` instead.
     */
    override suspend fun decreaseReplicationFactor(input: DecreaseReplicationFactorRequest): DecreaseReplicationFactorResponse {
        val op = SdkHttpOperation.build<DecreaseReplicationFactorRequest, DecreaseReplicationFactorResponse> {
            serializer = DecreaseReplicationFactorOperationSerializer()
            deserializer = DecreaseReplicationFactorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DecreaseReplicationFactor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a previously provisioned DAX cluster. *DeleteCluster* deletes all associated nodes, node endpoints and the DAX cluster itself. When you receive a successful response from this action, DAX immediately begins deleting the cluster; you cannot cancel or revert this action.
     */
    override suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse {
        val op = SdkHttpOperation.build<DeleteClusterRequest, DeleteClusterResponse> {
            serializer = DeleteClusterOperationSerializer()
            deserializer = DeleteClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any DAX clusters.
     */
    override suspend fun deleteParameterGroup(input: DeleteParameterGroupRequest): DeleteParameterGroupResponse {
        val op = SdkHttpOperation.build<DeleteParameterGroupRequest, DeleteParameterGroupResponse> {
            serializer = DeleteParameterGroupOperationSerializer()
            deserializer = DeleteParameterGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteParameterGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a subnet group.
     *
     * You cannot delete a subnet group if it is associated with any DAX clusters.
     */
    override suspend fun deleteSubnetGroup(input: DeleteSubnetGroupRequest): DeleteSubnetGroupResponse {
        val op = SdkHttpOperation.build<DeleteSubnetGroupRequest, DeleteSubnetGroupResponse> {
            serializer = DeleteSubnetGroupOperationSerializer()
            deserializer = DeleteSubnetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSubnetGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about all provisioned DAX clusters if no cluster identifier is specified, or about a specific DAX cluster if a cluster identifier is supplied.
     *
     * If the cluster is in the CREATING state, only cluster level information will be displayed until all of the nodes are successfully provisioned.
     *
     * If the cluster is in the DELETING state, only cluster level information will be displayed.
     *
     * If nodes are currently being added to the DAX cluster, node endpoint information and creation time for the additional nodes will not be displayed until they are completely provisioned. When the DAX cluster state is *available*, the cluster is ready for use.
     *
     * If nodes are currently being removed from the DAX cluster, no endpoint information for the removed nodes is displayed.
     */
    override suspend fun describeClusters(input: DescribeClustersRequest): DescribeClustersResponse {
        val op = SdkHttpOperation.build<DescribeClustersRequest, DescribeClustersResponse> {
            serializer = DescribeClustersOperationSerializer()
            deserializer = DescribeClustersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClusters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the default system parameter information for the DAX caching software.
     */
    override suspend fun describeDefaultParameters(input: DescribeDefaultParametersRequest): DescribeDefaultParametersResponse {
        val op = SdkHttpOperation.build<DescribeDefaultParametersRequest, DescribeDefaultParametersResponse> {
            serializer = DescribeDefaultParametersOperationSerializer()
            deserializer = DescribeDefaultParametersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDefaultParameters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns events related to DAX clusters and parameter groups. You can obtain events specific to a particular DAX cluster or parameter group by providing the name as a parameter.
     *
     * By default, only the events occurring within the last 24 hours are returned; however, you can retrieve up to 14 days' worth of events if necessary.
     */
    override suspend fun describeEvents(input: DescribeEventsRequest): DescribeEventsResponse {
        val op = SdkHttpOperation.build<DescribeEventsRequest, DescribeEventsResponse> {
            serializer = DescribeEventsOperationSerializer()
            deserializer = DescribeEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of parameter group descriptions. If a parameter group name is specified, the list will contain only the descriptions for that group.
     */
    override suspend fun describeParameterGroups(input: DescribeParameterGroupsRequest): DescribeParameterGroupsResponse {
        val op = SdkHttpOperation.build<DescribeParameterGroupsRequest, DescribeParameterGroupsResponse> {
            serializer = DescribeParameterGroupsOperationSerializer()
            deserializer = DescribeParameterGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeParameterGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the detailed parameter list for a particular parameter group.
     */
    override suspend fun describeParameters(input: DescribeParametersRequest): DescribeParametersResponse {
        val op = SdkHttpOperation.build<DescribeParametersRequest, DescribeParametersResponse> {
            serializer = DescribeParametersOperationSerializer()
            deserializer = DescribeParametersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeParameters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of subnet group descriptions. If a subnet group name is specified, the list will contain only the description of that group.
     */
    override suspend fun describeSubnetGroups(input: DescribeSubnetGroupsRequest): DescribeSubnetGroupsResponse {
        val op = SdkHttpOperation.build<DescribeSubnetGroupsRequest, DescribeSubnetGroupsResponse> {
            serializer = DescribeSubnetGroupsOperationSerializer()
            deserializer = DescribeSubnetGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSubnetGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more nodes to a DAX cluster.
     */
    override suspend fun increaseReplicationFactor(input: IncreaseReplicationFactorRequest): IncreaseReplicationFactorResponse {
        val op = SdkHttpOperation.build<IncreaseReplicationFactorRequest, IncreaseReplicationFactorResponse> {
            serializer = IncreaseReplicationFactorOperationSerializer()
            deserializer = IncreaseReplicationFactorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "IncreaseReplicationFactor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List all of the tags for a DAX cluster. You can call `ListTags` up to 10 times per second, per account.
     */
    override suspend fun listTags(input: ListTagsRequest): ListTagsResponse {
        val op = SdkHttpOperation.build<ListTagsRequest, ListTagsResponse> {
            serializer = ListTagsOperationSerializer()
            deserializer = ListTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Reboots a single node of a DAX cluster. The reboot action takes place as soon as possible. During the reboot, the node status is set to REBOOTING.
     *
     * `RebootNode` restarts the DAX engine process and does not remove the contents of the cache.
     */
    override suspend fun rebootNode(input: RebootNodeRequest): RebootNodeResponse {
        val op = SdkHttpOperation.build<RebootNodeRequest, RebootNodeResponse> {
            serializer = RebootNodeOperationSerializer()
            deserializer = RebootNodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RebootNode"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a set of tags with a DAX resource. You can call `TagResource` up to 5 times per second, per account.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the association of tags from a DAX resource. You can call `UntagResource` up to 5 times per second, per account.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the settings for a DAX cluster. You can use this action to change one or more cluster configuration parameters by specifying the parameters and the new values.
     */
    override suspend fun updateCluster(input: UpdateClusterRequest): UpdateClusterResponse {
        val op = SdkHttpOperation.build<UpdateClusterRequest, UpdateClusterResponse> {
            serializer = UpdateClusterOperationSerializer()
            deserializer = UpdateClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.
     */
    override suspend fun updateParameterGroup(input: UpdateParameterGroupRequest): UpdateParameterGroupResponse {
        val op = SdkHttpOperation.build<UpdateParameterGroupRequest, UpdateParameterGroupResponse> {
            serializer = UpdateParameterGroupOperationSerializer()
            deserializer = UpdateParameterGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateParameterGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies an existing subnet group.
     */
    override suspend fun updateSubnetGroup(input: UpdateSubnetGroupRequest): UpdateSubnetGroupResponse {
        val op = SdkHttpOperation.build<UpdateSubnetGroupRequest, UpdateSubnetGroupResponse> {
            serializer = UpdateSubnetGroupOperationSerializer()
            deserializer = UpdateSubnetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSubnetGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonDAXV3", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "dax"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "dax")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
