// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dax.model



/**
 * Contains all of the attributes of a specific DAX cluster.
 */
class Cluster private constructor(builder: Builder) {
    /**
     * The number of nodes in the cluster that are active (i.e., capable of serving requests).
     */
    val activeNodes: kotlin.Int? = builder.activeNodes
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     */
    val clusterArn: kotlin.String? = builder.clusterArn
    /**
     * The endpoint for this DAX cluster, consisting of a DNS name, a port number, and a URL. Applications should use the URL to configure the DAX client to find their cluster.
     */
    val clusterDiscoveryEndpoint: aws.sdk.kotlin.services.dax.model.Endpoint? = builder.clusterDiscoveryEndpoint
    /**
     * The type of encryption supported by the cluster's endpoint. Values are:
     * + `NONE` for no encryption`TLS` for Transport Layer Security
     */
    val clusterEndpointEncryptionType: aws.sdk.kotlin.services.dax.model.ClusterEndpointEncryptionType? = builder.clusterEndpointEncryptionType
    /**
     * The name of the DAX cluster.
     */
    val clusterName: kotlin.String? = builder.clusterName
    /**
     * The description of the cluster.
     */
    val description: kotlin.String? = builder.description
    /**
     * A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX will assume this role and use the role's permissions to access DynamoDB on your behalf.
     */
    val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * A list of nodes to be removed from the cluster.
     */
    val nodeIdsToRemove: List<String>? = builder.nodeIdsToRemove
    /**
     * The node type for the nodes in the cluster. (All nodes in a DAX cluster are of the same type.)
     */
    val nodeType: kotlin.String? = builder.nodeType
    /**
     * A list of nodes that are currently in the cluster.
     */
    val nodes: List<Node>? = builder.nodes
    /**
     * Describes a notification topic and its status. Notification topics are used for publishing DAX events to subscribers using Amazon Simple Notification Service (SNS).
     */
    val notificationConfiguration: aws.sdk.kotlin.services.dax.model.NotificationConfiguration? = builder.notificationConfiguration
    /**
     * The parameter group being used by nodes in the cluster.
     */
    val parameterGroup: aws.sdk.kotlin.services.dax.model.ParameterGroupStatus? = builder.parameterGroup
    /**
     * A range of time when maintenance of DAX cluster software will be performed. For example: `sun:01:00-sun:09:00`. Cluster maintenance normally takes less than 30 minutes, and is performed automatically within the maintenance window.
     */
    val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * A list of security groups, and the status of each, for the nodes in the cluster.
     */
    val securityGroups: List<SecurityGroupMembership>? = builder.securityGroups
    /**
     * The description of the server-side encryption status on the specified DAX cluster.
     */
    val sseDescription: aws.sdk.kotlin.services.dax.model.SseDescription? = builder.sseDescription
    /**
     * The current status of the cluster.
     */
    val status: kotlin.String? = builder.status
    /**
     * The subnet group where the DAX cluster is running.
     */
    val subnetGroup: kotlin.String? = builder.subnetGroup
    /**
     * The total number of nodes in the cluster.
     */
    val totalNodes: kotlin.Int? = builder.totalNodes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dax.model.Cluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Cluster(")
        append("activeNodes=$activeNodes,")
        append("clusterArn=$clusterArn,")
        append("clusterDiscoveryEndpoint=$clusterDiscoveryEndpoint,")
        append("clusterEndpointEncryptionType=$clusterEndpointEncryptionType,")
        append("clusterName=$clusterName,")
        append("description=$description,")
        append("iamRoleArn=$iamRoleArn,")
        append("nodeIdsToRemove=$nodeIdsToRemove,")
        append("nodeType=$nodeType,")
        append("nodes=$nodes,")
        append("notificationConfiguration=$notificationConfiguration,")
        append("parameterGroup=$parameterGroup,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("securityGroups=$securityGroups,")
        append("sseDescription=$sseDescription,")
        append("status=$status,")
        append("subnetGroup=$subnetGroup,")
        append("totalNodes=$totalNodes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeNodes ?: 0
        result = 31 * result + (clusterArn?.hashCode() ?: 0)
        result = 31 * result + (clusterDiscoveryEndpoint?.hashCode() ?: 0)
        result = 31 * result + (clusterEndpointEncryptionType?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (nodeIdsToRemove?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (nodes?.hashCode() ?: 0)
        result = 31 * result + (notificationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (parameterGroup?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (sseDescription?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subnetGroup?.hashCode() ?: 0)
        result = 31 * result + (totalNodes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Cluster

        if (activeNodes != other.activeNodes) return false
        if (clusterArn != other.clusterArn) return false
        if (clusterDiscoveryEndpoint != other.clusterDiscoveryEndpoint) return false
        if (clusterEndpointEncryptionType != other.clusterEndpointEncryptionType) return false
        if (clusterName != other.clusterName) return false
        if (description != other.description) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (nodeIdsToRemove != other.nodeIdsToRemove) return false
        if (nodeType != other.nodeType) return false
        if (nodes != other.nodes) return false
        if (notificationConfiguration != other.notificationConfiguration) return false
        if (parameterGroup != other.parameterGroup) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (securityGroups != other.securityGroups) return false
        if (sseDescription != other.sseDescription) return false
        if (status != other.status) return false
        if (subnetGroup != other.subnetGroup) return false
        if (totalNodes != other.totalNodes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dax.model.Cluster = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of nodes in the cluster that are active (i.e., capable of serving requests).
         */
        var activeNodes: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         */
        var clusterArn: kotlin.String? = null
        /**
         * The endpoint for this DAX cluster, consisting of a DNS name, a port number, and a URL. Applications should use the URL to configure the DAX client to find their cluster.
         */
        var clusterDiscoveryEndpoint: aws.sdk.kotlin.services.dax.model.Endpoint? = null
        /**
         * The type of encryption supported by the cluster's endpoint. Values are:
         * + `NONE` for no encryption`TLS` for Transport Layer Security
         */
        var clusterEndpointEncryptionType: aws.sdk.kotlin.services.dax.model.ClusterEndpointEncryptionType? = null
        /**
         * The name of the DAX cluster.
         */
        var clusterName: kotlin.String? = null
        /**
         * The description of the cluster.
         */
        var description: kotlin.String? = null
        /**
         * A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX will assume this role and use the role's permissions to access DynamoDB on your behalf.
         */
        var iamRoleArn: kotlin.String? = null
        /**
         * A list of nodes to be removed from the cluster.
         */
        var nodeIdsToRemove: List<String>? = null
        /**
         * The node type for the nodes in the cluster. (All nodes in a DAX cluster are of the same type.)
         */
        var nodeType: kotlin.String? = null
        /**
         * A list of nodes that are currently in the cluster.
         */
        var nodes: List<Node>? = null
        /**
         * Describes a notification topic and its status. Notification topics are used for publishing DAX events to subscribers using Amazon Simple Notification Service (SNS).
         */
        var notificationConfiguration: aws.sdk.kotlin.services.dax.model.NotificationConfiguration? = null
        /**
         * The parameter group being used by nodes in the cluster.
         */
        var parameterGroup: aws.sdk.kotlin.services.dax.model.ParameterGroupStatus? = null
        /**
         * A range of time when maintenance of DAX cluster software will be performed. For example: `sun:01:00-sun:09:00`. Cluster maintenance normally takes less than 30 minutes, and is performed automatically within the maintenance window.
         */
        var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * A list of security groups, and the status of each, for the nodes in the cluster.
         */
        var securityGroups: List<SecurityGroupMembership>? = null
        /**
         * The description of the server-side encryption status on the specified DAX cluster.
         */
        var sseDescription: aws.sdk.kotlin.services.dax.model.SseDescription? = null
        /**
         * The current status of the cluster.
         */
        var status: kotlin.String? = null
        /**
         * The subnet group where the DAX cluster is running.
         */
        var subnetGroup: kotlin.String? = null
        /**
         * The total number of nodes in the cluster.
         */
        var totalNodes: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dax.model.Cluster) : this() {
            this.activeNodes = x.activeNodes
            this.clusterArn = x.clusterArn
            this.clusterDiscoveryEndpoint = x.clusterDiscoveryEndpoint
            this.clusterEndpointEncryptionType = x.clusterEndpointEncryptionType
            this.clusterName = x.clusterName
            this.description = x.description
            this.iamRoleArn = x.iamRoleArn
            this.nodeIdsToRemove = x.nodeIdsToRemove
            this.nodeType = x.nodeType
            this.nodes = x.nodes
            this.notificationConfiguration = x.notificationConfiguration
            this.parameterGroup = x.parameterGroup
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.securityGroups = x.securityGroups
            this.sseDescription = x.sseDescription
            this.status = x.status
            this.subnetGroup = x.subnetGroup
            this.totalNodes = x.totalNodes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dax.model.Cluster = Cluster(this)

        /**
         * construct an [aws.sdk.kotlin.services.dax.model.Endpoint] inside the given [block]
         */
        fun clusterDiscoveryEndpoint(block: aws.sdk.kotlin.services.dax.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.clusterDiscoveryEndpoint = aws.sdk.kotlin.services.dax.model.Endpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dax.model.NotificationConfiguration] inside the given [block]
         */
        fun notificationConfiguration(block: aws.sdk.kotlin.services.dax.model.NotificationConfiguration.Builder.() -> kotlin.Unit) {
            this.notificationConfiguration = aws.sdk.kotlin.services.dax.model.NotificationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dax.model.ParameterGroupStatus] inside the given [block]
         */
        fun parameterGroup(block: aws.sdk.kotlin.services.dax.model.ParameterGroupStatus.Builder.() -> kotlin.Unit) {
            this.parameterGroup = aws.sdk.kotlin.services.dax.model.ParameterGroupStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dax.model.SseDescription] inside the given [block]
         */
        fun sseDescription(block: aws.sdk.kotlin.services.dax.model.SseDescription.Builder.() -> kotlin.Unit) {
            this.sseDescription = aws.sdk.kotlin.services.dax.model.SseDescription.invoke(block)
        }
    }
}
