// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dax.model



class CreateClusterRequest private constructor(builder: Builder) {
    /**
     * The Availability Zones (AZs) in which the cluster nodes will reside after the cluster has been created or updated. If provided, the length of this list must equal the `ReplicationFactor` parameter. If you omit this parameter, DAX will spread the nodes across Availability Zones for the highest availability.
     */
    val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The type of encryption the cluster's endpoint should support. Values are:
     * + `NONE` for no encryption
     * + `TLS` for Transport Layer Security
     */
    val clusterEndpointEncryptionType: aws.sdk.kotlin.services.dax.model.ClusterEndpointEncryptionType? = builder.clusterEndpointEncryptionType
    /**
     * The cluster identifier. This parameter is stored as a lowercase string.
     *
     * **Constraints:**
     * + A name must contain from 1 to 20 alphanumeric characters or hyphens.
     * + The first character must be a letter.
     * + A name cannot end with a hyphen or contain two consecutive hyphens.
     */
    val clusterName: kotlin.String? = builder.clusterName
    /**
     * A description of the cluster.
     */
    val description: kotlin.String? = builder.description
    /**
     * A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX will assume this role and use the role's permissions to access DynamoDB on your behalf.
     */
    val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The compute and memory capacity of the nodes in the cluster.
     */
    val nodeType: kotlin.String? = builder.nodeType
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications will be sent.
     *
     * The Amazon SNS topic owner must be same as the DAX cluster owner.
     */
    val notificationTopicArn: kotlin.String? = builder.notificationTopicArn
    /**
     * The parameter group to be associated with the DAX cluster.
     */
    val parameterGroupName: kotlin.String? = builder.parameterGroupName
    /**
     * Specifies the weekly time range during which maintenance on the DAX cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for `ddd` are:
     * + `sun`
     * + `mon`
     * + `tue`
     * + `wed`
     * + `thu`
     * + `fri`
     * + `sat`
     *
     * Example: `sun:05:00-sun:09:00`
     *
     * If you don't specify a preferred maintenance window when you create or modify a cache cluster, DAX assigns a 60-minute maintenance window on a randomly selected day of the week.
     */
    val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The number of nodes in the DAX cluster. A replication factor of 1 will create a single-node cluster, without any read replicas. For additional fault tolerance, you can create a multiple node cluster with one or more read replicas. To do this, set `ReplicationFactor` to a number between 3 (one primary and two read replicas) and 10 (one primary and nine read replicas). `If the AvailabilityZones` parameter is provided, its length must equal the `ReplicationFactor`.
     *
     * AWS recommends that you have at least two read replicas per cluster.
     */
    val replicationFactor: kotlin.Int = builder.replicationFactor
    /**
     * A list of security group IDs to be assigned to each node in the DAX cluster. (Each of the security group ID is system-generated.)
     *
     * If this parameter is not specified, DAX assigns the default VPC security group to each node.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * Represents the settings used to enable server-side encryption on the cluster.
     */
    val sseSpecification: aws.sdk.kotlin.services.dax.model.SseSpecification? = builder.sseSpecification
    /**
     * The name of the subnet group to be used for the replication group.
     *
     * DAX clusters can only run in an Amazon VPC environment. All of the subnets that you specify in a subnet group must exist in the same VPC.
     */
    val subnetGroupName: kotlin.String? = builder.subnetGroupName
    /**
     * A set of tags to associate with the DAX cluster.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dax.model.CreateClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClusterRequest(")
        append("availabilityZones=$availabilityZones,")
        append("clusterEndpointEncryptionType=$clusterEndpointEncryptionType,")
        append("clusterName=$clusterName,")
        append("description=$description,")
        append("iamRoleArn=$iamRoleArn,")
        append("nodeType=$nodeType,")
        append("notificationTopicArn=$notificationTopicArn,")
        append("parameterGroupName=$parameterGroupName,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("replicationFactor=$replicationFactor,")
        append("securityGroupIds=$securityGroupIds,")
        append("sseSpecification=$sseSpecification,")
        append("subnetGroupName=$subnetGroupName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (clusterEndpointEncryptionType?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (notificationTopicArn?.hashCode() ?: 0)
        result = 31 * result + (parameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (replicationFactor)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (sseSpecification?.hashCode() ?: 0)
        result = 31 * result + (subnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateClusterRequest

        if (availabilityZones != other.availabilityZones) return false
        if (clusterEndpointEncryptionType != other.clusterEndpointEncryptionType) return false
        if (clusterName != other.clusterName) return false
        if (description != other.description) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (nodeType != other.nodeType) return false
        if (notificationTopicArn != other.notificationTopicArn) return false
        if (parameterGroupName != other.parameterGroupName) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (replicationFactor != other.replicationFactor) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (sseSpecification != other.sseSpecification) return false
        if (subnetGroupName != other.subnetGroupName) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dax.model.CreateClusterRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Availability Zones (AZs) in which the cluster nodes will reside after the cluster has been created or updated. If provided, the length of this list must equal the `ReplicationFactor` parameter. If you omit this parameter, DAX will spread the nodes across Availability Zones for the highest availability.
         */
        var availabilityZones: List<String>? = null
        /**
         * The type of encryption the cluster's endpoint should support. Values are:
         * + `NONE` for no encryption
         * + `TLS` for Transport Layer Security
         */
        var clusterEndpointEncryptionType: aws.sdk.kotlin.services.dax.model.ClusterEndpointEncryptionType? = null
        /**
         * The cluster identifier. This parameter is stored as a lowercase string.
         *
         * **Constraints:**
         * + A name must contain from 1 to 20 alphanumeric characters or hyphens.
         * + The first character must be a letter.
         * + A name cannot end with a hyphen or contain two consecutive hyphens.
         */
        var clusterName: kotlin.String? = null
        /**
         * A description of the cluster.
         */
        var description: kotlin.String? = null
        /**
         * A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX will assume this role and use the role's permissions to access DynamoDB on your behalf.
         */
        var iamRoleArn: kotlin.String? = null
        /**
         * The compute and memory capacity of the nodes in the cluster.
         */
        var nodeType: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications will be sent.
         *
         * The Amazon SNS topic owner must be same as the DAX cluster owner.
         */
        var notificationTopicArn: kotlin.String? = null
        /**
         * The parameter group to be associated with the DAX cluster.
         */
        var parameterGroupName: kotlin.String? = null
        /**
         * Specifies the weekly time range during which maintenance on the DAX cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for `ddd` are:
         * + `sun`
         * + `mon`
         * + `tue`
         * + `wed`
         * + `thu`
         * + `fri`
         * + `sat`
         *
         * Example: `sun:05:00-sun:09:00`
         *
         * If you don't specify a preferred maintenance window when you create or modify a cache cluster, DAX assigns a 60-minute maintenance window on a randomly selected day of the week.
         */
        var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The number of nodes in the DAX cluster. A replication factor of 1 will create a single-node cluster, without any read replicas. For additional fault tolerance, you can create a multiple node cluster with one or more read replicas. To do this, set `ReplicationFactor` to a number between 3 (one primary and two read replicas) and 10 (one primary and nine read replicas). `If the AvailabilityZones` parameter is provided, its length must equal the `ReplicationFactor`.
         *
         * AWS recommends that you have at least two read replicas per cluster.
         */
        var replicationFactor: kotlin.Int = 0
        /**
         * A list of security group IDs to be assigned to each node in the DAX cluster. (Each of the security group ID is system-generated.)
         *
         * If this parameter is not specified, DAX assigns the default VPC security group to each node.
         */
        var securityGroupIds: List<String>? = null
        /**
         * Represents the settings used to enable server-side encryption on the cluster.
         */
        var sseSpecification: aws.sdk.kotlin.services.dax.model.SseSpecification? = null
        /**
         * The name of the subnet group to be used for the replication group.
         *
         * DAX clusters can only run in an Amazon VPC environment. All of the subnets that you specify in a subnet group must exist in the same VPC.
         */
        var subnetGroupName: kotlin.String? = null
        /**
         * A set of tags to associate with the DAX cluster.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dax.model.CreateClusterRequest) : this() {
            this.availabilityZones = x.availabilityZones
            this.clusterEndpointEncryptionType = x.clusterEndpointEncryptionType
            this.clusterName = x.clusterName
            this.description = x.description
            this.iamRoleArn = x.iamRoleArn
            this.nodeType = x.nodeType
            this.notificationTopicArn = x.notificationTopicArn
            this.parameterGroupName = x.parameterGroupName
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.replicationFactor = x.replicationFactor
            this.securityGroupIds = x.securityGroupIds
            this.sseSpecification = x.sseSpecification
            this.subnetGroupName = x.subnetGroupName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dax.model.CreateClusterRequest = CreateClusterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.dax.model.SseSpecification] inside the given [block]
         */
        fun sseSpecification(block: aws.sdk.kotlin.services.dax.model.SseSpecification.Builder.() -> kotlin.Unit) {
            this.sseSpecification = aws.sdk.kotlin.services.dax.model.SseSpecification.invoke(block)
        }
    }
}
