// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dax.model



class DescribeClustersRequest private constructor(builder: Builder) {
    /**
     * The names of the DAX clusters being described.
     */
    val clusterNames: List<String>? = builder.clusterNames
    /**
     * The maximum number of results to include in the response. If more results exist than the specified `MaxResults` value, a token is included in the response so that the remaining results can be retrieved.
     *
     * The value for `MaxResults` must be between 20 and 100.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by `MaxResults`.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dax.model.DescribeClustersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeClustersRequest(")
        append("clusterNames=$clusterNames,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterNames?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeClustersRequest

        if (clusterNames != other.clusterNames) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dax.model.DescribeClustersRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The names of the DAX clusters being described.
         */
        var clusterNames: List<String>? = null
        /**
         * The maximum number of results to include in the response. If more results exist than the specified `MaxResults` value, a token is included in the response so that the remaining results can be retrieved.
         *
         * The value for `MaxResults` must be between 20 and 100.
         */
        var maxResults: kotlin.Int? = null
        /**
         * An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by `MaxResults`.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dax.model.DescribeClustersRequest) : this() {
            this.clusterNames = x.clusterNames
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dax.model.DescribeClustersRequest = DescribeClustersRequest(this)
    }
}
