// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dax.model



class DescribeParametersRequest private constructor(builder: Builder) {
    /**
     * The maximum number of results to include in the response. If more results exist than the specified `MaxResults` value, a token is included in the response so that the remaining results can be retrieved.
     *
     * The value for `MaxResults` must be between 20 and 100.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by `MaxResults`.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the parameter group.
     */
    val parameterGroupName: kotlin.String? = builder.parameterGroupName
    /**
     * How the parameter is defined. For example, `system` denotes a system-defined parameter.
     */
    val source: kotlin.String? = builder.source

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dax.model.DescribeParametersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeParametersRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("parameterGroupName=$parameterGroupName,")
        append("source=$source)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (parameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeParametersRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (parameterGroupName != other.parameterGroupName) return false
        if (source != other.source) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dax.model.DescribeParametersRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum number of results to include in the response. If more results exist than the specified `MaxResults` value, a token is included in the response so that the remaining results can be retrieved.
         *
         * The value for `MaxResults` must be between 20 and 100.
         */
        var maxResults: kotlin.Int? = null
        /**
         * An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by `MaxResults`.
         */
        var nextToken: kotlin.String? = null
        /**
         * The name of the parameter group.
         */
        var parameterGroupName: kotlin.String? = null
        /**
         * How the parameter is defined. For example, `system` denotes a system-defined parameter.
         */
        var source: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dax.model.DescribeParametersRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.parameterGroupName = x.parameterGroupName
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dax.model.DescribeParametersRequest = DescribeParametersRequest(this)
    }
}
