// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dax.model



/**
 * Represents the information required for client programs to connect to the endpoint for a DAX cluster.
 */
class Endpoint private constructor(builder: Builder) {
    /**
     * The DNS hostname of the endpoint.
     */
    val address: kotlin.String? = builder.address
    /**
     * The port number that applications should use to connect to the endpoint.
     */
    val port: kotlin.Int = builder.port
    /**
     * The URL that applications should use to connect to the endpoint. The default ports are 8111 for the "dax" protocol and 9111 for the "daxs" protocol.
     */
    val url: kotlin.String? = builder.url

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dax.model.Endpoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Endpoint(")
        append("address=$address,")
        append("port=$port,")
        append("url=$url)")
    }

    override fun hashCode(): kotlin.Int {
        var result = address?.hashCode() ?: 0
        result = 31 * result + (port)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Endpoint

        if (address != other.address) return false
        if (port != other.port) return false
        if (url != other.url) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dax.model.Endpoint = Builder(this).apply(block).build()

    class Builder {
        /**
         * The DNS hostname of the endpoint.
         */
        var address: kotlin.String? = null
        /**
         * The port number that applications should use to connect to the endpoint.
         */
        var port: kotlin.Int = 0
        /**
         * The URL that applications should use to connect to the endpoint. The default ports are 8111 for the "dax" protocol and 9111 for the "daxs" protocol.
         */
        var url: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dax.model.Endpoint) : this() {
            this.address = x.address
            this.port = x.port
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dax.model.Endpoint = Endpoint(this)
    }
}
