// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dax.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents an individual node within a DAX cluster.
 */
class Node private constructor(builder: Builder) {
    /**
     * The Availability Zone (AZ) in which the node has been deployed.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The endpoint for the node, consisting of a DNS name and a port number. Client applications can connect directly to a node endpoint, if desired (as an alternative to allowing DAX client software to intelligently route requests and responses to nodes in the DAX cluster.
     */
    val endpoint: aws.sdk.kotlin.services.dax.model.Endpoint? = builder.endpoint
    /**
     * The date and time (in UNIX epoch format) when the node was launched.
     */
    val nodeCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.nodeCreateTime
    /**
     * A system-generated identifier for the node.
     */
    val nodeId: kotlin.String? = builder.nodeId
    /**
     * The current status of the node. For example: `available`.
     */
    val nodeStatus: kotlin.String? = builder.nodeStatus
    /**
     * The status of the parameter group associated with this node. For example, `in-sync`.
     */
    val parameterGroupStatus: kotlin.String? = builder.parameterGroupStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dax.model.Node = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Node(")
        append("availabilityZone=$availabilityZone,")
        append("endpoint=$endpoint,")
        append("nodeCreateTime=$nodeCreateTime,")
        append("nodeId=$nodeId,")
        append("nodeStatus=$nodeStatus,")
        append("parameterGroupStatus=$parameterGroupStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (nodeCreateTime?.hashCode() ?: 0)
        result = 31 * result + (nodeId?.hashCode() ?: 0)
        result = 31 * result + (nodeStatus?.hashCode() ?: 0)
        result = 31 * result + (parameterGroupStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Node

        if (availabilityZone != other.availabilityZone) return false
        if (endpoint != other.endpoint) return false
        if (nodeCreateTime != other.nodeCreateTime) return false
        if (nodeId != other.nodeId) return false
        if (nodeStatus != other.nodeStatus) return false
        if (parameterGroupStatus != other.parameterGroupStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dax.model.Node = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Availability Zone (AZ) in which the node has been deployed.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The endpoint for the node, consisting of a DNS name and a port number. Client applications can connect directly to a node endpoint, if desired (as an alternative to allowing DAX client software to intelligently route requests and responses to nodes in the DAX cluster.
         */
        var endpoint: aws.sdk.kotlin.services.dax.model.Endpoint? = null
        /**
         * The date and time (in UNIX epoch format) when the node was launched.
         */
        var nodeCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A system-generated identifier for the node.
         */
        var nodeId: kotlin.String? = null
        /**
         * The current status of the node. For example: `available`.
         */
        var nodeStatus: kotlin.String? = null
        /**
         * The status of the parameter group associated with this node. For example, `in-sync`.
         */
        var parameterGroupStatus: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dax.model.Node) : this() {
            this.availabilityZone = x.availabilityZone
            this.endpoint = x.endpoint
            this.nodeCreateTime = x.nodeCreateTime
            this.nodeId = x.nodeId
            this.nodeStatus = x.nodeStatus
            this.parameterGroupStatus = x.parameterGroupStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dax.model.Node = Node(this)

        /**
         * construct an [aws.sdk.kotlin.services.dax.model.Endpoint] inside the given [block]
         */
        fun endpoint(block: aws.sdk.kotlin.services.dax.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.endpoint = aws.sdk.kotlin.services.dax.model.Endpoint.invoke(block)
        }
    }
}
