// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dax.model



/**
 * Describes an individual setting that controls some aspect of DAX behavior.
 */
class Parameter private constructor(builder: Builder) {
    /**
     * A range of values within which the parameter can be set.
     */
    val allowedValues: kotlin.String? = builder.allowedValues
    /**
     * The conditions under which changes to this parameter can be applied. For example, `requires-reboot` indicates that a new value for this parameter will only take effect if a node is rebooted.
     */
    val changeType: aws.sdk.kotlin.services.dax.model.ChangeType? = builder.changeType
    /**
     * The data type of the parameter. For example, `integer`:
     */
    val dataType: kotlin.String? = builder.dataType
    /**
     * A description of the parameter
     */
    val description: kotlin.String? = builder.description
    /**
     * Whether the customer is allowed to modify the parameter.
     */
    val isModifiable: aws.sdk.kotlin.services.dax.model.IsModifiable? = builder.isModifiable
    /**
     * A list of node types, and specific parameter values for each node.
     */
    val nodeTypeSpecificValues: List<NodeTypeSpecificValue>? = builder.nodeTypeSpecificValues
    /**
     * The name of the parameter.
     */
    val parameterName: kotlin.String? = builder.parameterName
    /**
     * Determines whether the parameter can be applied to any nodes, or only nodes of a particular type.
     */
    val parameterType: aws.sdk.kotlin.services.dax.model.ParameterType? = builder.parameterType
    /**
     * The value for the parameter.
     */
    val parameterValue: kotlin.String? = builder.parameterValue
    /**
     * How the parameter is defined. For example, `system` denotes a system-defined parameter.
     */
    val source: kotlin.String? = builder.source

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dax.model.Parameter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Parameter(")
        append("allowedValues=$allowedValues,")
        append("changeType=$changeType,")
        append("dataType=$dataType,")
        append("description=$description,")
        append("isModifiable=$isModifiable,")
        append("nodeTypeSpecificValues=$nodeTypeSpecificValues,")
        append("parameterName=$parameterName,")
        append("parameterType=$parameterType,")
        append("parameterValue=$parameterValue,")
        append("source=$source)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedValues?.hashCode() ?: 0
        result = 31 * result + (changeType?.hashCode() ?: 0)
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isModifiable?.hashCode() ?: 0)
        result = 31 * result + (nodeTypeSpecificValues?.hashCode() ?: 0)
        result = 31 * result + (parameterName?.hashCode() ?: 0)
        result = 31 * result + (parameterType?.hashCode() ?: 0)
        result = 31 * result + (parameterValue?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Parameter

        if (allowedValues != other.allowedValues) return false
        if (changeType != other.changeType) return false
        if (dataType != other.dataType) return false
        if (description != other.description) return false
        if (isModifiable != other.isModifiable) return false
        if (nodeTypeSpecificValues != other.nodeTypeSpecificValues) return false
        if (parameterName != other.parameterName) return false
        if (parameterType != other.parameterType) return false
        if (parameterValue != other.parameterValue) return false
        if (source != other.source) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dax.model.Parameter = Builder(this).apply(block).build()

    class Builder {
        /**
         * A range of values within which the parameter can be set.
         */
        var allowedValues: kotlin.String? = null
        /**
         * The conditions under which changes to this parameter can be applied. For example, `requires-reboot` indicates that a new value for this parameter will only take effect if a node is rebooted.
         */
        var changeType: aws.sdk.kotlin.services.dax.model.ChangeType? = null
        /**
         * The data type of the parameter. For example, `integer`:
         */
        var dataType: kotlin.String? = null
        /**
         * A description of the parameter
         */
        var description: kotlin.String? = null
        /**
         * Whether the customer is allowed to modify the parameter.
         */
        var isModifiable: aws.sdk.kotlin.services.dax.model.IsModifiable? = null
        /**
         * A list of node types, and specific parameter values for each node.
         */
        var nodeTypeSpecificValues: List<NodeTypeSpecificValue>? = null
        /**
         * The name of the parameter.
         */
        var parameterName: kotlin.String? = null
        /**
         * Determines whether the parameter can be applied to any nodes, or only nodes of a particular type.
         */
        var parameterType: aws.sdk.kotlin.services.dax.model.ParameterType? = null
        /**
         * The value for the parameter.
         */
        var parameterValue: kotlin.String? = null
        /**
         * How the parameter is defined. For example, `system` denotes a system-defined parameter.
         */
        var source: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dax.model.Parameter) : this() {
            this.allowedValues = x.allowedValues
            this.changeType = x.changeType
            this.dataType = x.dataType
            this.description = x.description
            this.isModifiable = x.isModifiable
            this.nodeTypeSpecificValues = x.nodeTypeSpecificValues
            this.parameterName = x.parameterName
            this.parameterType = x.parameterType
            this.parameterValue = x.parameterValue
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dax.model.Parameter = Parameter(this)
    }
}
