// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dax.model



class UpdateClusterRequest private constructor(builder: Builder) {
    /**
     * The name of the DAX cluster to be modified.
     */
    val clusterName: kotlin.String? = builder.clusterName
    /**
     * A description of the changes being made to the cluster.
     */
    val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) that identifies the topic.
     */
    val notificationTopicArn: kotlin.String? = builder.notificationTopicArn
    /**
     * The current state of the topic. A value of “active” means that notifications will be sent to the topic. A value of “inactive” means that notifications will not be sent to the topic.
     */
    val notificationTopicStatus: kotlin.String? = builder.notificationTopicStatus
    /**
     * The name of a parameter group for this cluster.
     */
    val parameterGroupName: kotlin.String? = builder.parameterGroupName
    /**
     * A range of time when maintenance of DAX cluster software will be performed. For example: `sun:01:00-sun:09:00`. Cluster maintenance normally takes less than 30 minutes, and is performed automatically within the maintenance window.
     */
    val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * A list of user-specified security group IDs to be assigned to each node in the DAX cluster. If this parameter is not specified, DAX assigns the default VPC security group to each node.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dax.model.UpdateClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateClusterRequest(")
        append("clusterName=$clusterName,")
        append("description=$description,")
        append("notificationTopicArn=$notificationTopicArn,")
        append("notificationTopicStatus=$notificationTopicStatus,")
        append("parameterGroupName=$parameterGroupName,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("securityGroupIds=$securityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterName?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (notificationTopicArn?.hashCode() ?: 0)
        result = 31 * result + (notificationTopicStatus?.hashCode() ?: 0)
        result = 31 * result + (parameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateClusterRequest

        if (clusterName != other.clusterName) return false
        if (description != other.description) return false
        if (notificationTopicArn != other.notificationTopicArn) return false
        if (notificationTopicStatus != other.notificationTopicStatus) return false
        if (parameterGroupName != other.parameterGroupName) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (securityGroupIds != other.securityGroupIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dax.model.UpdateClusterRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the DAX cluster to be modified.
         */
        var clusterName: kotlin.String? = null
        /**
         * A description of the changes being made to the cluster.
         */
        var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that identifies the topic.
         */
        var notificationTopicArn: kotlin.String? = null
        /**
         * The current state of the topic. A value of “active” means that notifications will be sent to the topic. A value of “inactive” means that notifications will not be sent to the topic.
         */
        var notificationTopicStatus: kotlin.String? = null
        /**
         * The name of a parameter group for this cluster.
         */
        var parameterGroupName: kotlin.String? = null
        /**
         * A range of time when maintenance of DAX cluster software will be performed. For example: `sun:01:00-sun:09:00`. Cluster maintenance normally takes less than 30 minutes, and is performed automatically within the maintenance window.
         */
        var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * A list of user-specified security group IDs to be assigned to each node in the DAX cluster. If this parameter is not specified, DAX assigns the default VPC security group to each node.
         */
        var securityGroupIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dax.model.UpdateClusterRequest) : this() {
            this.clusterName = x.clusterName
            this.description = x.description
            this.notificationTopicArn = x.notificationTopicArn
            this.notificationTopicStatus = x.notificationTopicStatus
            this.parameterGroupName = x.parameterGroupName
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.securityGroupIds = x.securityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dax.model.UpdateClusterRequest = UpdateClusterRequest(this)
    }
}
