// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.devopsguru.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.devopsguru.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon DevOps Guru is a fully managed service that helps you identify anomalous behavior in business critical operational applications. You specify the Amazon Web Services resources that you want DevOps Guru to cover, then the Amazon CloudWatch metrics and Amazon Web Services CloudTrail events related to those resources are analyzed. When anomalous behavior is detected, DevOps Guru creates an *insight* that includes recommendations, related events, and related metrics that can help you improve your operational applications. For more information, see [What is Amazon DevOps Guru](https://docs.aws.amazon.com/devops-guru/latest/userguide/welcome.html).
 *
 *  You can specify 1 or 2 Amazon Simple Notification Service topics so you are notified every time a new insight is created. You can also enable DevOps Guru to generate an OpsItem in Amazon Web Services Systems Manager for each insight to help you manage and track your work addressing insights.
 *
 *  To learn about the DevOps Guru workflow, see [How DevOps Guru works](https://docs.aws.amazon.com/devops-guru/latest/userguide/welcome.html#how-it-works). To learn about DevOps Guru concepts, see [Concepts in DevOps Guru](https://docs.aws.amazon.com/devops-guru/latest/userguide/concepts.html).
 */
interface DevOpsGuruClient : SdkClient {

    override val serviceName: String
        get() = "DevOps Guru"
    /**
     * DevOpsGuruClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): DevOpsGuruClient {
            val config = Config.Builder().apply(block).build()
            return DefaultDevOpsGuruClient(config)
        }

        operator fun invoke(config: Config): DevOpsGuruClient = DefaultDevOpsGuruClient(config)

        /**
         * Construct a [DevOpsGuruClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): DevOpsGuruClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultDevOpsGuruClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds a notification channel to DevOps Guru. A notification channel is used to notify you about important DevOps Guru events, such as when an insight is generated.
     *
     * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see [Permissions for cross account Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
     *
     * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see Permissions for cross account Amazon SNS topics.
     *
     * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see [Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
     */
    suspend fun addNotificationChannel(input: AddNotificationChannelRequest): AddNotificationChannelResponse

    /**
     * Adds a notification channel to DevOps Guru. A notification channel is used to notify you about important DevOps Guru events, such as when an insight is generated.
     *
     * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see [Permissions for cross account Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
     *
     * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see Permissions for cross account Amazon SNS topics.
     *
     * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see [Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
     */
    suspend fun addNotificationChannel(block: AddNotificationChannelRequest.Builder.() -> Unit) = addNotificationChannel(AddNotificationChannelRequest.Builder().apply(block).build())

    /**
     * Deletes the insight along with the associated anomalies, events and recommendations.
     */
    suspend fun deleteInsight(input: DeleteInsightRequest): DeleteInsightResponse

    /**
     * Deletes the insight along with the associated anomalies, events and recommendations.
     */
    suspend fun deleteInsight(block: DeleteInsightRequest.Builder.() -> Unit) = deleteInsight(DeleteInsightRequest.Builder().apply(block).build())

    /**
     * Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics analyzed in your Amazon Web Services account. Use these numbers to gauge the health of operations in your Amazon Web Services account.
     */
    suspend fun describeAccountHealth(input: DescribeAccountHealthRequest = DescribeAccountHealthRequest {}): DescribeAccountHealthResponse

    /**
     * Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics analyzed in your Amazon Web Services account. Use these numbers to gauge the health of operations in your Amazon Web Services account.
     */
    suspend fun describeAccountHealth(block: DescribeAccountHealthRequest.Builder.() -> Unit) = describeAccountHealth(DescribeAccountHealthRequest.Builder().apply(block).build())

    /**
     * For the time range passed in, returns the number of open reactive insight that were created, the number of open proactive insights that were created, and the Mean Time to Recover (MTTR) for all closed reactive insights.
     */
    suspend fun describeAccountOverview(input: DescribeAccountOverviewRequest): DescribeAccountOverviewResponse

    /**
     * For the time range passed in, returns the number of open reactive insight that were created, the number of open proactive insights that were created, and the Mean Time to Recover (MTTR) for all closed reactive insights.
     */
    suspend fun describeAccountOverview(block: DescribeAccountOverviewRequest.Builder.() -> Unit) = describeAccountOverview(DescribeAccountOverviewRequest.Builder().apply(block).build())

    /**
     * Returns details about an anomaly that you specify using its ID.
     */
    suspend fun describeAnomaly(input: DescribeAnomalyRequest): DescribeAnomalyResponse

    /**
     * Returns details about an anomaly that you specify using its ID.
     */
    suspend fun describeAnomaly(block: DescribeAnomalyRequest.Builder.() -> Unit) = describeAnomaly(DescribeAnomalyRequest.Builder().apply(block).build())

    /**
     * Returns the integration status of services that are integrated with DevOps Guru as Consumer via EventBridge. The one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can be stored and viewed in DevOps Guru.
     */
    suspend fun describeEventSourcesConfig(input: DescribeEventSourcesConfigRequest = DescribeEventSourcesConfigRequest {}): DescribeEventSourcesConfigResponse

    /**
     * Returns the integration status of services that are integrated with DevOps Guru as Consumer via EventBridge. The one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can be stored and viewed in DevOps Guru.
     */
    suspend fun describeEventSourcesConfig(block: DescribeEventSourcesConfigRequest.Builder.() -> Unit) = describeEventSourcesConfig(DescribeEventSourcesConfigRequest.Builder().apply(block).build())

    /**
     * Returns the most recent feedback submitted in the current Amazon Web Services account and Region.
     */
    suspend fun describeFeedback(input: DescribeFeedbackRequest = DescribeFeedbackRequest {}): DescribeFeedbackResponse

    /**
     * Returns the most recent feedback submitted in the current Amazon Web Services account and Region.
     */
    suspend fun describeFeedback(block: DescribeFeedbackRequest.Builder.() -> Unit) = describeFeedback(DescribeFeedbackRequest.Builder().apply(block).build())

    /**
     * Returns details about an insight that you specify using its ID.
     */
    suspend fun describeInsight(input: DescribeInsightRequest): DescribeInsightResponse

    /**
     * Returns details about an insight that you specify using its ID.
     */
    suspend fun describeInsight(block: DescribeInsightRequest.Builder.() -> Unit) = describeInsight(DescribeInsightRequest.Builder().apply(block).build())

    /**
     * Returns active insights, predictive insights, and resource hours analyzed in last hour.
     */
    suspend fun describeOrganizationHealth(input: DescribeOrganizationHealthRequest = DescribeOrganizationHealthRequest {}): DescribeOrganizationHealthResponse

    /**
     * Returns active insights, predictive insights, and resource hours analyzed in last hour.
     */
    suspend fun describeOrganizationHealth(block: DescribeOrganizationHealthRequest.Builder.() -> Unit) = describeOrganizationHealth(DescribeOrganizationHealthRequest.Builder().apply(block).build())

    /**
     * Returns an overview of your organization's history based on the specified time range. The overview includes the total reactive and proactive insights.
     */
    suspend fun describeOrganizationOverview(input: DescribeOrganizationOverviewRequest): DescribeOrganizationOverviewResponse

    /**
     * Returns an overview of your organization's history based on the specified time range. The overview includes the total reactive and proactive insights.
     */
    suspend fun describeOrganizationOverview(block: DescribeOrganizationOverviewRequest.Builder.() -> Unit) = describeOrganizationOverview(DescribeOrganizationOverviewRequest.Builder().apply(block).build())

    /**
     * Provides an overview of your system's health. If additional member accounts are part of your organization, you can filter those accounts using the `AccountIds` field.
     */
    suspend fun describeOrganizationResourceCollectionHealth(input: DescribeOrganizationResourceCollectionHealthRequest): DescribeOrganizationResourceCollectionHealthResponse

    /**
     * Provides an overview of your system's health. If additional member accounts are part of your organization, you can filter those accounts using the `AccountIds` field.
     */
    suspend fun describeOrganizationResourceCollectionHealth(block: DescribeOrganizationResourceCollectionHealthRequest.Builder.() -> Unit) = describeOrganizationResourceCollectionHealth(DescribeOrganizationResourceCollectionHealthRequest.Builder().apply(block).build())

    /**
     * Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR) for all closed insights in resource collections in your account. You specify the type of Amazon Web Services resources collection. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    suspend fun describeResourceCollectionHealth(input: DescribeResourceCollectionHealthRequest): DescribeResourceCollectionHealthResponse

    /**
     * Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR) for all closed insights in resource collections in your account. You specify the type of Amazon Web Services resources collection. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    suspend fun describeResourceCollectionHealth(block: DescribeResourceCollectionHealthRequest.Builder.() -> Unit) = describeResourceCollectionHealth(DescribeResourceCollectionHealthRequest.Builder().apply(block).build())

    /**
     * Returns the integration status of services that are integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight.
     */
    suspend fun describeServiceIntegration(input: DescribeServiceIntegrationRequest = DescribeServiceIntegrationRequest {}): DescribeServiceIntegrationResponse

    /**
     * Returns the integration status of services that are integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight.
     */
    suspend fun describeServiceIntegration(block: DescribeServiceIntegrationRequest.Builder.() -> Unit) = describeServiceIntegration(DescribeServiceIntegrationRequest.Builder().apply(block).build())

    /**
     * Returns an estimate of the monthly cost for DevOps Guru to analyze your Amazon Web Services resources. For more information, see [Estimate your Amazon DevOps Guru costs](https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html) and [Amazon DevOps Guru pricing](http://aws.amazon.com/devops-guru/pricing/).
     */
    suspend fun getCostEstimation(input: GetCostEstimationRequest = GetCostEstimationRequest {}): GetCostEstimationResponse

    /**
     * Returns an estimate of the monthly cost for DevOps Guru to analyze your Amazon Web Services resources. For more information, see [Estimate your Amazon DevOps Guru costs](https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html) and [Amazon DevOps Guru pricing](http://aws.amazon.com/devops-guru/pricing/).
     */
    suspend fun getCostEstimation(block: GetCostEstimationRequest.Builder.() -> Unit) = getCostEstimation(GetCostEstimationRequest.Builder().apply(block).build())

    /**
     * Returns lists Amazon Web Services resources that are of the specified resource collection type. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    suspend fun getResourceCollection(input: GetResourceCollectionRequest): GetResourceCollectionResponse

    /**
     * Returns lists Amazon Web Services resources that are of the specified resource collection type. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    suspend fun getResourceCollection(block: GetResourceCollectionRequest.Builder.() -> Unit) = getResourceCollection(GetResourceCollectionRequest.Builder().apply(block).build())

    /**
     * Returns a list of the anomalies that belong to an insight that you specify using its ID.
     */
    suspend fun listAnomaliesForInsight(input: ListAnomaliesForInsightRequest): ListAnomaliesForInsightResponse

    /**
     * Returns a list of the anomalies that belong to an insight that you specify using its ID.
     */
    suspend fun listAnomaliesForInsight(block: ListAnomaliesForInsightRequest.Builder.() -> Unit) = listAnomaliesForInsight(ListAnomaliesForInsightRequest.Builder().apply(block).build())

    /**
     * Returns a list of the events emitted by the resources that are evaluated by DevOps Guru. You can use filters to specify which events are returned.
     */
    suspend fun listEvents(input: ListEventsRequest): ListEventsResponse

    /**
     * Returns a list of the events emitted by the resources that are evaluated by DevOps Guru. You can use filters to specify which events are returned.
     */
    suspend fun listEvents(block: ListEventsRequest.Builder.() -> Unit) = listEvents(ListEventsRequest.Builder().apply(block).build())

    /**
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time and status (`ONGOING`, `CLOSED`, or `ANY`).
     */
    suspend fun listInsights(input: ListInsightsRequest): ListInsightsResponse

    /**
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time and status (`ONGOING`, `CLOSED`, or `ANY`).
     */
    suspend fun listInsights(block: ListInsightsRequest.Builder.() -> Unit) = listInsights(ListInsightsRequest.Builder().apply(block).build())

    /**
     * Returns a list of notification channels configured for DevOps Guru. Each notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS).
     */
    suspend fun listNotificationChannels(input: ListNotificationChannelsRequest = ListNotificationChannelsRequest {}): ListNotificationChannelsResponse

    /**
     * Returns a list of notification channels configured for DevOps Guru. Each notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS).
     */
    suspend fun listNotificationChannels(block: ListNotificationChannelsRequest.Builder.() -> Unit) = listNotificationChannels(ListNotificationChannelsRequest.Builder().apply(block).build())

    /**
     * Returns a list of insights associated with the account or OU Id.
     */
    suspend fun listOrganizationInsights(input: ListOrganizationInsightsRequest): ListOrganizationInsightsResponse

    /**
     * Returns a list of insights associated with the account or OU Id.
     */
    suspend fun listOrganizationInsights(block: ListOrganizationInsightsRequest.Builder.() -> Unit) = listOrganizationInsights(ListOrganizationInsightsRequest.Builder().apply(block).build())

    /**
     * Returns a list of a specified insight's recommendations. Each recommendation includes a list of related metrics and a list of related events.
     */
    suspend fun listRecommendations(input: ListRecommendationsRequest): ListRecommendationsResponse

    /**
     * Returns a list of a specified insight's recommendations. Each recommendation includes a list of related metrics and a list of related events.
     */
    suspend fun listRecommendations(block: ListRecommendationsRequest.Builder.() -> Unit) = listRecommendations(ListRecommendationsRequest.Builder().apply(block).build())

    /**
     * Collects customer feedback about the specified insight.
     */
    suspend fun putFeedback(input: PutFeedbackRequest = PutFeedbackRequest {}): PutFeedbackResponse

    /**
     * Collects customer feedback about the specified insight.
     */
    suspend fun putFeedback(block: PutFeedbackRequest.Builder.() -> Unit) = putFeedback(PutFeedbackRequest.Builder().apply(block).build())

    /**
     * Removes a notification channel from DevOps Guru. A notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations.
     */
    suspend fun removeNotificationChannel(input: RemoveNotificationChannelRequest): RemoveNotificationChannelResponse

    /**
     * Removes a notification channel from DevOps Guru. A notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations.
     */
    suspend fun removeNotificationChannel(block: RemoveNotificationChannelRequest.Builder.() -> Unit) = removeNotificationChannel(RemoveNotificationChannelRequest.Builder().apply(block).build())

    /**
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time, one or more statuses (`ONGOING`, `CLOSED`, and `CLOSED`), one or more severities (`LOW`, `MEDIUM`, and `HIGH`), and type (`REACTIVE` or `PROACTIVE`).
     *
     *  Use the `Filters` parameter to specify status and severity search parameters. Use the `Type` parameter to specify `REACTIVE` or `PROACTIVE` in your search.
     */
    suspend fun searchInsights(input: SearchInsightsRequest): SearchInsightsResponse

    /**
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time, one or more statuses (`ONGOING`, `CLOSED`, and `CLOSED`), one or more severities (`LOW`, `MEDIUM`, and `HIGH`), and type (`REACTIVE` or `PROACTIVE`).
     *
     *  Use the `Filters` parameter to specify status and severity search parameters. Use the `Type` parameter to specify `REACTIVE` or `PROACTIVE` in your search.
     */
    suspend fun searchInsights(block: SearchInsightsRequest.Builder.() -> Unit) = searchInsights(SearchInsightsRequest.Builder().apply(block).build())

    /**
     * Returns a list of insights in your organization. You can specify which insights are returned by their start time, one or more statuses (`ONGOING`, `CLOSED`, and `CLOSED`), one or more severities (`LOW`, `MEDIUM`, and `HIGH`), and type (`REACTIVE` or `PROACTIVE`).
     *
     *  Use the `Filters` parameter to specify status and severity search parameters. Use the `Type` parameter to specify `REACTIVE` or `PROACTIVE` in your search.
     */
    suspend fun searchOrganizationInsights(input: SearchOrganizationInsightsRequest): SearchOrganizationInsightsResponse

    /**
     * Returns a list of insights in your organization. You can specify which insights are returned by their start time, one or more statuses (`ONGOING`, `CLOSED`, and `CLOSED`), one or more severities (`LOW`, `MEDIUM`, and `HIGH`), and type (`REACTIVE` or `PROACTIVE`).
     *
     *  Use the `Filters` parameter to specify status and severity search parameters. Use the `Type` parameter to specify `REACTIVE` or `PROACTIVE` in your search.
     */
    suspend fun searchOrganizationInsights(block: SearchOrganizationInsightsRequest.Builder.() -> Unit) = searchOrganizationInsights(SearchOrganizationInsightsRequest.Builder().apply(block).build())

    /**
     * Starts the creation of an estimate of the monthly cost to analyze your Amazon Web Services resources.
     */
    suspend fun startCostEstimation(input: StartCostEstimationRequest): StartCostEstimationResponse

    /**
     * Starts the creation of an estimate of the monthly cost to analyze your Amazon Web Services resources.
     */
    suspend fun startCostEstimation(block: StartCostEstimationRequest.Builder.() -> Unit) = startCostEstimation(StartCostEstimationRequest.Builder().apply(block).build())

    /**
     * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can be stored and viewed in DevOps Guru.
     */
    suspend fun updateEventSourcesConfig(input: UpdateEventSourcesConfigRequest = UpdateEventSourcesConfigRequest {}): UpdateEventSourcesConfigResponse

    /**
     * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can be stored and viewed in DevOps Guru.
     */
    suspend fun updateEventSourcesConfig(block: UpdateEventSourcesConfigRequest.Builder.() -> Unit) = updateEventSourcesConfig(UpdateEventSourcesConfigRequest.Builder().apply(block).build())

    /**
     * Updates the collection of resources that DevOps Guru analyzes. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks. This method also creates the IAM role required for you to use DevOps Guru.
     */
    suspend fun updateResourceCollection(input: UpdateResourceCollectionRequest): UpdateResourceCollectionResponse

    /**
     * Updates the collection of resources that DevOps Guru analyzes. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks. This method also creates the IAM role required for you to use DevOps Guru.
     */
    suspend fun updateResourceCollection(block: UpdateResourceCollectionRequest.Builder.() -> Unit) = updateResourceCollection(UpdateResourceCollectionRequest.Builder().apply(block).build())

    /**
     * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight.
     */
    suspend fun updateServiceIntegration(input: UpdateServiceIntegrationRequest): UpdateServiceIntegrationResponse

    /**
     * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight.
     */
    suspend fun updateServiceIntegration(block: UpdateServiceIntegrationRequest.Builder.() -> Unit) = updateServiceIntegration(UpdateServiceIntegrationRequest.Builder().apply(block).build())
}
