// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



class DescribeOrganizationResourceCollectionHealthRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account.
     */
    val accountIds: List<String>? = builder.accountIds
    /**
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned `nextToken` value.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    val organizationResourceCollectionType: aws.sdk.kotlin.services.devopsguru.model.OrganizationResourceCollectionType? = builder.organizationResourceCollectionType
    /**
     * The ID of the organizational unit.
     */
    val organizationalUnitIds: List<String>? = builder.organizationalUnitIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeOrganizationResourceCollectionHealthRequest(")
        append("accountIds=$accountIds,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("organizationResourceCollectionType=$organizationResourceCollectionType,")
        append("organizationalUnitIds=$organizationalUnitIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIds?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (organizationResourceCollectionType?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnitIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeOrganizationResourceCollectionHealthRequest

        if (accountIds != other.accountIds) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (organizationResourceCollectionType != other.organizationResourceCollectionType) return false
        if (organizationalUnitIds != other.organizationalUnitIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the Amazon Web Services account.
         */
        var accountIds: List<String>? = null
        /**
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned `nextToken` value.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.
         */
        var nextToken: kotlin.String? = null
        /**
         * An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         */
        var organizationResourceCollectionType: aws.sdk.kotlin.services.devopsguru.model.OrganizationResourceCollectionType? = null
        /**
         * The ID of the organizational unit.
         */
        var organizationalUnitIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest) : this() {
            this.accountIds = x.accountIds
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.organizationResourceCollectionType = x.organizationResourceCollectionType
            this.organizationalUnitIds = x.organizationalUnitIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest = DescribeOrganizationResourceCollectionHealthRequest(this)
    }
}
