// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An Amazon Web Services resource event. Amazon Web Services resource events and metrics are analyzed by DevOps Guru to find anomalous behavior and provide recommendations to improve your operational solutions.
 */
class Event private constructor(builder: Builder) {
    /**
     * The source, `AWS_CLOUD_TRAIL` or `AWS_CODE_DEPLOY`, where DevOps Guru analysis found the event.
     */
    val dataSource: aws.sdk.kotlin.services.devopsguru.model.EventDataSource? = builder.dataSource
    /**
     * The class of the event. The class specifies what the event is related to, such as an infrastructure change, a deployment, or a schema change.
     */
    val eventClass: aws.sdk.kotlin.services.devopsguru.model.EventClass? = builder.eventClass
    /**
     * The Amazon Web Services source that emitted the event.
     */
    val eventSource: kotlin.String? = builder.eventSource
    /**
     * The ID of the event.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name of the event.
     */
    val name: kotlin.String? = builder.name
    /**
     * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    val resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = builder.resourceCollection
    /**
     * An `EventResource` object that contains information about the resource that emitted the event.
     */
    val resources: List<EventResource>? = builder.resources
    /**
     * A `Timestamp` that specifies the time the event occurred.
     */
    val time: aws.smithy.kotlin.runtime.time.Instant? = builder.time

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.Event = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Event(")
        append("dataSource=$dataSource,")
        append("eventClass=$eventClass,")
        append("eventSource=$eventSource,")
        append("id=$id,")
        append("name=$name,")
        append("resourceCollection=$resourceCollection,")
        append("resources=$resources,")
        append("time=$time)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSource?.hashCode() ?: 0
        result = 31 * result + (eventClass?.hashCode() ?: 0)
        result = 31 * result + (eventSource?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceCollection?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (time?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Event

        if (dataSource != other.dataSource) return false
        if (eventClass != other.eventClass) return false
        if (eventSource != other.eventSource) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (resourceCollection != other.resourceCollection) return false
        if (resources != other.resources) return false
        if (time != other.time) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.Event = Builder(this).apply(block).build()

    class Builder {
        /**
         * The source, `AWS_CLOUD_TRAIL` or `AWS_CODE_DEPLOY`, where DevOps Guru analysis found the event.
         */
        var dataSource: aws.sdk.kotlin.services.devopsguru.model.EventDataSource? = null
        /**
         * The class of the event. The class specifies what the event is related to, such as an infrastructure change, a deployment, or a schema change.
         */
        var eventClass: aws.sdk.kotlin.services.devopsguru.model.EventClass? = null
        /**
         * The Amazon Web Services source that emitted the event.
         */
        var eventSource: kotlin.String? = null
        /**
         * The ID of the event.
         */
        var id: kotlin.String? = null
        /**
         * The name of the event.
         */
        var name: kotlin.String? = null
        /**
         * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         */
        var resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = null
        /**
         * An `EventResource` object that contains information about the resource that emitted the event.
         */
        var resources: List<EventResource>? = null
        /**
         * A `Timestamp` that specifies the time the event occurred.
         */
        var time: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.Event) : this() {
            this.dataSource = x.dataSource
            this.eventClass = x.eventClass
            this.eventSource = x.eventSource
            this.id = x.id
            this.name = x.name
            this.resourceCollection = x.resourceCollection
            this.resources = x.resources
            this.time = x.time
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.Event = Event(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.ResourceCollection] inside the given [block]
         */
        fun resourceCollection(block: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.Builder.() -> kotlin.Unit) {
            this.resourceCollection = aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.invoke(block)
        }
    }
}
