// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Filters you can use to specify which events are returned when `ListEvents` is called.
 */
class ListEventsFilters private constructor(builder: Builder) {
    /**
     * The source, `AWS_CLOUD_TRAIL` or `AWS_CODE_DEPLOY`, of the events you want returned.
     */
    val dataSource: aws.sdk.kotlin.services.devopsguru.model.EventDataSource? = builder.dataSource
    /**
     * The class of the events you want to filter for, such as an infrastructure change, a deployment, or a schema change.
     */
    val eventClass: aws.sdk.kotlin.services.devopsguru.model.EventClass? = builder.eventClass
    /**
     * The Amazon Web Services source that emitted the events you want to filter for.
     */
    val eventSource: kotlin.String? = builder.eventSource
    /**
     * A time range during which you want the filtered events to have occurred.
     */
    val eventTimeRange: aws.sdk.kotlin.services.devopsguru.model.EventTimeRange? = builder.eventTimeRange
    /**
     * An ID of an insight that is related to the events you want to filter for.
     */
    val insightId: kotlin.String? = builder.insightId
    /**
     * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    val resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = builder.resourceCollection

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.ListEventsFilters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListEventsFilters(")
        append("dataSource=$dataSource,")
        append("eventClass=$eventClass,")
        append("eventSource=$eventSource,")
        append("eventTimeRange=$eventTimeRange,")
        append("insightId=$insightId,")
        append("resourceCollection=$resourceCollection)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSource?.hashCode() ?: 0
        result = 31 * result + (eventClass?.hashCode() ?: 0)
        result = 31 * result + (eventSource?.hashCode() ?: 0)
        result = 31 * result + (eventTimeRange?.hashCode() ?: 0)
        result = 31 * result + (insightId?.hashCode() ?: 0)
        result = 31 * result + (resourceCollection?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListEventsFilters

        if (dataSource != other.dataSource) return false
        if (eventClass != other.eventClass) return false
        if (eventSource != other.eventSource) return false
        if (eventTimeRange != other.eventTimeRange) return false
        if (insightId != other.insightId) return false
        if (resourceCollection != other.resourceCollection) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.ListEventsFilters = Builder(this).apply(block).build()

    class Builder {
        /**
         * The source, `AWS_CLOUD_TRAIL` or `AWS_CODE_DEPLOY`, of the events you want returned.
         */
        var dataSource: aws.sdk.kotlin.services.devopsguru.model.EventDataSource? = null
        /**
         * The class of the events you want to filter for, such as an infrastructure change, a deployment, or a schema change.
         */
        var eventClass: aws.sdk.kotlin.services.devopsguru.model.EventClass? = null
        /**
         * The Amazon Web Services source that emitted the events you want to filter for.
         */
        var eventSource: kotlin.String? = null
        /**
         * A time range during which you want the filtered events to have occurred.
         */
        var eventTimeRange: aws.sdk.kotlin.services.devopsguru.model.EventTimeRange? = null
        /**
         * An ID of an insight that is related to the events you want to filter for.
         */
        var insightId: kotlin.String? = null
        /**
         * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         */
        var resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.ListEventsFilters) : this() {
            this.dataSource = x.dataSource
            this.eventClass = x.eventClass
            this.eventSource = x.eventSource
            this.eventTimeRange = x.eventTimeRange
            this.insightId = x.insightId
            this.resourceCollection = x.resourceCollection
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.ListEventsFilters = ListEventsFilters(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.EventTimeRange] inside the given [block]
         */
        fun eventTimeRange(block: aws.sdk.kotlin.services.devopsguru.model.EventTimeRange.Builder.() -> kotlin.Unit) {
            this.eventTimeRange = aws.sdk.kotlin.services.devopsguru.model.EventTimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.ResourceCollection] inside the given [block]
         */
        fun resourceCollection(block: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.Builder.() -> kotlin.Unit) {
            this.resourceCollection = aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.invoke(block)
        }
    }
}
