// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Information about a notification channel. A notification channel is used to notify you when DevOps Guru creates an insight. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS).
 *
 * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see [Permissions for cross account Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
 *
 * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see Permissions for cross account Amazon SNS topics.
 *
 * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see [Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
 */
class NotificationChannel private constructor(builder: Builder) {
    /**
     * A `NotificationChannelConfig` object that contains information about configured notification channels.
     */
    val config: aws.sdk.kotlin.services.devopsguru.model.NotificationChannelConfig? = builder.config
    /**
     * The ID of a notification channel.
     */
    val id: kotlin.String? = builder.id

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.NotificationChannel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotificationChannel(")
        append("config=$config,")
        append("id=$id)")
    }

    override fun hashCode(): kotlin.Int {
        var result = config?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotificationChannel

        if (config != other.config) return false
        if (id != other.id) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.NotificationChannel = Builder(this).apply(block).build()

    class Builder {
        /**
         * A `NotificationChannelConfig` object that contains information about configured notification channels.
         */
        var config: aws.sdk.kotlin.services.devopsguru.model.NotificationChannelConfig? = null
        /**
         * The ID of a notification channel.
         */
        var id: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.NotificationChannel) : this() {
            this.config = x.config
            this.id = x.id
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.NotificationChannel = NotificationChannel(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.NotificationChannelConfig] inside the given [block]
         */
        fun config(block: aws.sdk.kotlin.services.devopsguru.model.NotificationChannelConfig.Builder.() -> kotlin.Unit) {
            this.config = aws.sdk.kotlin.services.devopsguru.model.NotificationChannelConfig.invoke(block)
        }
    }
}
