// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Details about Performance Insights metrics.
 *
 * Amazon RDS Performance Insights enables you to monitor and explore different dimensions of database load based on data captured from a running DB instance. DB load is measured as average active sessions. Performance Insights provides the data to API consumers as a two-dimensional time-series dataset. The time dimension provides DB load data for each time point in the queried time range. Each time point decomposes overall load in relation to the requested dimensions, measured at that time point. Examples include SQL, Wait event, User, and Host.
 * + To learn more about Performance Insights and Amazon Aurora DB instances, go to the [ Amazon Aurora User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html).
 * + To learn more about Performance Insights and Amazon RDS DB instances, go to the [ Amazon RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html).
 */
class PerformanceInsightsMetricsDetail private constructor(builder: Builder) {
    /**
     * The name used for a specific Performance Insights metric.
     */
    val metricDisplayName: kotlin.String? = builder.metricDisplayName
    /**
     * A single query to be processed for the metric. For more information, see ` <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsMetricQuery.html">PerformanceInsightsMetricQuery</a> `.
     */
    val metricQuery: aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricQuery? = builder.metricQuery
    /**
     * For more information, see ` <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceData.html">PerformanceInsightsReferenceData</a> `.
     */
    val referenceData: List<PerformanceInsightsReferenceData>? = builder.referenceData
    /**
     * The metric statistics during the anomalous period detected by DevOps Guru;
     */
    val statsAtAnomaly: List<PerformanceInsightsStat>? = builder.statsAtAnomaly
    /**
     * Typical metric statistics that are not considered anomalous. When DevOps Guru analyzes metrics, it compares them to `StatsAtBaseline` to help determine if they are anomalous.
     */
    val statsAtBaseline: List<PerformanceInsightsStat>? = builder.statsAtBaseline
    /**
     * The unit of measure for a metric. For example, a session or a process.
     */
    val unit: kotlin.String? = builder.unit

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricsDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PerformanceInsightsMetricsDetail(")
        append("metricDisplayName=$metricDisplayName,")
        append("metricQuery=$metricQuery,")
        append("referenceData=$referenceData,")
        append("statsAtAnomaly=$statsAtAnomaly,")
        append("statsAtBaseline=$statsAtBaseline,")
        append("unit=$unit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = metricDisplayName?.hashCode() ?: 0
        result = 31 * result + (metricQuery?.hashCode() ?: 0)
        result = 31 * result + (referenceData?.hashCode() ?: 0)
        result = 31 * result + (statsAtAnomaly?.hashCode() ?: 0)
        result = 31 * result + (statsAtBaseline?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PerformanceInsightsMetricsDetail

        if (metricDisplayName != other.metricDisplayName) return false
        if (metricQuery != other.metricQuery) return false
        if (referenceData != other.referenceData) return false
        if (statsAtAnomaly != other.statsAtAnomaly) return false
        if (statsAtBaseline != other.statsAtBaseline) return false
        if (unit != other.unit) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricsDetail = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name used for a specific Performance Insights metric.
         */
        var metricDisplayName: kotlin.String? = null
        /**
         * A single query to be processed for the metric. For more information, see ` <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsMetricQuery.html">PerformanceInsightsMetricQuery</a> `.
         */
        var metricQuery: aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricQuery? = null
        /**
         * For more information, see ` <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceData.html">PerformanceInsightsReferenceData</a> `.
         */
        var referenceData: List<PerformanceInsightsReferenceData>? = null
        /**
         * The metric statistics during the anomalous period detected by DevOps Guru;
         */
        var statsAtAnomaly: List<PerformanceInsightsStat>? = null
        /**
         * Typical metric statistics that are not considered anomalous. When DevOps Guru analyzes metrics, it compares them to `StatsAtBaseline` to help determine if they are anomalous.
         */
        var statsAtBaseline: List<PerformanceInsightsStat>? = null
        /**
         * The unit of measure for a metric. For example, a session or a process.
         */
        var unit: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricsDetail) : this() {
            this.metricDisplayName = x.metricDisplayName
            this.metricQuery = x.metricQuery
            this.referenceData = x.referenceData
            this.statsAtAnomaly = x.statsAtAnomaly
            this.statsAtBaseline = x.statsAtBaseline
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricsDetail = PerformanceInsightsMetricsDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricQuery] inside the given [block]
         */
        fun metricQuery(block: aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricQuery.Builder.() -> kotlin.Unit) {
            this.metricQuery = aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricQuery.invoke(block)
        }
    }
}
