// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an anomaly. This object is returned by `ListAnomalies`.
 */
class ProactiveAnomaly private constructor(builder: Builder) {
    /**
     * An `AnomalyReportedTimeRange` object that specifies the time range between when the anomaly is opened and the time when it is closed.
     */
    val anomalyReportedTimeRange: aws.sdk.kotlin.services.devopsguru.model.AnomalyReportedTimeRange? = builder.anomalyReportedTimeRange
    /**
     * Information about a resource in which DevOps Guru detected anomalous behavior.
     */
    val anomalyResources: List<AnomalyResource>? = builder.anomalyResources
    /**
     * A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from `AnomalyReportedTimeRange`, which specifies the time range when DevOps Guru opens and then closes an anomaly.
     */
    val anomalyTimeRange: aws.sdk.kotlin.services.devopsguru.model.AnomalyTimeRange? = builder.anomalyTimeRange
    /**
     * The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
     */
    val associatedInsightId: kotlin.String? = builder.associatedInsightId
    /**
     * The ID of a proactive anomaly.
     */
    val id: kotlin.String? = builder.id
    /**
     * A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to the anomalous behavior that generated this anomaly.
     */
    val limit: kotlin.Double? = builder.limit
    /**
     * The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
     */
    val predictionTimeRange: aws.sdk.kotlin.services.devopsguru.model.PredictionTimeRange? = builder.predictionTimeRange
    /**
     * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    val resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = builder.resourceCollection
    /**
     * The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities) in the *Amazon DevOps Guru User Guide*.
     */
    val severity: aws.sdk.kotlin.services.devopsguru.model.AnomalySeverity? = builder.severity
    /**
     * Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics.
     */
    val sourceDetails: aws.sdk.kotlin.services.devopsguru.model.AnomalySourceDetails? = builder.sourceDetails
    /**
     * The metadata for the anomaly.
     */
    val sourceMetadata: aws.sdk.kotlin.services.devopsguru.model.AnomalySourceMetadata? = builder.sourceMetadata
    /**
     * The status of a proactive anomaly.
     */
    val status: aws.sdk.kotlin.services.devopsguru.model.AnomalyStatus? = builder.status
    /**
     * The time of the anomaly's most recent update.
     */
    val updateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.updateTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.ProactiveAnomaly = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProactiveAnomaly(")
        append("anomalyReportedTimeRange=$anomalyReportedTimeRange,")
        append("anomalyResources=$anomalyResources,")
        append("anomalyTimeRange=$anomalyTimeRange,")
        append("associatedInsightId=$associatedInsightId,")
        append("id=$id,")
        append("limit=$limit,")
        append("predictionTimeRange=$predictionTimeRange,")
        append("resourceCollection=$resourceCollection,")
        append("severity=$severity,")
        append("sourceDetails=$sourceDetails,")
        append("sourceMetadata=$sourceMetadata,")
        append("status=$status,")
        append("updateTime=$updateTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = anomalyReportedTimeRange?.hashCode() ?: 0
        result = 31 * result + (anomalyResources?.hashCode() ?: 0)
        result = 31 * result + (anomalyTimeRange?.hashCode() ?: 0)
        result = 31 * result + (associatedInsightId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (limit?.hashCode() ?: 0)
        result = 31 * result + (predictionTimeRange?.hashCode() ?: 0)
        result = 31 * result + (resourceCollection?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (sourceDetails?.hashCode() ?: 0)
        result = 31 * result + (sourceMetadata?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProactiveAnomaly

        if (anomalyReportedTimeRange != other.anomalyReportedTimeRange) return false
        if (anomalyResources != other.anomalyResources) return false
        if (anomalyTimeRange != other.anomalyTimeRange) return false
        if (associatedInsightId != other.associatedInsightId) return false
        if (id != other.id) return false
        if (limit != other.limit) return false
        if (predictionTimeRange != other.predictionTimeRange) return false
        if (resourceCollection != other.resourceCollection) return false
        if (severity != other.severity) return false
        if (sourceDetails != other.sourceDetails) return false
        if (sourceMetadata != other.sourceMetadata) return false
        if (status != other.status) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.ProactiveAnomaly = Builder(this).apply(block).build()

    class Builder {
        /**
         * An `AnomalyReportedTimeRange` object that specifies the time range between when the anomaly is opened and the time when it is closed.
         */
        var anomalyReportedTimeRange: aws.sdk.kotlin.services.devopsguru.model.AnomalyReportedTimeRange? = null
        /**
         * Information about a resource in which DevOps Guru detected anomalous behavior.
         */
        var anomalyResources: List<AnomalyResource>? = null
        /**
         * A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from `AnomalyReportedTimeRange`, which specifies the time range when DevOps Guru opens and then closes an anomaly.
         */
        var anomalyTimeRange: aws.sdk.kotlin.services.devopsguru.model.AnomalyTimeRange? = null
        /**
         * The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
         */
        var associatedInsightId: kotlin.String? = null
        /**
         * The ID of a proactive anomaly.
         */
        var id: kotlin.String? = null
        /**
         * A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to the anomalous behavior that generated this anomaly.
         */
        var limit: kotlin.Double? = null
        /**
         * The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
         */
        var predictionTimeRange: aws.sdk.kotlin.services.devopsguru.model.PredictionTimeRange? = null
        /**
         * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         */
        var resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = null
        /**
         * The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities) in the *Amazon DevOps Guru User Guide*.
         */
        var severity: aws.sdk.kotlin.services.devopsguru.model.AnomalySeverity? = null
        /**
         * Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics.
         */
        var sourceDetails: aws.sdk.kotlin.services.devopsguru.model.AnomalySourceDetails? = null
        /**
         * The metadata for the anomaly.
         */
        var sourceMetadata: aws.sdk.kotlin.services.devopsguru.model.AnomalySourceMetadata? = null
        /**
         * The status of a proactive anomaly.
         */
        var status: aws.sdk.kotlin.services.devopsguru.model.AnomalyStatus? = null
        /**
         * The time of the anomaly's most recent update.
         */
        var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.ProactiveAnomaly) : this() {
            this.anomalyReportedTimeRange = x.anomalyReportedTimeRange
            this.anomalyResources = x.anomalyResources
            this.anomalyTimeRange = x.anomalyTimeRange
            this.associatedInsightId = x.associatedInsightId
            this.id = x.id
            this.limit = x.limit
            this.predictionTimeRange = x.predictionTimeRange
            this.resourceCollection = x.resourceCollection
            this.severity = x.severity
            this.sourceDetails = x.sourceDetails
            this.sourceMetadata = x.sourceMetadata
            this.status = x.status
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.ProactiveAnomaly = ProactiveAnomaly(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.AnomalyReportedTimeRange] inside the given [block]
         */
        fun anomalyReportedTimeRange(block: aws.sdk.kotlin.services.devopsguru.model.AnomalyReportedTimeRange.Builder.() -> kotlin.Unit) {
            this.anomalyReportedTimeRange = aws.sdk.kotlin.services.devopsguru.model.AnomalyReportedTimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.AnomalyTimeRange] inside the given [block]
         */
        fun anomalyTimeRange(block: aws.sdk.kotlin.services.devopsguru.model.AnomalyTimeRange.Builder.() -> kotlin.Unit) {
            this.anomalyTimeRange = aws.sdk.kotlin.services.devopsguru.model.AnomalyTimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.PredictionTimeRange] inside the given [block]
         */
        fun predictionTimeRange(block: aws.sdk.kotlin.services.devopsguru.model.PredictionTimeRange.Builder.() -> kotlin.Unit) {
            this.predictionTimeRange = aws.sdk.kotlin.services.devopsguru.model.PredictionTimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.ResourceCollection] inside the given [block]
         */
        fun resourceCollection(block: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.Builder.() -> kotlin.Unit) {
            this.resourceCollection = aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.AnomalySourceDetails] inside the given [block]
         */
        fun sourceDetails(block: aws.sdk.kotlin.services.devopsguru.model.AnomalySourceDetails.Builder.() -> kotlin.Unit) {
            this.sourceDetails = aws.sdk.kotlin.services.devopsguru.model.AnomalySourceDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.AnomalySourceMetadata] inside the given [block]
         */
        fun sourceMetadata(block: aws.sdk.kotlin.services.devopsguru.model.AnomalySourceMetadata.Builder.() -> kotlin.Unit) {
            this.sourceMetadata = aws.sdk.kotlin.services.devopsguru.model.AnomalySourceMetadata.invoke(block)
        }
    }
}
