// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Information about a reactive insight. This object is returned by `ListInsights`.
 */
class ReactiveInsight private constructor(builder: Builder) {
    /**
     * Describes the reactive insight.
     */
    val description: kotlin.String? = builder.description
    /**
     * The ID of a reactive insight.
     */
    val id: kotlin.String? = builder.id
    /**
     * A time ranged that specifies when the observed behavior in an insight started and ended.
     */
    val insightTimeRange: aws.sdk.kotlin.services.devopsguru.model.InsightTimeRange? = builder.insightTimeRange
    /**
     * The name of a reactive insight.
     */
    val name: kotlin.String? = builder.name
    /**
     * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    val resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = builder.resourceCollection
    /**
     * The severity of the insight. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities) in the *Amazon DevOps Guru User Guide*.
     */
    val severity: aws.sdk.kotlin.services.devopsguru.model.InsightSeverity? = builder.severity
    /**
     * The ID of the Amazon Web Services System Manager OpsItem created for this insight. You must enable the creation of OpstItems insights before they are created for each insight.
     */
    val ssmOpsItemId: kotlin.String? = builder.ssmOpsItemId
    /**
     * The status of a reactive insight.
     */
    val status: aws.sdk.kotlin.services.devopsguru.model.InsightStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.ReactiveInsight = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReactiveInsight(")
        append("description=$description,")
        append("id=$id,")
        append("insightTimeRange=$insightTimeRange,")
        append("name=$name,")
        append("resourceCollection=$resourceCollection,")
        append("severity=$severity,")
        append("ssmOpsItemId=$ssmOpsItemId,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (insightTimeRange?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceCollection?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (ssmOpsItemId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReactiveInsight

        if (description != other.description) return false
        if (id != other.id) return false
        if (insightTimeRange != other.insightTimeRange) return false
        if (name != other.name) return false
        if (resourceCollection != other.resourceCollection) return false
        if (severity != other.severity) return false
        if (ssmOpsItemId != other.ssmOpsItemId) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.ReactiveInsight = Builder(this).apply(block).build()

    class Builder {
        /**
         * Describes the reactive insight.
         */
        var description: kotlin.String? = null
        /**
         * The ID of a reactive insight.
         */
        var id: kotlin.String? = null
        /**
         * A time ranged that specifies when the observed behavior in an insight started and ended.
         */
        var insightTimeRange: aws.sdk.kotlin.services.devopsguru.model.InsightTimeRange? = null
        /**
         * The name of a reactive insight.
         */
        var name: kotlin.String? = null
        /**
         * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         */
        var resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = null
        /**
         * The severity of the insight. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities) in the *Amazon DevOps Guru User Guide*.
         */
        var severity: aws.sdk.kotlin.services.devopsguru.model.InsightSeverity? = null
        /**
         * The ID of the Amazon Web Services System Manager OpsItem created for this insight. You must enable the creation of OpstItems insights before they are created for each insight.
         */
        var ssmOpsItemId: kotlin.String? = null
        /**
         * The status of a reactive insight.
         */
        var status: aws.sdk.kotlin.services.devopsguru.model.InsightStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.ReactiveInsight) : this() {
            this.description = x.description
            this.id = x.id
            this.insightTimeRange = x.insightTimeRange
            this.name = x.name
            this.resourceCollection = x.resourceCollection
            this.severity = x.severity
            this.ssmOpsItemId = x.ssmOpsItemId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.ReactiveInsight = ReactiveInsight(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.InsightTimeRange] inside the given [block]
         */
        fun insightTimeRange(block: aws.sdk.kotlin.services.devopsguru.model.InsightTimeRange.Builder.() -> kotlin.Unit) {
            this.insightTimeRange = aws.sdk.kotlin.services.devopsguru.model.InsightTimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.ResourceCollection] inside the given [block]
         */
        fun resourceCollection(block: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.Builder.() -> kotlin.Unit) {
            this.resourceCollection = aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.invoke(block)
        }
    }
}
