// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Information about an anomaly that is related to a recommendation.
 */
class RecommendationRelatedAnomaly private constructor(builder: Builder) {
    /**
     * The ID of an anomaly that generated the insight with this recommendation.
     */
    val anomalyId: kotlin.String? = builder.anomalyId
    /**
     * An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each object contains the name and type of the resource.
     */
    val resources: List<RecommendationRelatedAnomalyResource>? = builder.resources
    /**
     * Information about where the anomalous behavior related the recommendation was found. For example, details in Amazon CloudWatch metrics.
     */
    val sourceDetails: List<RecommendationRelatedAnomalySourceDetail>? = builder.sourceDetails

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.RecommendationRelatedAnomaly = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationRelatedAnomaly(")
        append("anomalyId=$anomalyId,")
        append("resources=$resources,")
        append("sourceDetails=$sourceDetails)")
    }

    override fun hashCode(): kotlin.Int {
        var result = anomalyId?.hashCode() ?: 0
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (sourceDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendationRelatedAnomaly

        if (anomalyId != other.anomalyId) return false
        if (resources != other.resources) return false
        if (sourceDetails != other.sourceDetails) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.RecommendationRelatedAnomaly = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of an anomaly that generated the insight with this recommendation.
         */
        var anomalyId: kotlin.String? = null
        /**
         * An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each object contains the name and type of the resource.
         */
        var resources: List<RecommendationRelatedAnomalyResource>? = null
        /**
         * Information about where the anomalous behavior related the recommendation was found. For example, details in Amazon CloudWatch metrics.
         */
        var sourceDetails: List<RecommendationRelatedAnomalySourceDetail>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.RecommendationRelatedAnomaly) : this() {
            this.anomalyId = x.anomalyId
            this.resources = x.resources
            this.sourceDetails = x.sourceDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.RecommendationRelatedAnomaly = RecommendationRelatedAnomaly(this)
    }
}
