// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Information about a filter used to specify which Amazon Web Services resources are analyzed for anomalous behavior by DevOps Guru.
 */
class ResourceCollectionFilter private constructor(builder: Builder) {
    /**
     * Information about Amazon Web Services CloudFormation stacks. You can use up to 500 stacks to specify which Amazon Web Services resources in your account to analyze. For more information, see [Stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in the *Amazon Web Services CloudFormation User Guide*.
     */
    val cloudFormation: aws.sdk.kotlin.services.devopsguru.model.CloudFormationCollectionFilter? = builder.cloudFormation
    /**
     * The Amazon Web Services tags used to filter the resources in the resource collection.
     *
     * Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the [Tagging best practices](https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf) whitepaper.
     *
     * Each Amazon Web Services tag has two parts.
     * + A tag *key* (for example, `CostCenter`, `Environment`, `Project`, or `Secret`). Tag *keys* are case-sensitive.
     * + An optional field known as a tag *value* (for example, `111122223333`, `Production`, or a team name). Omitting the tag *value* is the same as using an empty string. Like tag *keys*, tag *values* are case-sensitive.
     *
     * Together these are known as *key*-*value* pairs.
     *
     * The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-`. The tag *key* might be `Devops-guru-deployment-application` or `Devops-guru-rds-application`. While *keys* are case-sensitive, the case of *key* characters don't matter to DevOps Guru. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS`. Possible *key*&#47;*value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers`.
     */
    val tags: List<TagCollectionFilter>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.ResourceCollectionFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceCollectionFilter(")
        append("cloudFormation=$cloudFormation,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudFormation?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceCollectionFilter

        if (cloudFormation != other.cloudFormation) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.ResourceCollectionFilter = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information about Amazon Web Services CloudFormation stacks. You can use up to 500 stacks to specify which Amazon Web Services resources in your account to analyze. For more information, see [Stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in the *Amazon Web Services CloudFormation User Guide*.
         */
        var cloudFormation: aws.sdk.kotlin.services.devopsguru.model.CloudFormationCollectionFilter? = null
        /**
         * The Amazon Web Services tags used to filter the resources in the resource collection.
         *
         * Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the [Tagging best practices](https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf) whitepaper.
         *
         * Each Amazon Web Services tag has two parts.
         * + A tag *key* (for example, `CostCenter`, `Environment`, `Project`, or `Secret`). Tag *keys* are case-sensitive.
         * + An optional field known as a tag *value* (for example, `111122223333`, `Production`, or a team name). Omitting the tag *value* is the same as using an empty string. Like tag *keys*, tag *values* are case-sensitive.
         *
         * Together these are known as *key*-*value* pairs.
         *
         * The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-`. The tag *key* might be `Devops-guru-deployment-application` or `Devops-guru-rds-application`. While *keys* are case-sensitive, the case of *key* characters don't matter to DevOps Guru. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS`. Possible *key*&#47;*value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers`.
         */
        var tags: List<TagCollectionFilter>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.ResourceCollectionFilter) : this() {
            this.cloudFormation = x.cloudFormation
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.ResourceCollectionFilter = ResourceCollectionFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.CloudFormationCollectionFilter] inside the given [block]
         */
        fun cloudFormation(block: aws.sdk.kotlin.services.devopsguru.model.CloudFormationCollectionFilter.Builder.() -> kotlin.Unit) {
            this.cloudFormation = aws.sdk.kotlin.services.devopsguru.model.CloudFormationCollectionFilter.invoke(block)
        }
    }
}
