// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Specifies one or more severity values and one or more status values that are used to search for insights.
 */
class SearchInsightsFilters private constructor(builder: Builder) {
    /**
     * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    val resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = builder.resourceCollection
    /**
     * A collection of the names of Amazon Web Services services.
     */
    val serviceCollection: aws.sdk.kotlin.services.devopsguru.model.ServiceCollection? = builder.serviceCollection
    /**
     * An array of severity values used to search for insights.
     */
    val severities: List<InsightSeverity>? = builder.severities
    /**
     * An array of status values used to search for insights.
     */
    val statuses: List<InsightStatus>? = builder.statuses

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.SearchInsightsFilters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchInsightsFilters(")
        append("resourceCollection=$resourceCollection,")
        append("serviceCollection=$serviceCollection,")
        append("severities=$severities,")
        append("statuses=$statuses)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceCollection?.hashCode() ?: 0
        result = 31 * result + (serviceCollection?.hashCode() ?: 0)
        result = 31 * result + (severities?.hashCode() ?: 0)
        result = 31 * result + (statuses?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchInsightsFilters

        if (resourceCollection != other.resourceCollection) return false
        if (serviceCollection != other.serviceCollection) return false
        if (severities != other.severities) return false
        if (statuses != other.statuses) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.SearchInsightsFilters = Builder(this).apply(block).build()

    class Builder {
        /**
         * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         */
        var resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = null
        /**
         * A collection of the names of Amazon Web Services services.
         */
        var serviceCollection: aws.sdk.kotlin.services.devopsguru.model.ServiceCollection? = null
        /**
         * An array of severity values used to search for insights.
         */
        var severities: List<InsightSeverity>? = null
        /**
         * An array of status values used to search for insights.
         */
        var statuses: List<InsightStatus>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.SearchInsightsFilters) : this() {
            this.resourceCollection = x.resourceCollection
            this.serviceCollection = x.serviceCollection
            this.severities = x.severities
            this.statuses = x.statuses
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.SearchInsightsFilters = SearchInsightsFilters(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.ResourceCollection] inside the given [block]
         */
        fun resourceCollection(block: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.Builder.() -> kotlin.Unit) {
            this.resourceCollection = aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.ServiceCollection] inside the given [block]
         */
        fun serviceCollection(block: aws.sdk.kotlin.services.devopsguru.model.ServiceCollection.Builder.() -> kotlin.Unit) {
            this.serviceCollection = aws.sdk.kotlin.services.devopsguru.model.ServiceCollection.invoke(block)
        }
    }
}
