// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Contains the Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
 *
 * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see [Permissions for cross account Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
 *
 * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see Permissions for cross account Amazon SNS topics.
 *
 * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see [Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
 */
class SnsChannelConfig private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
     */
    val topicArn: kotlin.String? = builder.topicArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.SnsChannelConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnsChannelConfig(")
        append("topicArn=$topicArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = topicArn?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnsChannelConfig

        if (topicArn != other.topicArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.SnsChannelConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
         */
        var topicArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.SnsChannelConfig) : this() {
            this.topicArn = x.topicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.SnsChannelConfig = SnsChannelConfig(this)
    }
}
