// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * A collection of Amazon Web Services tags used to filter insights. This is used to return insights generated from only resources that contain the tags in the tag collection.
 */
class TagCollectionFilter private constructor(builder: Builder) {
    /**
     * An Amazon Web Services tag *key* that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this *key* make up your DevOps Guru application and analysis boundary.
     *
     * The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-`. The tag *key* might be `Devops-guru-deployment-application` or `Devops-guru-rds-application`. While *keys* are case-sensitive, the case of *key* characters don't matter to DevOps Guru. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS`. Possible *key*&#47;*value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers`.
     */
    val appBoundaryKey: kotlin.String? = builder.appBoundaryKey
    /**
     * The values in an Amazon Web Services tag collection.
     *
     * The tag's *value* is an optional field used to associate a string with the tag *key* (for example, `111122223333`, `Production`, or a team name). The *key* and *value* are the tag's *key* pair. Omitting the tag *value* is the same as using an empty string. Like tag *keys*, tag *values* are case-sensitive. You can specify a maximum of 256 characters for a tag value.
     */
    val tagValues: List<String>? = builder.tagValues

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.TagCollectionFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TagCollectionFilter(")
        append("appBoundaryKey=$appBoundaryKey,")
        append("tagValues=$tagValues)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appBoundaryKey?.hashCode() ?: 0
        result = 31 * result + (tagValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TagCollectionFilter

        if (appBoundaryKey != other.appBoundaryKey) return false
        if (tagValues != other.tagValues) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.TagCollectionFilter = Builder(this).apply(block).build()

    class Builder {
        /**
         * An Amazon Web Services tag *key* that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this *key* make up your DevOps Guru application and analysis boundary.
         *
         * The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-`. The tag *key* might be `Devops-guru-deployment-application` or `Devops-guru-rds-application`. While *keys* are case-sensitive, the case of *key* characters don't matter to DevOps Guru. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS`. Possible *key*&#47;*value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers`.
         */
        var appBoundaryKey: kotlin.String? = null
        /**
         * The values in an Amazon Web Services tag collection.
         *
         * The tag's *value* is an optional field used to associate a string with the tag *key* (for example, `111122223333`, `Production`, or a team name). The *key* and *value* are the tag's *key* pair. Omitting the tag *value* is the same as using an empty string. Like tag *keys*, tag *values* are case-sensitive. You can specify a maximum of 256 characters for a tag value.
         */
        var tagValues: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.TagCollectionFilter) : this() {
            this.appBoundaryKey = x.appBoundaryKey
            this.tagValues = x.tagValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.TagCollectionFilter = TagCollectionFilter(this)
    }
}
