// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Information about the health of Amazon Web Services resources in your account that are specified by an Amazon Web Services tag *key*.
 */
class TagHealth private constructor(builder: Builder) {
    /**
     * An Amazon Web Services tag *key* that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this *key* make up your DevOps Guru application and analysis boundary.
     *
     * The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-`. The tag *key* might be `Devops-guru-deployment-application` or `Devops-guru-rds-application`. While *keys* are case-sensitive, the case of *key* characters don't matter to DevOps Guru. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS`. Possible *key*&#47;*value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers`.
     */
    val appBoundaryKey: kotlin.String? = builder.appBoundaryKey
    /**
     * Information about the health of the Amazon Web Services resources in your account that are specified by an Amazon Web Services tag, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights.
     */
    val insight: aws.sdk.kotlin.services.devopsguru.model.InsightHealth? = builder.insight
    /**
     * The value in an Amazon Web Services tag.
     *
     * The tag's *value* is an optional field used to associate a string with the tag *key* (for example, `111122223333`, `Production`, or a team name). The *key* and *value* are the tag's *key* pair. Omitting the tag *value* is the same as using an empty string. Like tag *keys*, tag *values* are case-sensitive. You can specify a maximum of 256 characters for a tag value.
     */
    val tagValue: kotlin.String? = builder.tagValue

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.TagHealth = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TagHealth(")
        append("appBoundaryKey=$appBoundaryKey,")
        append("insight=$insight,")
        append("tagValue=$tagValue)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appBoundaryKey?.hashCode() ?: 0
        result = 31 * result + (insight?.hashCode() ?: 0)
        result = 31 * result + (tagValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TagHealth

        if (appBoundaryKey != other.appBoundaryKey) return false
        if (insight != other.insight) return false
        if (tagValue != other.tagValue) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.TagHealth = Builder(this).apply(block).build()

    class Builder {
        /**
         * An Amazon Web Services tag *key* that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this *key* make up your DevOps Guru application and analysis boundary.
         *
         * The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-`. The tag *key* might be `Devops-guru-deployment-application` or `Devops-guru-rds-application`. While *keys* are case-sensitive, the case of *key* characters don't matter to DevOps Guru. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS`. Possible *key*&#47;*value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers`.
         */
        var appBoundaryKey: kotlin.String? = null
        /**
         * Information about the health of the Amazon Web Services resources in your account that are specified by an Amazon Web Services tag, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights.
         */
        var insight: aws.sdk.kotlin.services.devopsguru.model.InsightHealth? = null
        /**
         * The value in an Amazon Web Services tag.
         *
         * The tag's *value* is an optional field used to associate a string with the tag *key* (for example, `111122223333`, `Production`, or a team name). The *key* and *value* are the tag's *key* pair. Omitting the tag *value* is the same as using an empty string. Like tag *keys*, tag *values* are case-sensitive. You can specify a maximum of 256 characters for a tag value.
         */
        var tagValue: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.TagHealth) : this() {
            this.appBoundaryKey = x.appBoundaryKey
            this.insight = x.insight
            this.tagValue = x.tagValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.TagHealth = TagHealth(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.InsightHealth] inside the given [block]
         */
        fun insight(block: aws.sdk.kotlin.services.devopsguru.model.InsightHealth.Builder.() -> kotlin.Unit) {
            this.insight = aws.sdk.kotlin.services.devopsguru.model.InsightHealth.invoke(block)
        }
    }
}
