// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.paginators

import aws.sdk.kotlin.services.devopsguru.DevOpsGuruClient
import aws.sdk.kotlin.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest
import aws.sdk.kotlin.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse
import aws.sdk.kotlin.services.devopsguru.model.DescribeResourceCollectionHealthRequest
import aws.sdk.kotlin.services.devopsguru.model.DescribeResourceCollectionHealthResponse
import aws.sdk.kotlin.services.devopsguru.model.Event
import aws.sdk.kotlin.services.devopsguru.model.GetCostEstimationRequest
import aws.sdk.kotlin.services.devopsguru.model.GetCostEstimationResponse
import aws.sdk.kotlin.services.devopsguru.model.GetResourceCollectionRequest
import aws.sdk.kotlin.services.devopsguru.model.GetResourceCollectionResponse
import aws.sdk.kotlin.services.devopsguru.model.ListAnomaliesForInsightRequest
import aws.sdk.kotlin.services.devopsguru.model.ListAnomaliesForInsightResponse
import aws.sdk.kotlin.services.devopsguru.model.ListEventsRequest
import aws.sdk.kotlin.services.devopsguru.model.ListEventsResponse
import aws.sdk.kotlin.services.devopsguru.model.ListInsightsRequest
import aws.sdk.kotlin.services.devopsguru.model.ListInsightsResponse
import aws.sdk.kotlin.services.devopsguru.model.ListNotificationChannelsRequest
import aws.sdk.kotlin.services.devopsguru.model.ListNotificationChannelsResponse
import aws.sdk.kotlin.services.devopsguru.model.ListOrganizationInsightsRequest
import aws.sdk.kotlin.services.devopsguru.model.ListOrganizationInsightsResponse
import aws.sdk.kotlin.services.devopsguru.model.ListRecommendationsRequest
import aws.sdk.kotlin.services.devopsguru.model.ListRecommendationsResponse
import aws.sdk.kotlin.services.devopsguru.model.NotificationChannel
import aws.sdk.kotlin.services.devopsguru.model.Recommendation
import aws.sdk.kotlin.services.devopsguru.model.SearchInsightsRequest
import aws.sdk.kotlin.services.devopsguru.model.SearchInsightsResponse
import aws.sdk.kotlin.services.devopsguru.model.SearchOrganizationInsightsRequest
import aws.sdk.kotlin.services.devopsguru.model.SearchOrganizationInsightsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeOrganizationResourceCollectionHealthResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeOrganizationResourceCollectionHealthRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOrganizationResourceCollectionHealthResponse]
 */
fun DevOpsGuruClient.describeOrganizationResourceCollectionHealthPaginated(initialRequest: DescribeOrganizationResourceCollectionHealthRequest): Flow<DescribeOrganizationResourceCollectionHealthResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeOrganizationResourceCollectionHealthPaginated.describeOrganizationResourceCollectionHealth(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeOrganizationResourceCollectionHealthResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOrganizationResourceCollectionHealthResponse]
 */
fun DevOpsGuruClient.describeOrganizationResourceCollectionHealthPaginated(block: DescribeOrganizationResourceCollectionHealthRequest.Builder.() -> Unit): Flow<DescribeOrganizationResourceCollectionHealthResponse> =
    describeOrganizationResourceCollectionHealthPaginated(DescribeOrganizationResourceCollectionHealthRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeResourceCollectionHealthResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeResourceCollectionHealthRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeResourceCollectionHealthResponse]
 */
fun DevOpsGuruClient.describeResourceCollectionHealthPaginated(initialRequest: DescribeResourceCollectionHealthRequest): Flow<DescribeResourceCollectionHealthResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeResourceCollectionHealthPaginated.describeResourceCollectionHealth(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeResourceCollectionHealthResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeResourceCollectionHealthResponse]
 */
fun DevOpsGuruClient.describeResourceCollectionHealthPaginated(block: DescribeResourceCollectionHealthRequest.Builder.() -> Unit): Flow<DescribeResourceCollectionHealthResponse> =
    describeResourceCollectionHealthPaginated(DescribeResourceCollectionHealthRequest.Builder().apply(block).build())

/**
 * Paginate over [GetCostEstimationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetCostEstimationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCostEstimationResponse]
 */
fun DevOpsGuruClient.getCostEstimationPaginated(initialRequest: GetCostEstimationRequest): Flow<GetCostEstimationResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getCostEstimationPaginated.getCostEstimation(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetCostEstimationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCostEstimationResponse]
 */
fun DevOpsGuruClient.getCostEstimationPaginated(block: GetCostEstimationRequest.Builder.() -> Unit): Flow<GetCostEstimationResponse> =
    getCostEstimationPaginated(GetCostEstimationRequest.Builder().apply(block).build())

/**
 * Paginate over [GetResourceCollectionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetResourceCollectionRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetResourceCollectionResponse]
 */
fun DevOpsGuruClient.getResourceCollectionPaginated(initialRequest: GetResourceCollectionRequest): Flow<GetResourceCollectionResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getResourceCollectionPaginated.getResourceCollection(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetResourceCollectionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetResourceCollectionResponse]
 */
fun DevOpsGuruClient.getResourceCollectionPaginated(block: GetResourceCollectionRequest.Builder.() -> Unit): Flow<GetResourceCollectionResponse> =
    getResourceCollectionPaginated(GetResourceCollectionRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAnomaliesForInsightResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAnomaliesForInsightRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnomaliesForInsightResponse]
 */
fun DevOpsGuruClient.listAnomaliesForInsightPaginated(initialRequest: ListAnomaliesForInsightRequest): Flow<ListAnomaliesForInsightResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAnomaliesForInsightPaginated.listAnomaliesForInsight(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAnomaliesForInsightResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnomaliesForInsightResponse]
 */
fun DevOpsGuruClient.listAnomaliesForInsightPaginated(block: ListAnomaliesForInsightRequest.Builder.() -> Unit): Flow<ListAnomaliesForInsightResponse> =
    listAnomaliesForInsightPaginated(ListAnomaliesForInsightRequest.Builder().apply(block).build())

/**
 * Paginate over [ListEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventsResponse]
 */
fun DevOpsGuruClient.listEventsPaginated(initialRequest: ListEventsRequest): Flow<ListEventsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEventsPaginated.listEvents(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventsResponse]
 */
fun DevOpsGuruClient.listEventsPaginated(block: ListEventsRequest.Builder.() -> Unit): Flow<ListEventsResponse> =
    listEventsPaginated(ListEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEventsPaginated]
 * to access the nested member [Event]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Event]
 */
@JvmName("listEventsResponseEvent")
fun Flow<ListEventsResponse>.events(): Flow<Event> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInsightsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInsightsResponse]
 */
fun DevOpsGuruClient.listInsightsPaginated(initialRequest: ListInsightsRequest): Flow<ListInsightsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInsightsPaginated.listInsights(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInsightsResponse]
 */
fun DevOpsGuruClient.listInsightsPaginated(block: ListInsightsRequest.Builder.() -> Unit): Flow<ListInsightsResponse> =
    listInsightsPaginated(ListInsightsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListNotificationChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNotificationChannelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNotificationChannelsResponse]
 */
fun DevOpsGuruClient.listNotificationChannelsPaginated(initialRequest: ListNotificationChannelsRequest): Flow<ListNotificationChannelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNotificationChannelsPaginated.listNotificationChannels(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListNotificationChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNotificationChannelsResponse]
 */
fun DevOpsGuruClient.listNotificationChannelsPaginated(block: ListNotificationChannelsRequest.Builder.() -> Unit): Flow<ListNotificationChannelsResponse> =
    listNotificationChannelsPaginated(ListNotificationChannelsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listNotificationChannelsPaginated]
 * to access the nested member [NotificationChannel]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NotificationChannel]
 */
@JvmName("listNotificationChannelsResponseNotificationChannel")
fun Flow<ListNotificationChannelsResponse>.channels(): Flow<NotificationChannel> =
    transform() { response ->
        response.channels?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListOrganizationInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOrganizationInsightsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrganizationInsightsResponse]
 */
fun DevOpsGuruClient.listOrganizationInsightsPaginated(initialRequest: ListOrganizationInsightsRequest): Flow<ListOrganizationInsightsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOrganizationInsightsPaginated.listOrganizationInsights(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListOrganizationInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrganizationInsightsResponse]
 */
fun DevOpsGuruClient.listOrganizationInsightsPaginated(block: ListOrganizationInsightsRequest.Builder.() -> Unit): Flow<ListOrganizationInsightsResponse> =
    listOrganizationInsightsPaginated(ListOrganizationInsightsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRecommendationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRecommendationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecommendationsResponse]
 */
fun DevOpsGuruClient.listRecommendationsPaginated(initialRequest: ListRecommendationsRequest): Flow<ListRecommendationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRecommendationsPaginated.listRecommendations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRecommendationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecommendationsResponse]
 */
fun DevOpsGuruClient.listRecommendationsPaginated(block: ListRecommendationsRequest.Builder.() -> Unit): Flow<ListRecommendationsResponse> =
    listRecommendationsPaginated(ListRecommendationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRecommendationsPaginated]
 * to access the nested member [Recommendation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Recommendation]
 */
@JvmName("listRecommendationsResponseRecommendation")
fun Flow<ListRecommendationsResponse>.recommendations(): Flow<Recommendation> =
    transform() { response ->
        response.recommendations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchInsightsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchInsightsResponse]
 */
fun DevOpsGuruClient.searchInsightsPaginated(initialRequest: SearchInsightsRequest): Flow<SearchInsightsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchInsightsPaginated.searchInsights(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchInsightsResponse]
 */
fun DevOpsGuruClient.searchInsightsPaginated(block: SearchInsightsRequest.Builder.() -> Unit): Flow<SearchInsightsResponse> =
    searchInsightsPaginated(SearchInsightsRequest.Builder().apply(block).build())

/**
 * Paginate over [SearchOrganizationInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchOrganizationInsightsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchOrganizationInsightsResponse]
 */
fun DevOpsGuruClient.searchOrganizationInsightsPaginated(initialRequest: SearchOrganizationInsightsRequest): Flow<SearchOrganizationInsightsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchOrganizationInsightsPaginated.searchOrganizationInsights(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchOrganizationInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchOrganizationInsightsResponse]
 */
fun DevOpsGuruClient.searchOrganizationInsightsPaginated(block: SearchOrganizationInsightsRequest.Builder.() -> Unit): Flow<SearchOrganizationInsightsResponse> =
    searchOrganizationInsightsPaginated(SearchOrganizationInsightsRequest.Builder().apply(block).build())
