// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.devopsguru.model.DescribeInsightResponse
import aws.sdk.kotlin.services.devopsguru.model.DevOpsGuruException
import aws.sdk.kotlin.services.devopsguru.model.ProactiveInsight
import aws.sdk.kotlin.services.devopsguru.model.ReactiveInsight
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeInsightOperationDeserializer: HttpDeserialize<DescribeInsightResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeInsightResponse {
        if (!response.status.isSuccess()) {
            throwDescribeInsightError(context, response)
        }
        val builder = DescribeInsightResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeInsightOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeInsightError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DevOpsGuruException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DevOpsGuruException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeInsightOperationBody(builder: DescribeInsightResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROACTIVEINSIGHT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProactiveInsight"))
    val REACTIVEINSIGHT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ReactiveInsight"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROACTIVEINSIGHT_DESCRIPTOR)
        field(REACTIVEINSIGHT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROACTIVEINSIGHT_DESCRIPTOR.index -> builder.proactiveInsight = deserializeProactiveInsightDocument(deserializer)
                REACTIVEINSIGHT_DESCRIPTOR.index -> builder.reactiveInsight = deserializeReactiveInsightDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
