// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.devopsguru.model.DescribeOrganizationHealthResponse
import aws.sdk.kotlin.services.devopsguru.model.DevOpsGuruException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeOrganizationHealthOperationDeserializer: HttpDeserialize<DescribeOrganizationHealthResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeOrganizationHealthResponse {
        if (!response.status.isSuccess()) {
            throwDescribeOrganizationHealthError(context, response)
        }
        val builder = DescribeOrganizationHealthResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeOrganizationHealthOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeOrganizationHealthError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DevOpsGuruException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DevOpsGuruException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeOrganizationHealthOperationBody(builder: DescribeOrganizationHealthResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val METRICSANALYZED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MetricsAnalyzed"))
    val OPENPROACTIVEINSIGHTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("OpenProactiveInsights"))
    val OPENREACTIVEINSIGHTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("OpenReactiveInsights"))
    val RESOURCEHOURS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("ResourceHours"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(METRICSANALYZED_DESCRIPTOR)
        field(OPENPROACTIVEINSIGHTS_DESCRIPTOR)
        field(OPENREACTIVEINSIGHTS_DESCRIPTOR)
        field(RESOURCEHOURS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                METRICSANALYZED_DESCRIPTOR.index -> builder.metricsAnalyzed = deserializeInt()
                OPENPROACTIVEINSIGHTS_DESCRIPTOR.index -> builder.openProactiveInsights = deserializeInt()
                OPENREACTIVEINSIGHTS_DESCRIPTOR.index -> builder.openReactiveInsights = deserializeInt()
                RESOURCEHOURS_DESCRIPTOR.index -> builder.resourceHours = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
