// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.devopsguru.model.DevOpsGuruException
import aws.sdk.kotlin.services.devopsguru.model.ListOrganizationInsightsResponse
import aws.sdk.kotlin.services.devopsguru.model.ProactiveOrganizationInsightSummary
import aws.sdk.kotlin.services.devopsguru.model.ReactiveOrganizationInsightSummary
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListOrganizationInsightsOperationDeserializer: HttpDeserialize<ListOrganizationInsightsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListOrganizationInsightsResponse {
        if (!response.status.isSuccess()) {
            throwListOrganizationInsightsError(context, response)
        }
        val builder = ListOrganizationInsightsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListOrganizationInsightsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListOrganizationInsightsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DevOpsGuruException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DevOpsGuruException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListOrganizationInsightsOperationBody(builder: ListOrganizationInsightsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val PROACTIVEINSIGHTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProactiveInsights"))
    val REACTIVEINSIGHTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ReactiveInsights"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(PROACTIVEINSIGHTS_DESCRIPTOR)
        field(REACTIVEINSIGHTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                PROACTIVEINSIGHTS_DESCRIPTOR.index -> builder.proactiveInsights =
                    deserializer.deserializeList(PROACTIVEINSIGHTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProactiveOrganizationInsightSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProactiveOrganizationInsightSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REACTIVEINSIGHTS_DESCRIPTOR.index -> builder.reactiveInsights =
                    deserializer.deserializeList(REACTIVEINSIGHTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ReactiveOrganizationInsightSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeReactiveOrganizationInsightSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
