// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an anomalous log event found within a log group.
 */
public class LogAnomalyClass private constructor(builder: Builder) {
    /**
     * The explanation for why the log event is considered an anomaly.
     */
    public val explanation: kotlin.String? = builder.explanation
    /**
     * The token where the anomaly was detected. This may refer to an exception or another location, or it may be blank for log anomalies such as format anomalies.
     */
    public val logAnomalyToken: kotlin.String? = builder.logAnomalyToken
    /**
     * The type of log anomaly that has been detected.
     */
    public val logAnomalyType: aws.sdk.kotlin.services.devopsguru.model.LogAnomalyType? = builder.logAnomalyType
    /**
     * The ID of the log event.
     */
    public val logEventId: kotlin.String? = builder.logEventId
    /**
     * The time of the first occurrence of the anomalous log event.
     */
    public val logEventTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.logEventTimestamp
    /**
     * The name of the Amazon CloudWatch log stream that the anomalous log event belongs to. A log stream is a sequence of log events that share the same source.
     */
    public val logStreamName: kotlin.String? = builder.logStreamName
    /**
     * The number of log lines where this anomalous log event occurs.
     */
    public val numberOfLogLinesOccurrences: kotlin.Int = builder.numberOfLogLinesOccurrences

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.LogAnomalyClass = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LogAnomalyClass(")
        append("explanation=$explanation,")
        append("logAnomalyToken=$logAnomalyToken,")
        append("logAnomalyType=$logAnomalyType,")
        append("logEventId=$logEventId,")
        append("logEventTimestamp=$logEventTimestamp,")
        append("logStreamName=$logStreamName,")
        append("numberOfLogLinesOccurrences=$numberOfLogLinesOccurrences)")
    }

    override fun hashCode(): kotlin.Int {
        var result = explanation?.hashCode() ?: 0
        result = 31 * result + (logAnomalyToken?.hashCode() ?: 0)
        result = 31 * result + (logAnomalyType?.hashCode() ?: 0)
        result = 31 * result + (logEventId?.hashCode() ?: 0)
        result = 31 * result + (logEventTimestamp?.hashCode() ?: 0)
        result = 31 * result + (logStreamName?.hashCode() ?: 0)
        result = 31 * result + (numberOfLogLinesOccurrences)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LogAnomalyClass

        if (explanation != other.explanation) return false
        if (logAnomalyToken != other.logAnomalyToken) return false
        if (logAnomalyType != other.logAnomalyType) return false
        if (logEventId != other.logEventId) return false
        if (logEventTimestamp != other.logEventTimestamp) return false
        if (logStreamName != other.logStreamName) return false
        if (numberOfLogLinesOccurrences != other.numberOfLogLinesOccurrences) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.LogAnomalyClass = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The explanation for why the log event is considered an anomaly.
         */
        public var explanation: kotlin.String? = null
        /**
         * The token where the anomaly was detected. This may refer to an exception or another location, or it may be blank for log anomalies such as format anomalies.
         */
        public var logAnomalyToken: kotlin.String? = null
        /**
         * The type of log anomaly that has been detected.
         */
        public var logAnomalyType: aws.sdk.kotlin.services.devopsguru.model.LogAnomalyType? = null
        /**
         * The ID of the log event.
         */
        public var logEventId: kotlin.String? = null
        /**
         * The time of the first occurrence of the anomalous log event.
         */
        public var logEventTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the Amazon CloudWatch log stream that the anomalous log event belongs to. A log stream is a sequence of log events that share the same source.
         */
        public var logStreamName: kotlin.String? = null
        /**
         * The number of log lines where this anomalous log event occurs.
         */
        public var numberOfLogLinesOccurrences: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.LogAnomalyClass) : this() {
            this.explanation = x.explanation
            this.logAnomalyToken = x.logAnomalyToken
            this.logAnomalyType = x.logAnomalyType
            this.logEventId = x.logEventId
            this.logEventTimestamp = x.logEventTimestamp
            this.logStreamName = x.logStreamName
            this.numberOfLogLinesOccurrences = x.numberOfLogLinesOccurrences
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.LogAnomalyClass = LogAnomalyClass(this)
    }
}
