// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the resource that is being monitored, including the name of the resource, the type of resource, and whether or not permission is given to DevOps Guru to access that resource.
 */
public class MonitoredResourceIdentifier private constructor(builder: Builder) {
    /**
     * The time at which DevOps Guru last updated this resource.
     */
    public val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * The name of the resource being monitored.
     */
    public val monitoredResourceName: kotlin.String? = builder.monitoredResourceName
    /**
     * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    public val resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = builder.resourceCollection
    /**
     * The permission status of a resource.
     */
    public val resourcePermission: aws.sdk.kotlin.services.devopsguru.model.ResourcePermission? = builder.resourcePermission
    /**
     * The type of resource being monitored.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.MonitoredResourceIdentifier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MonitoredResourceIdentifier(")
        append("lastUpdated=$lastUpdated,")
        append("monitoredResourceName=$monitoredResourceName,")
        append("resourceCollection=$resourceCollection,")
        append("resourcePermission=$resourcePermission,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastUpdated?.hashCode() ?: 0
        result = 31 * result + (monitoredResourceName?.hashCode() ?: 0)
        result = 31 * result + (resourceCollection?.hashCode() ?: 0)
        result = 31 * result + (resourcePermission?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MonitoredResourceIdentifier

        if (lastUpdated != other.lastUpdated) return false
        if (monitoredResourceName != other.monitoredResourceName) return false
        if (resourceCollection != other.resourceCollection) return false
        if (resourcePermission != other.resourcePermission) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.MonitoredResourceIdentifier = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time at which DevOps Guru last updated this resource.
         */
        public var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the resource being monitored.
         */
        public var monitoredResourceName: kotlin.String? = null
        /**
         * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         */
        public var resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = null
        /**
         * The permission status of a resource.
         */
        public var resourcePermission: aws.sdk.kotlin.services.devopsguru.model.ResourcePermission? = null
        /**
         * The type of resource being monitored.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.MonitoredResourceIdentifier) : this() {
            this.lastUpdated = x.lastUpdated
            this.monitoredResourceName = x.monitoredResourceName
            this.resourceCollection = x.resourceCollection
            this.resourcePermission = x.resourcePermission
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.MonitoredResourceIdentifier = MonitoredResourceIdentifier(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.ResourceCollection] inside the given [block]
         */
        public fun resourceCollection(block: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.Builder.() -> kotlin.Unit) {
            this.resourceCollection = aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.invoke(block)
        }
    }
}
