// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Information about notification channels you have configured with DevOps Guru. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS).
 */
public class NotificationChannelConfig private constructor(builder: Builder) {
    /**
     * The filter configurations for the Amazon SNS notification topic you use with DevOps Guru. If you do not provide filter configurations, the default configurations are to receive notifications for all message types of `High` or `Medium` severity.
     */
    public val filters: aws.sdk.kotlin.services.devopsguru.model.NotificationFilterConfig? = builder.filters
    /**
     * Information about a notification channel configured in DevOps Guru to send notifications when insights are created.
     *
     * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see [Permissions for cross account Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
     *
     * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see Permissions for cross account Amazon SNS topics.
     *
     * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see [Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
     */
    public val sns: aws.sdk.kotlin.services.devopsguru.model.SnsChannelConfig? = builder.sns

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.NotificationChannelConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotificationChannelConfig(")
        append("filters=$filters,")
        append("sns=$sns)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (sns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotificationChannelConfig

        if (filters != other.filters) return false
        if (sns != other.sns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.NotificationChannelConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The filter configurations for the Amazon SNS notification topic you use with DevOps Guru. If you do not provide filter configurations, the default configurations are to receive notifications for all message types of `High` or `Medium` severity.
         */
        public var filters: aws.sdk.kotlin.services.devopsguru.model.NotificationFilterConfig? = null
        /**
         * Information about a notification channel configured in DevOps Guru to send notifications when insights are created.
         *
         * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see [Permissions for cross account Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
         *
         * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see Permissions for cross account Amazon SNS topics.
         *
         * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see [Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
         */
        public var sns: aws.sdk.kotlin.services.devopsguru.model.SnsChannelConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.NotificationChannelConfig) : this() {
            this.filters = x.filters
            this.sns = x.sns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.NotificationChannelConfig = NotificationChannelConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.NotificationFilterConfig] inside the given [block]
         */
        public fun filters(block: aws.sdk.kotlin.services.devopsguru.model.NotificationFilterConfig.Builder.() -> kotlin.Unit) {
            this.filters = aws.sdk.kotlin.services.devopsguru.model.NotificationFilterConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.SnsChannelConfig] inside the given [block]
         */
        public fun sns(block: aws.sdk.kotlin.services.devopsguru.model.SnsChannelConfig.Builder.() -> kotlin.Unit) {
            this.sns = aws.sdk.kotlin.services.devopsguru.model.SnsChannelConfig.invoke(block)
        }
    }
}
