// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * The filter configurations for the Amazon SNS notification topic you use with DevOps Guru. You can choose to specify which events or message types to receive notifications for. You can also choose to specify which severity levels to receive notifications for.
 */
public class NotificationFilterConfig private constructor(builder: Builder) {
    /**
     * The events that you want to receive notifications for. For example, you can choose to receive notifications only when the severity level is upgraded or a new insight is created.
     */
    public val messageTypes: List<NotificationMessageType>? = builder.messageTypes
    /**
     * The severity levels that you want to receive notifications for. For example, you can choose to receive notifications only for insights with `HIGH` and `MEDIUM` severity levels. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities).
     */
    public val severities: List<InsightSeverity>? = builder.severities

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.NotificationFilterConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotificationFilterConfig(")
        append("messageTypes=$messageTypes,")
        append("severities=$severities)")
    }

    override fun hashCode(): kotlin.Int {
        var result = messageTypes?.hashCode() ?: 0
        result = 31 * result + (severities?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotificationFilterConfig

        if (messageTypes != other.messageTypes) return false
        if (severities != other.severities) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.NotificationFilterConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The events that you want to receive notifications for. For example, you can choose to receive notifications only when the severity level is upgraded or a new insight is created.
         */
        public var messageTypes: List<NotificationMessageType>? = null
        /**
         * The severity levels that you want to receive notifications for. For example, you can choose to receive notifications only for insights with `HIGH` and `MEDIUM` severity levels. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities).
         */
        public var severities: List<InsightSeverity>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.NotificationFilterConfig) : this() {
            this.messageTypes = x.messageTypes
            this.severities = x.severities
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.NotificationFilterConfig = NotificationFilterConfig(this)
    }
}
