// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * A single query to be processed. Use these parameters to query the Performance Insights `GetResourceMetrics` API to retrieve the metrics for an anomaly. For more information, see ` <a href="https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_GetResourceMetrics.html">GetResourceMetrics</a> ` in the *Amazon RDS Performance Insights API Reference*.
 *
 * Amazon RDS Performance Insights enables you to monitor and explore different dimensions of database load based on data captured from a running DB instance. DB load is measured as average active sessions. Performance Insights provides the data to API consumers as a two-dimensional time-series dataset. The time dimension provides DB load data for each time point in the queried time range. Each time point decomposes overall load in relation to the requested dimensions, measured at that time point. Examples include SQL, Wait event, User, and Host.
 * + To learn more about Performance Insights and Amazon Aurora DB instances, go to the [ Amazon Aurora User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html).
 * + To learn more about Performance Insights and Amazon RDS DB instances, go to the [ Amazon RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html).
 */
public class PerformanceInsightsMetricQuery private constructor(builder: Builder) {
    /**
     * One or more filters to apply to a Performance Insights `GetResourceMetrics` API query. Restrictions:
     * + Any number of filters by the same dimension, as specified in the `GroupBy` parameter.
     * + A single filter for any other dimension in this dimension group.
     */
    public val filter: Map<String, String>? = builder.filter
    /**
     * The specification for how to aggregate the data points from a Performance Insights `GetResourceMetrics` API query. The Performance Insights query returns all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.
     */
    public val groupBy: aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup? = builder.groupBy
    /**
     * The name of the meteric used used when querying an Performance Insights `GetResourceMetrics` API for anomaly metrics.
     *
     * Valid values for `Metric` are:
     * + `db.load.avg` - a scaled representation of the number of active sessions for the database engine.
     * + `db.sampledload.avg` - the raw number of active sessions for the database engine.
     *
     * If the number of active sessions is less than an internal Performance Insights threshold, `db.load.avg` and `db.sampledload.avg` are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with `db.load.avg` showing the scaled values, `db.sampledload.avg` showing the raw values, and `db.sampledload.avg` less than `db.load.avg`. For most use cases, you can query `db.load.avg` only.
     */
    public val metric: kotlin.String? = builder.metric

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricQuery = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PerformanceInsightsMetricQuery(")
        append("filter=$filter,")
        append("groupBy=$groupBy,")
        append("metric=$metric)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (groupBy?.hashCode() ?: 0)
        result = 31 * result + (metric?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PerformanceInsightsMetricQuery

        if (filter != other.filter) return false
        if (groupBy != other.groupBy) return false
        if (metric != other.metric) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricQuery = Builder(this).apply(block).build()

    public class Builder {
        /**
         * One or more filters to apply to a Performance Insights `GetResourceMetrics` API query. Restrictions:
         * + Any number of filters by the same dimension, as specified in the `GroupBy` parameter.
         * + A single filter for any other dimension in this dimension group.
         */
        public var filter: Map<String, String>? = null
        /**
         * The specification for how to aggregate the data points from a Performance Insights `GetResourceMetrics` API query. The Performance Insights query returns all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.
         */
        public var groupBy: aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup? = null
        /**
         * The name of the meteric used used when querying an Performance Insights `GetResourceMetrics` API for anomaly metrics.
         *
         * Valid values for `Metric` are:
         * + `db.load.avg` - a scaled representation of the number of active sessions for the database engine.
         * + `db.sampledload.avg` - the raw number of active sessions for the database engine.
         *
         * If the number of active sessions is less than an internal Performance Insights threshold, `db.load.avg` and `db.sampledload.avg` are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with `db.load.avg` showing the scaled values, `db.sampledload.avg` showing the raw values, and `db.sampledload.avg` less than `db.load.avg`. For most use cases, you can query `db.load.avg` only.
         */
        public var metric: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricQuery) : this() {
            this.filter = x.filter
            this.groupBy = x.groupBy
            this.metric = x.metric
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricQuery = PerformanceInsightsMetricQuery(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup] inside the given [block]
         */
        public fun groupBy(block: aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup.Builder.() -> kotlin.Unit) {
            this.groupBy = aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup.invoke(block)
        }
    }
}
