// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Details about Performance Insights metrics.
 *
 * Amazon RDS Performance Insights enables you to monitor and explore different dimensions of database load based on data captured from a running DB instance. DB load is measured as average active sessions. Performance Insights provides the data to API consumers as a two-dimensional time-series dataset. The time dimension provides DB load data for each time point in the queried time range. Each time point decomposes overall load in relation to the requested dimensions, measured at that time point. Examples include SQL, Wait event, User, and Host.
 * + To learn more about Performance Insights and Amazon Aurora DB instances, go to the [ Amazon Aurora User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html).
 * + To learn more about Performance Insights and Amazon RDS DB instances, go to the [ Amazon RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html).
 */
public class PerformanceInsightsMetricsDetail private constructor(builder: Builder) {
    /**
     * The name used for a specific Performance Insights metric.
     */
    public val metricDisplayName: kotlin.String? = builder.metricDisplayName
    /**
     * A single query to be processed for the metric. For more information, see ` <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsMetricQuery.html">PerformanceInsightsMetricQuery</a> `.
     */
    public val metricQuery: aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricQuery? = builder.metricQuery
    /**
     * For more information, see ` <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceData.html">PerformanceInsightsReferenceData</a> `.
     */
    public val referenceData: List<PerformanceInsightsReferenceData>? = builder.referenceData
    /**
     * The metric statistics during the anomalous period detected by DevOps Guru;
     */
    public val statsAtAnomaly: List<PerformanceInsightsStat>? = builder.statsAtAnomaly
    /**
     * Typical metric statistics that are not considered anomalous. When DevOps Guru analyzes metrics, it compares them to `StatsAtBaseline` to help determine if they are anomalous.
     */
    public val statsAtBaseline: List<PerformanceInsightsStat>? = builder.statsAtBaseline
    /**
     * The unit of measure for a metric. For example, a session or a process.
     */
    public val unit: kotlin.String? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricsDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PerformanceInsightsMetricsDetail(")
        append("metricDisplayName=$metricDisplayName,")
        append("metricQuery=$metricQuery,")
        append("referenceData=$referenceData,")
        append("statsAtAnomaly=$statsAtAnomaly,")
        append("statsAtBaseline=$statsAtBaseline,")
        append("unit=$unit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = metricDisplayName?.hashCode() ?: 0
        result = 31 * result + (metricQuery?.hashCode() ?: 0)
        result = 31 * result + (referenceData?.hashCode() ?: 0)
        result = 31 * result + (statsAtAnomaly?.hashCode() ?: 0)
        result = 31 * result + (statsAtBaseline?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PerformanceInsightsMetricsDetail

        if (metricDisplayName != other.metricDisplayName) return false
        if (metricQuery != other.metricQuery) return false
        if (referenceData != other.referenceData) return false
        if (statsAtAnomaly != other.statsAtAnomaly) return false
        if (statsAtBaseline != other.statsAtBaseline) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricsDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name used for a specific Performance Insights metric.
         */
        public var metricDisplayName: kotlin.String? = null
        /**
         * A single query to be processed for the metric. For more information, see ` <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsMetricQuery.html">PerformanceInsightsMetricQuery</a> `.
         */
        public var metricQuery: aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricQuery? = null
        /**
         * For more information, see ` <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceData.html">PerformanceInsightsReferenceData</a> `.
         */
        public var referenceData: List<PerformanceInsightsReferenceData>? = null
        /**
         * The metric statistics during the anomalous period detected by DevOps Guru;
         */
        public var statsAtAnomaly: List<PerformanceInsightsStat>? = null
        /**
         * Typical metric statistics that are not considered anomalous. When DevOps Guru analyzes metrics, it compares them to `StatsAtBaseline` to help determine if they are anomalous.
         */
        public var statsAtBaseline: List<PerformanceInsightsStat>? = null
        /**
         * The unit of measure for a metric. For example, a session or a process.
         */
        public var unit: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricsDetail) : this() {
            this.metricDisplayName = x.metricDisplayName
            this.metricQuery = x.metricQuery
            this.referenceData = x.referenceData
            this.statsAtAnomaly = x.statsAtAnomaly
            this.statsAtBaseline = x.statsAtBaseline
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricsDetail = PerformanceInsightsMetricsDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricQuery] inside the given [block]
         */
        public fun metricQuery(block: aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricQuery.Builder.() -> kotlin.Unit) {
            this.metricQuery = aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricQuery.invoke(block)
        }
    }
}
