// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Information about the health of Amazon Web Services resources in your account that are specified by an Amazon Web Services tag *key*.
 */
public class TagHealth private constructor(builder: Builder) {
    /**
     * Number of resources that DevOps Guru is monitoring in your account that are specified by an Amazon Web Services tag.
     */
    public val analyzedResourceCount: kotlin.Long? = builder.analyzedResourceCount
    /**
     * An Amazon Web Services tag *key* that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this *key* make up your DevOps Guru application and analysis boundary.
     *
     * The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-`. The tag *key* might be `DevOps-Guru-deployment-application` or `devops-guru-rds-application`. When you create a *key*, the case of characters in the *key* can be whatever you choose. After you create a *key*, it is case-sensitive. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS`, and these act as two different *keys*. Possible *key*&#47;*value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers`.
     */
    public val appBoundaryKey: kotlin.String? = builder.appBoundaryKey
    /**
     * Information about the health of the Amazon Web Services resources in your account that are specified by an Amazon Web Services tag, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights.
     */
    public val insight: aws.sdk.kotlin.services.devopsguru.model.InsightHealth? = builder.insight
    /**
     * The value in an Amazon Web Services tag.
     *
     * The tag's *value* is an optional field used to associate a string with the tag *key* (for example, `111122223333`, `Production`, or a team name). The *key* and *value* are the tag's *key* pair. Omitting the tag *value* is the same as using an empty string. Like tag *keys*, tag *values* are case-sensitive. You can specify a maximum of 256 characters for a tag value.
     */
    public val tagValue: kotlin.String? = builder.tagValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.TagHealth = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TagHealth(")
        append("analyzedResourceCount=$analyzedResourceCount,")
        append("appBoundaryKey=$appBoundaryKey,")
        append("insight=$insight,")
        append("tagValue=$tagValue)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzedResourceCount?.hashCode() ?: 0
        result = 31 * result + (appBoundaryKey?.hashCode() ?: 0)
        result = 31 * result + (insight?.hashCode() ?: 0)
        result = 31 * result + (tagValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TagHealth

        if (analyzedResourceCount != other.analyzedResourceCount) return false
        if (appBoundaryKey != other.appBoundaryKey) return false
        if (insight != other.insight) return false
        if (tagValue != other.tagValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.TagHealth = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Number of resources that DevOps Guru is monitoring in your account that are specified by an Amazon Web Services tag.
         */
        public var analyzedResourceCount: kotlin.Long? = null
        /**
         * An Amazon Web Services tag *key* that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this *key* make up your DevOps Guru application and analysis boundary.
         *
         * The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-`. The tag *key* might be `DevOps-Guru-deployment-application` or `devops-guru-rds-application`. When you create a *key*, the case of characters in the *key* can be whatever you choose. After you create a *key*, it is case-sensitive. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS`, and these act as two different *keys*. Possible *key*&#47;*value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers`.
         */
        public var appBoundaryKey: kotlin.String? = null
        /**
         * Information about the health of the Amazon Web Services resources in your account that are specified by an Amazon Web Services tag, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights.
         */
        public var insight: aws.sdk.kotlin.services.devopsguru.model.InsightHealth? = null
        /**
         * The value in an Amazon Web Services tag.
         *
         * The tag's *value* is an optional field used to associate a string with the tag *key* (for example, `111122223333`, `Production`, or a team name). The *key* and *value* are the tag's *key* pair. Omitting the tag *value* is the same as using an empty string. Like tag *keys*, tag *values* are case-sensitive. You can specify a maximum of 256 characters for a tag value.
         */
        public var tagValue: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.TagHealth) : this() {
            this.analyzedResourceCount = x.analyzedResourceCount
            this.appBoundaryKey = x.appBoundaryKey
            this.insight = x.insight
            this.tagValue = x.tagValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.TagHealth = TagHealth(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.InsightHealth] inside the given [block]
         */
        public fun insight(block: aws.sdk.kotlin.services.devopsguru.model.InsightHealth.Builder.() -> kotlin.Unit) {
            this.insight = aws.sdk.kotlin.services.devopsguru.model.InsightHealth.invoke(block)
        }
    }
}
