// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.devopsguru.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.devopsguru.model.*
import aws.sdk.kotlin.services.devopsguru.model.AddNotificationChannelRequest
import aws.sdk.kotlin.services.devopsguru.model.AddNotificationChannelResponse
import aws.sdk.kotlin.services.devopsguru.model.DeleteInsightRequest
import aws.sdk.kotlin.services.devopsguru.model.DeleteInsightResponse
import aws.sdk.kotlin.services.devopsguru.model.DescribeAccountHealthRequest
import aws.sdk.kotlin.services.devopsguru.model.DescribeAccountHealthResponse
import aws.sdk.kotlin.services.devopsguru.model.DescribeAccountOverviewRequest
import aws.sdk.kotlin.services.devopsguru.model.DescribeAccountOverviewResponse
import aws.sdk.kotlin.services.devopsguru.model.DescribeAnomalyRequest
import aws.sdk.kotlin.services.devopsguru.model.DescribeAnomalyResponse
import aws.sdk.kotlin.services.devopsguru.model.DescribeEventSourcesConfigRequest
import aws.sdk.kotlin.services.devopsguru.model.DescribeEventSourcesConfigResponse
import aws.sdk.kotlin.services.devopsguru.model.DescribeFeedbackRequest
import aws.sdk.kotlin.services.devopsguru.model.DescribeFeedbackResponse
import aws.sdk.kotlin.services.devopsguru.model.DescribeInsightRequest
import aws.sdk.kotlin.services.devopsguru.model.DescribeInsightResponse
import aws.sdk.kotlin.services.devopsguru.model.DescribeOrganizationHealthRequest
import aws.sdk.kotlin.services.devopsguru.model.DescribeOrganizationHealthResponse
import aws.sdk.kotlin.services.devopsguru.model.DescribeOrganizationOverviewRequest
import aws.sdk.kotlin.services.devopsguru.model.DescribeOrganizationOverviewResponse
import aws.sdk.kotlin.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest
import aws.sdk.kotlin.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse
import aws.sdk.kotlin.services.devopsguru.model.DescribeResourceCollectionHealthRequest
import aws.sdk.kotlin.services.devopsguru.model.DescribeResourceCollectionHealthResponse
import aws.sdk.kotlin.services.devopsguru.model.DescribeServiceIntegrationRequest
import aws.sdk.kotlin.services.devopsguru.model.DescribeServiceIntegrationResponse
import aws.sdk.kotlin.services.devopsguru.model.GetCostEstimationRequest
import aws.sdk.kotlin.services.devopsguru.model.GetCostEstimationResponse
import aws.sdk.kotlin.services.devopsguru.model.GetResourceCollectionRequest
import aws.sdk.kotlin.services.devopsguru.model.GetResourceCollectionResponse
import aws.sdk.kotlin.services.devopsguru.model.ListAnomaliesForInsightRequest
import aws.sdk.kotlin.services.devopsguru.model.ListAnomaliesForInsightResponse
import aws.sdk.kotlin.services.devopsguru.model.ListAnomalousLogGroupsRequest
import aws.sdk.kotlin.services.devopsguru.model.ListAnomalousLogGroupsResponse
import aws.sdk.kotlin.services.devopsguru.model.ListEventsRequest
import aws.sdk.kotlin.services.devopsguru.model.ListEventsResponse
import aws.sdk.kotlin.services.devopsguru.model.ListInsightsRequest
import aws.sdk.kotlin.services.devopsguru.model.ListInsightsResponse
import aws.sdk.kotlin.services.devopsguru.model.ListMonitoredResourcesRequest
import aws.sdk.kotlin.services.devopsguru.model.ListMonitoredResourcesResponse
import aws.sdk.kotlin.services.devopsguru.model.ListNotificationChannelsRequest
import aws.sdk.kotlin.services.devopsguru.model.ListNotificationChannelsResponse
import aws.sdk.kotlin.services.devopsguru.model.ListOrganizationInsightsRequest
import aws.sdk.kotlin.services.devopsguru.model.ListOrganizationInsightsResponse
import aws.sdk.kotlin.services.devopsguru.model.ListRecommendationsRequest
import aws.sdk.kotlin.services.devopsguru.model.ListRecommendationsResponse
import aws.sdk.kotlin.services.devopsguru.model.PutFeedbackRequest
import aws.sdk.kotlin.services.devopsguru.model.PutFeedbackResponse
import aws.sdk.kotlin.services.devopsguru.model.RemoveNotificationChannelRequest
import aws.sdk.kotlin.services.devopsguru.model.RemoveNotificationChannelResponse
import aws.sdk.kotlin.services.devopsguru.model.SearchInsightsRequest
import aws.sdk.kotlin.services.devopsguru.model.SearchInsightsResponse
import aws.sdk.kotlin.services.devopsguru.model.SearchOrganizationInsightsRequest
import aws.sdk.kotlin.services.devopsguru.model.SearchOrganizationInsightsResponse
import aws.sdk.kotlin.services.devopsguru.model.StartCostEstimationRequest
import aws.sdk.kotlin.services.devopsguru.model.StartCostEstimationResponse
import aws.sdk.kotlin.services.devopsguru.model.UpdateEventSourcesConfigRequest
import aws.sdk.kotlin.services.devopsguru.model.UpdateEventSourcesConfigResponse
import aws.sdk.kotlin.services.devopsguru.model.UpdateResourceCollectionRequest
import aws.sdk.kotlin.services.devopsguru.model.UpdateResourceCollectionResponse
import aws.sdk.kotlin.services.devopsguru.model.UpdateServiceIntegrationRequest
import aws.sdk.kotlin.services.devopsguru.model.UpdateServiceIntegrationResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon DevOps Guru is a fully managed service that helps you identify anomalous behavior in business critical operational applications. You specify the Amazon Web Services resources that you want DevOps Guru to cover, then the Amazon CloudWatch metrics and Amazon Web Services CloudTrail events related to those resources are analyzed. When anomalous behavior is detected, DevOps Guru creates an *insight* that includes recommendations, related events, and related metrics that can help you improve your operational applications. For more information, see [What is Amazon DevOps Guru](https://docs.aws.amazon.com/devops-guru/latest/userguide/welcome.html).
 *
 *  You can specify 1 or 2 Amazon Simple Notification Service topics so you are notified every time a new insight is created. You can also enable DevOps Guru to generate an OpsItem in Amazon Web Services Systems Manager for each insight to help you manage and track your work addressing insights.
 *
 *  To learn about the DevOps Guru workflow, see [How DevOps Guru works](https://docs.aws.amazon.com/devops-guru/latest/userguide/welcome.html#how-it-works). To learn about DevOps Guru concepts, see [Concepts in DevOps Guru](https://docs.aws.amazon.com/devops-guru/latest/userguide/concepts.html).
 */
public interface DevOpsGuruClient : SdkClient {

    override val serviceName: String
        get() = "DevOps Guru"
    /**
     * DevOpsGuruClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): DevOpsGuruClient {
            val config = Config.Builder().apply(block).build()
            return DefaultDevOpsGuruClient(config)
        }

        public operator fun invoke(config: Config): DevOpsGuruClient = DefaultDevOpsGuruClient(config)

        /**
         * Construct a [DevOpsGuruClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): DevOpsGuruClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultDevOpsGuruClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds a notification channel to DevOps Guru. A notification channel is used to notify you about important DevOps Guru events, such as when an insight is generated.
     *
     * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see [Permissions for cross account Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
     *
     * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see Permissions for cross account Amazon SNS topics.
     *
     * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see [Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
     */
    public suspend fun addNotificationChannel(input: AddNotificationChannelRequest): AddNotificationChannelResponse

    /**
     * Deletes the insight along with the associated anomalies, events and recommendations.
     */
    public suspend fun deleteInsight(input: DeleteInsightRequest): DeleteInsightResponse

    /**
     * Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics analyzed in your Amazon Web Services account. Use these numbers to gauge the health of operations in your Amazon Web Services account.
     */
    public suspend fun describeAccountHealth(input: DescribeAccountHealthRequest = DescribeAccountHealthRequest {}): DescribeAccountHealthResponse

    /**
     * For the time range passed in, returns the number of open reactive insight that were created, the number of open proactive insights that were created, and the Mean Time to Recover (MTTR) for all closed reactive insights.
     */
    public suspend fun describeAccountOverview(input: DescribeAccountOverviewRequest): DescribeAccountOverviewResponse

    /**
     * Returns details about an anomaly that you specify using its ID.
     */
    public suspend fun describeAnomaly(input: DescribeAnomalyRequest): DescribeAnomalyResponse

    /**
     * Returns the integration status of services that are integrated with DevOps Guru as Consumer via EventBridge. The one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can be stored and viewed in DevOps Guru.
     */
    public suspend fun describeEventSourcesConfig(input: DescribeEventSourcesConfigRequest = DescribeEventSourcesConfigRequest {}): DescribeEventSourcesConfigResponse

    /**
     * Returns the most recent feedback submitted in the current Amazon Web Services account and Region.
     */
    public suspend fun describeFeedback(input: DescribeFeedbackRequest = DescribeFeedbackRequest {}): DescribeFeedbackResponse

    /**
     * Returns details about an insight that you specify using its ID.
     */
    public suspend fun describeInsight(input: DescribeInsightRequest): DescribeInsightResponse

    /**
     * Returns active insights, predictive insights, and resource hours analyzed in last hour.
     */
    public suspend fun describeOrganizationHealth(input: DescribeOrganizationHealthRequest = DescribeOrganizationHealthRequest {}): DescribeOrganizationHealthResponse

    /**
     * Returns an overview of your organization's history based on the specified time range. The overview includes the total reactive and proactive insights.
     */
    public suspend fun describeOrganizationOverview(input: DescribeOrganizationOverviewRequest): DescribeOrganizationOverviewResponse

    /**
     * Provides an overview of your system's health. If additional member accounts are part of your organization, you can filter those accounts using the `AccountIds` field.
     */
    public suspend fun describeOrganizationResourceCollectionHealth(input: DescribeOrganizationResourceCollectionHealthRequest): DescribeOrganizationResourceCollectionHealthResponse

    /**
     * Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR) for all closed insights in resource collections in your account. You specify the type of Amazon Web Services resources collection. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    public suspend fun describeResourceCollectionHealth(input: DescribeResourceCollectionHealthRequest): DescribeResourceCollectionHealthResponse

    /**
     * Returns the integration status of services that are integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight.
     */
    public suspend fun describeServiceIntegration(input: DescribeServiceIntegrationRequest = DescribeServiceIntegrationRequest {}): DescribeServiceIntegrationResponse

    /**
     * Returns an estimate of the monthly cost for DevOps Guru to analyze your Amazon Web Services resources. For more information, see [Estimate your Amazon DevOps Guru costs](https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html) and [Amazon DevOps Guru pricing](http://aws.amazon.com/devops-guru/pricing/).
     */
    public suspend fun getCostEstimation(input: GetCostEstimationRequest = GetCostEstimationRequest {}): GetCostEstimationResponse

    /**
     * Returns lists Amazon Web Services resources that are of the specified resource collection type. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    public suspend fun getResourceCollection(input: GetResourceCollectionRequest): GetResourceCollectionResponse

    /**
     * Returns a list of the anomalies that belong to an insight that you specify using its ID.
     */
    public suspend fun listAnomaliesForInsight(input: ListAnomaliesForInsightRequest): ListAnomaliesForInsightResponse

    /**
     * Returns the list of log groups that contain log anomalies.
     */
    public suspend fun listAnomalousLogGroups(input: ListAnomalousLogGroupsRequest): ListAnomalousLogGroupsResponse

    /**
     * Returns a list of the events emitted by the resources that are evaluated by DevOps Guru. You can use filters to specify which events are returned.
     */
    public suspend fun listEvents(input: ListEventsRequest): ListEventsResponse

    /**
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time and status (`ONGOING`, `CLOSED`, or `ANY`).
     */
    public suspend fun listInsights(input: ListInsightsRequest): ListInsightsResponse

    /**
     * Returns the list of all log groups that are being monitored and tagged by DevOps Guru.
     */
    public suspend fun listMonitoredResources(input: ListMonitoredResourcesRequest): ListMonitoredResourcesResponse

    /**
     * Returns a list of notification channels configured for DevOps Guru. Each notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS).
     */
    public suspend fun listNotificationChannels(input: ListNotificationChannelsRequest = ListNotificationChannelsRequest {}): ListNotificationChannelsResponse

    /**
     * Returns a list of insights associated with the account or OU Id.
     */
    public suspend fun listOrganizationInsights(input: ListOrganizationInsightsRequest): ListOrganizationInsightsResponse

    /**
     * Returns a list of a specified insight's recommendations. Each recommendation includes a list of related metrics and a list of related events.
     */
    public suspend fun listRecommendations(input: ListRecommendationsRequest): ListRecommendationsResponse

    /**
     * Collects customer feedback about the specified insight.
     */
    public suspend fun putFeedback(input: PutFeedbackRequest = PutFeedbackRequest {}): PutFeedbackResponse

    /**
     * Removes a notification channel from DevOps Guru. A notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations.
     */
    public suspend fun removeNotificationChannel(input: RemoveNotificationChannelRequest): RemoveNotificationChannelResponse

    /**
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time, one or more statuses (`ONGOING`, `CLOSED`, and `CLOSED`), one or more severities (`LOW`, `MEDIUM`, and `HIGH`), and type (`REACTIVE` or `PROACTIVE`).
     *
     *  Use the `Filters` parameter to specify status and severity search parameters. Use the `Type` parameter to specify `REACTIVE` or `PROACTIVE` in your search.
     */
    public suspend fun searchInsights(input: SearchInsightsRequest): SearchInsightsResponse

    /**
     * Returns a list of insights in your organization. You can specify which insights are returned by their start time, one or more statuses (`ONGOING`, `CLOSED`, and `CLOSED`), one or more severities (`LOW`, `MEDIUM`, and `HIGH`), and type (`REACTIVE` or `PROACTIVE`).
     *
     *  Use the `Filters` parameter to specify status and severity search parameters. Use the `Type` parameter to specify `REACTIVE` or `PROACTIVE` in your search.
     */
    public suspend fun searchOrganizationInsights(input: SearchOrganizationInsightsRequest): SearchOrganizationInsightsResponse

    /**
     * Starts the creation of an estimate of the monthly cost to analyze your Amazon Web Services resources.
     */
    public suspend fun startCostEstimation(input: StartCostEstimationRequest): StartCostEstimationResponse

    /**
     * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can be stored and viewed in DevOps Guru.
     */
    public suspend fun updateEventSourcesConfig(input: UpdateEventSourcesConfigRequest = UpdateEventSourcesConfigRequest {}): UpdateEventSourcesConfigResponse

    /**
     * Updates the collection of resources that DevOps Guru analyzes. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks. This method also creates the IAM role required for you to use DevOps Guru.
     */
    public suspend fun updateResourceCollection(input: UpdateResourceCollectionRequest): UpdateResourceCollectionResponse

    /**
     * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight.
     */
    public suspend fun updateServiceIntegration(input: UpdateServiceIntegrationRequest): UpdateServiceIntegrationResponse
}

/**
 * Adds a notification channel to DevOps Guru. A notification channel is used to notify you about important DevOps Guru events, such as when an insight is generated.
 *
 * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see [Permissions for cross account Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
 *
 * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see Permissions for cross account Amazon SNS topics.
 *
 * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see [Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
 */
public suspend inline fun DevOpsGuruClient.addNotificationChannel(crossinline block: AddNotificationChannelRequest.Builder.() -> Unit): AddNotificationChannelResponse = addNotificationChannel(AddNotificationChannelRequest.Builder().apply(block).build())

/**
 * Deletes the insight along with the associated anomalies, events and recommendations.
 */
public suspend inline fun DevOpsGuruClient.deleteInsight(crossinline block: DeleteInsightRequest.Builder.() -> Unit): DeleteInsightResponse = deleteInsight(DeleteInsightRequest.Builder().apply(block).build())

/**
 * Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics analyzed in your Amazon Web Services account. Use these numbers to gauge the health of operations in your Amazon Web Services account.
 */
public suspend inline fun DevOpsGuruClient.describeAccountHealth(crossinline block: DescribeAccountHealthRequest.Builder.() -> Unit): DescribeAccountHealthResponse = describeAccountHealth(DescribeAccountHealthRequest.Builder().apply(block).build())

/**
 * For the time range passed in, returns the number of open reactive insight that were created, the number of open proactive insights that were created, and the Mean Time to Recover (MTTR) for all closed reactive insights.
 */
public suspend inline fun DevOpsGuruClient.describeAccountOverview(crossinline block: DescribeAccountOverviewRequest.Builder.() -> Unit): DescribeAccountOverviewResponse = describeAccountOverview(DescribeAccountOverviewRequest.Builder().apply(block).build())

/**
 * Returns details about an anomaly that you specify using its ID.
 */
public suspend inline fun DevOpsGuruClient.describeAnomaly(crossinline block: DescribeAnomalyRequest.Builder.() -> Unit): DescribeAnomalyResponse = describeAnomaly(DescribeAnomalyRequest.Builder().apply(block).build())

/**
 * Returns the integration status of services that are integrated with DevOps Guru as Consumer via EventBridge. The one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can be stored and viewed in DevOps Guru.
 */
public suspend inline fun DevOpsGuruClient.describeEventSourcesConfig(crossinline block: DescribeEventSourcesConfigRequest.Builder.() -> Unit): DescribeEventSourcesConfigResponse = describeEventSourcesConfig(DescribeEventSourcesConfigRequest.Builder().apply(block).build())

/**
 * Returns the most recent feedback submitted in the current Amazon Web Services account and Region.
 */
public suspend inline fun DevOpsGuruClient.describeFeedback(crossinline block: DescribeFeedbackRequest.Builder.() -> Unit): DescribeFeedbackResponse = describeFeedback(DescribeFeedbackRequest.Builder().apply(block).build())

/**
 * Returns details about an insight that you specify using its ID.
 */
public suspend inline fun DevOpsGuruClient.describeInsight(crossinline block: DescribeInsightRequest.Builder.() -> Unit): DescribeInsightResponse = describeInsight(DescribeInsightRequest.Builder().apply(block).build())

/**
 * Returns active insights, predictive insights, and resource hours analyzed in last hour.
 */
public suspend inline fun DevOpsGuruClient.describeOrganizationHealth(crossinline block: DescribeOrganizationHealthRequest.Builder.() -> Unit): DescribeOrganizationHealthResponse = describeOrganizationHealth(DescribeOrganizationHealthRequest.Builder().apply(block).build())

/**
 * Returns an overview of your organization's history based on the specified time range. The overview includes the total reactive and proactive insights.
 */
public suspend inline fun DevOpsGuruClient.describeOrganizationOverview(crossinline block: DescribeOrganizationOverviewRequest.Builder.() -> Unit): DescribeOrganizationOverviewResponse = describeOrganizationOverview(DescribeOrganizationOverviewRequest.Builder().apply(block).build())

/**
 * Provides an overview of your system's health. If additional member accounts are part of your organization, you can filter those accounts using the `AccountIds` field.
 */
public suspend inline fun DevOpsGuruClient.describeOrganizationResourceCollectionHealth(crossinline block: DescribeOrganizationResourceCollectionHealthRequest.Builder.() -> Unit): DescribeOrganizationResourceCollectionHealthResponse = describeOrganizationResourceCollectionHealth(DescribeOrganizationResourceCollectionHealthRequest.Builder().apply(block).build())

/**
 * Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR) for all closed insights in resource collections in your account. You specify the type of Amazon Web Services resources collection. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
 */
public suspend inline fun DevOpsGuruClient.describeResourceCollectionHealth(crossinline block: DescribeResourceCollectionHealthRequest.Builder.() -> Unit): DescribeResourceCollectionHealthResponse = describeResourceCollectionHealth(DescribeResourceCollectionHealthRequest.Builder().apply(block).build())

/**
 * Returns the integration status of services that are integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight.
 */
public suspend inline fun DevOpsGuruClient.describeServiceIntegration(crossinline block: DescribeServiceIntegrationRequest.Builder.() -> Unit): DescribeServiceIntegrationResponse = describeServiceIntegration(DescribeServiceIntegrationRequest.Builder().apply(block).build())

/**
 * Returns an estimate of the monthly cost for DevOps Guru to analyze your Amazon Web Services resources. For more information, see [Estimate your Amazon DevOps Guru costs](https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html) and [Amazon DevOps Guru pricing](http://aws.amazon.com/devops-guru/pricing/).
 */
public suspend inline fun DevOpsGuruClient.getCostEstimation(crossinline block: GetCostEstimationRequest.Builder.() -> Unit): GetCostEstimationResponse = getCostEstimation(GetCostEstimationRequest.Builder().apply(block).build())

/**
 * Returns lists Amazon Web Services resources that are of the specified resource collection type. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
 */
public suspend inline fun DevOpsGuruClient.getResourceCollection(crossinline block: GetResourceCollectionRequest.Builder.() -> Unit): GetResourceCollectionResponse = getResourceCollection(GetResourceCollectionRequest.Builder().apply(block).build())

/**
 * Returns a list of the anomalies that belong to an insight that you specify using its ID.
 */
public suspend inline fun DevOpsGuruClient.listAnomaliesForInsight(crossinline block: ListAnomaliesForInsightRequest.Builder.() -> Unit): ListAnomaliesForInsightResponse = listAnomaliesForInsight(ListAnomaliesForInsightRequest.Builder().apply(block).build())

/**
 * Returns the list of log groups that contain log anomalies.
 */
public suspend inline fun DevOpsGuruClient.listAnomalousLogGroups(crossinline block: ListAnomalousLogGroupsRequest.Builder.() -> Unit): ListAnomalousLogGroupsResponse = listAnomalousLogGroups(ListAnomalousLogGroupsRequest.Builder().apply(block).build())

/**
 * Returns a list of the events emitted by the resources that are evaluated by DevOps Guru. You can use filters to specify which events are returned.
 */
public suspend inline fun DevOpsGuruClient.listEvents(crossinline block: ListEventsRequest.Builder.() -> Unit): ListEventsResponse = listEvents(ListEventsRequest.Builder().apply(block).build())

/**
 * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time and status (`ONGOING`, `CLOSED`, or `ANY`).
 */
public suspend inline fun DevOpsGuruClient.listInsights(crossinline block: ListInsightsRequest.Builder.() -> Unit): ListInsightsResponse = listInsights(ListInsightsRequest.Builder().apply(block).build())

/**
 * Returns the list of all log groups that are being monitored and tagged by DevOps Guru.
 */
public suspend inline fun DevOpsGuruClient.listMonitoredResources(crossinline block: ListMonitoredResourcesRequest.Builder.() -> Unit): ListMonitoredResourcesResponse = listMonitoredResources(ListMonitoredResourcesRequest.Builder().apply(block).build())

/**
 * Returns a list of notification channels configured for DevOps Guru. Each notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS).
 */
public suspend inline fun DevOpsGuruClient.listNotificationChannels(crossinline block: ListNotificationChannelsRequest.Builder.() -> Unit): ListNotificationChannelsResponse = listNotificationChannels(ListNotificationChannelsRequest.Builder().apply(block).build())

/**
 * Returns a list of insights associated with the account or OU Id.
 */
public suspend inline fun DevOpsGuruClient.listOrganizationInsights(crossinline block: ListOrganizationInsightsRequest.Builder.() -> Unit): ListOrganizationInsightsResponse = listOrganizationInsights(ListOrganizationInsightsRequest.Builder().apply(block).build())

/**
 * Returns a list of a specified insight's recommendations. Each recommendation includes a list of related metrics and a list of related events.
 */
public suspend inline fun DevOpsGuruClient.listRecommendations(crossinline block: ListRecommendationsRequest.Builder.() -> Unit): ListRecommendationsResponse = listRecommendations(ListRecommendationsRequest.Builder().apply(block).build())

/**
 * Collects customer feedback about the specified insight.
 */
public suspend inline fun DevOpsGuruClient.putFeedback(crossinline block: PutFeedbackRequest.Builder.() -> Unit): PutFeedbackResponse = putFeedback(PutFeedbackRequest.Builder().apply(block).build())

/**
 * Removes a notification channel from DevOps Guru. A notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations.
 */
public suspend inline fun DevOpsGuruClient.removeNotificationChannel(crossinline block: RemoveNotificationChannelRequest.Builder.() -> Unit): RemoveNotificationChannelResponse = removeNotificationChannel(RemoveNotificationChannelRequest.Builder().apply(block).build())

/**
 * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time, one or more statuses (`ONGOING`, `CLOSED`, and `CLOSED`), one or more severities (`LOW`, `MEDIUM`, and `HIGH`), and type (`REACTIVE` or `PROACTIVE`).
 *
 *  Use the `Filters` parameter to specify status and severity search parameters. Use the `Type` parameter to specify `REACTIVE` or `PROACTIVE` in your search.
 */
public suspend inline fun DevOpsGuruClient.searchInsights(crossinline block: SearchInsightsRequest.Builder.() -> Unit): SearchInsightsResponse = searchInsights(SearchInsightsRequest.Builder().apply(block).build())

/**
 * Returns a list of insights in your organization. You can specify which insights are returned by their start time, one or more statuses (`ONGOING`, `CLOSED`, and `CLOSED`), one or more severities (`LOW`, `MEDIUM`, and `HIGH`), and type (`REACTIVE` or `PROACTIVE`).
 *
 *  Use the `Filters` parameter to specify status and severity search parameters. Use the `Type` parameter to specify `REACTIVE` or `PROACTIVE` in your search.
 */
public suspend inline fun DevOpsGuruClient.searchOrganizationInsights(crossinline block: SearchOrganizationInsightsRequest.Builder.() -> Unit): SearchOrganizationInsightsResponse = searchOrganizationInsights(SearchOrganizationInsightsRequest.Builder().apply(block).build())

/**
 * Starts the creation of an estimate of the monthly cost to analyze your Amazon Web Services resources.
 */
public suspend inline fun DevOpsGuruClient.startCostEstimation(crossinline block: StartCostEstimationRequest.Builder.() -> Unit): StartCostEstimationResponse = startCostEstimation(StartCostEstimationRequest.Builder().apply(block).build())

/**
 * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can be stored and viewed in DevOps Guru.
 */
public suspend inline fun DevOpsGuruClient.updateEventSourcesConfig(crossinline block: UpdateEventSourcesConfigRequest.Builder.() -> Unit): UpdateEventSourcesConfigResponse = updateEventSourcesConfig(UpdateEventSourcesConfigRequest.Builder().apply(block).build())

/**
 * Updates the collection of resources that DevOps Guru analyzes. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks. This method also creates the IAM role required for you to use DevOps Guru.
 */
public suspend inline fun DevOpsGuruClient.updateResourceCollection(crossinline block: UpdateResourceCollectionRequest.Builder.() -> Unit): UpdateResourceCollectionResponse = updateResourceCollection(UpdateResourceCollectionRequest.Builder().apply(block).build())

/**
 * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight.
 */
public suspend inline fun DevOpsGuruClient.updateServiceIntegration(crossinline block: UpdateServiceIntegrationRequest.Builder.() -> Unit): UpdateServiceIntegrationResponse = updateServiceIntegration(UpdateServiceIntegrationRequest.Builder().apply(block).build())
